/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class FrostRay
extends SpellRay {
    public FrostRay() {
        super("frost_ray", SpellActions.POINT, true);
        this.particleVelocity(1.0);
        this.particleSpacing(0.5);
        this.addProperties("damage", "effect_duration", "effect_strength");
    }

    @Override
    protected SoundEvent[] createSounds() {
        return this.createContinuousSpellSounds();
    }

    @Override
    protected void playSound(World world, EntityLivingBase entity, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, entity, ticksInUse);
    }

    @Override
    protected void playSound(World world, double x, double y, double z, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, x, y, z, ticksInUse, duration);
    }

    @Override
    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (EntityUtils.isLiving(target)) {
            if (target.func_70027_ad()) {
                target.func_70066_B();
            }
            if (MagicDamage.isEntityImmune(MagicDamage.DamageType.FROST, target)) {
                if (!world.field_72995_K && ticksInUse == 1 && caster instanceof EntityPlayer) {
                    ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getNameForTranslationFormatted()}), true);
                }
            } else if (ticksInUse % ((EntityLivingBase)target).field_70771_an == 1) {
                ((EntityLivingBase)target).func_70690_d(new PotionEffect(WizardryPotions.frost, (int)(this.getProperty("effect_duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade)), this.getProperty("effect_strength").intValue()));
                float damage = this.getProperty("damage").floatValue() * modifiers.get("potency");
                if (target instanceof EntityBlaze || target instanceof EntityMagmaCube) {
                    damage *= 2.0f;
                }
                EntityUtils.attackEntityWithoutKnockback(target, MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.FROST), damage);
            }
        }
        return true;
    }

    @Override
    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    @Override
    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    @Override
    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        float brightness = world.field_73012_v.nextFloat();
        ParticleBuilder.create(ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(vx, vy, vz).time(8 + world.field_73012_v.nextInt(12)).clr(0.4f + 0.6f * brightness, 0.6f + 0.4f * brightness, 1.0f).collide(true).spawn(world);
        ParticleBuilder.create(ParticleBuilder.Type.SNOW).pos(x, y, z).vel(vx, vy, vz).time(8 + world.field_73012_v.nextInt(12)).collide(true).spawn(world);
    }
}

