/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.GeometryUtils;
import electroblob.wizardry.util.RayTracer;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class PhaseStep
extends Spell {
    public static final String WALL_THICKNESS = "wall_thickness";

    public PhaseStep() {
        super("phase_step", SpellActions.POINT, false);
        this.addProperties("range", WALL_THICKNESS);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        EntityPlayer toTeleport;
        boolean teleportMount = caster.func_184218_aH() && ItemArtefact.isArtefactActive(caster, WizardryItems.charm_mount_teleporting);
        boolean hitLiquids = teleportMount && caster.func_184187_bx() instanceof EntityBoat;
        double range = this.getProperty("range").floatValue() * modifiers.get(WizardryItems.range_upgrade);
        RayTraceResult rayTrace = RayTracer.standardBlockRayTrace(world, (EntityLivingBase)caster, range, hitLiquids, !hitLiquids, false);
        if (world.field_72995_K) {
            for (int i = 0; i < 10; ++i) {
                double dx1 = caster.field_70165_t;
                double dy1 = caster.field_70163_u + (double)(2.0f * world.field_73012_v.nextFloat());
                double dz1 = caster.field_70161_v;
                world.func_175688_a(EnumParticleTypes.PORTAL, dx1, dy1, dz1, world.field_73012_v.nextDouble() - 0.5, world.field_73012_v.nextDouble() - 0.5, world.field_73012_v.nextDouble() - 0.5, new int[0]);
            }
            Wizardry.proxy.playBlinkEffect(caster);
        }
        Object object = toTeleport = teleportMount ? caster.func_184187_bx() : caster;
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos1;
            BlockPos pos = rayTrace.func_178782_a();
            int maxThickness = this.getProperty(WALL_THICKNESS).intValue() + (int)((modifiers.get(WizardryItems.range_upgrade) - 1.0f) / 0.25f + 0.5f);
            if (rayTrace.field_178784_b == EnumFacing.UP) {
                ++maxThickness;
            }
            for (int i = 0; i <= maxThickness && (!BlockUtils.isBlockUnbreakable(world, pos1 = pos.func_177967_a(rayTrace.field_178784_b.func_176734_d(), i)) && !BlockUtils.isBlockUnbreakable(world, pos1.func_177984_a()) || Wizardry.settings.teleportThroughUnbreakableBlocks); ++i) {
                Vec3d vec = GeometryUtils.getFaceCentre(pos1, EnumFacing.DOWN);
                if (!this.attemptTeleport(world, (Entity)toTeleport, vec, teleportMount, caster, ticksInUse, modifiers)) continue;
                return true;
            }
            Vec3d vec = GeometryUtils.getFaceCentre(pos = pos.func_177972_a(rayTrace.field_178784_b), EnumFacing.DOWN);
            if (this.attemptTeleport(world, (Entity)toTeleport, vec, teleportMount, caster, ticksInUse, modifiers)) {
                return true;
            }
        } else {
            Vec3d vec = caster.func_174791_d().func_178787_e(caster.func_70040_Z().func_186678_a(range));
            if (this.attemptTeleport(world, (Entity)toTeleport, vec, teleportMount, caster, ticksInUse, modifiers)) {
                return true;
            }
        }
        return false;
    }

    protected boolean attemptTeleport(World world, Entity toTeleport, Vec3d destination, boolean teleportMount, EntityPlayer caster, int ticksInUse, SpellModifiers modifiers) {
        if ((destination = EntityUtils.findSpaceForTeleport(toTeleport, destination, teleportMount)) != null) {
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
            if (!teleportMount && caster.func_184218_aH()) {
                caster.func_184210_p();
            }
            if (!world.field_72995_K) {
                toTeleport.func_70634_a(destination.field_72450_a, destination.field_72448_b, destination.field_72449_c);
            }
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
            return true;
        }
        return false;
    }
}

