/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class Transience
extends Spell {
    public static final ResourceLocation SHADER = new ResourceLocation("ebwizardry", "shaders/post/transience.json");

    public Transience() {
        super("transience", SpellActions.POINT_UP, false);
        this.addProperties("effect_duration");
    }

    @Override
    public boolean requiresPacket() {
        return true;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (world.field_72995_K) {
            Wizardry.proxy.loadShader(caster, SHADER);
            Wizardry.proxy.playBlinkEffect(caster);
        }
        if (!caster.func_70644_a(WizardryPotions.transience)) {
            if (!world.field_72995_K) {
                int duration = (int)(this.getProperty("effect_duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade));
                caster.func_70690_d(new PotionEffect(WizardryPotions.transience, duration, 0));
                caster.func_70690_d(new PotionEffect(MobEffects.field_76441_p, duration, 0, false, false));
                this.playSound(world, (EntityLivingBase)caster, ticksInUse, duration, modifiers, new String[0]);
            }
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onLivingAttackEvent(LivingAttackEvent event) {
        if (event.getSource() != null) {
            if (event.getEntityLiving().func_70644_a(WizardryPotions.transience) && event.getSource() != DamageSource.field_76380_i) {
                event.setCanceled(true);
            }
            if (event.getSource().func_76346_g() instanceof EntityLivingBase && ((EntityLivingBase)event.getSource().func_76346_g()).func_70644_a(WizardryPotions.transience)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerInteractEvent(PlayerInteractEvent event) {
        if (event.isCancelable() && event.getEntityPlayer().func_70644_a(WizardryPotions.transience)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPotionAddedEvent(PotionEvent.PotionAddedEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K && event.getPotionEffect().func_188419_a() == WizardryPotions.transience && event.getEntity() instanceof EntityPlayer) {
            Wizardry.proxy.loadShader((EntityPlayer)event.getEntity(), SHADER);
            Wizardry.proxy.playBlinkEffect((EntityPlayer)event.getEntity());
        }
    }
}

