/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.util;

import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class GeometryUtils {
    public static final double ANTI_Z_FIGHTING_OFFSET = 0.005;

    private GeometryUtils() {
    }

    public static Vec3d getCentre(BlockPos pos) {
        return new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5);
    }

    public static Vec3d getCentre(AxisAlignedBB box) {
        return new Vec3d(box.field_72340_a + (box.field_72336_d - box.field_72340_a) * 0.5, box.field_72338_b + (box.field_72337_e - box.field_72338_b) * 0.5, box.field_72339_c + (box.field_72334_f - box.field_72339_c) * 0.5);
    }

    public static Vec3d getCentre(Entity entity) {
        return new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)(entity.field_70131_O / 2.0f), entity.field_70161_v);
    }

    public static Vec3d getFaceCentre(BlockPos pos, EnumFacing face) {
        return GeometryUtils.getCentre(pos).func_178787_e(new Vec3d(face.func_176730_m()).func_186678_a(0.5));
    }

    public static double component(Vec3d vec, EnumFacing.Axis axis) {
        return (new double[]{vec.field_72450_a, vec.field_72448_b, vec.field_72449_c})[axis.ordinal()];
    }

    public static int component(Vec3i vec, EnumFacing.Axis axis) {
        return (new int[]{vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p()})[axis.ordinal()];
    }

    public static Vec3d replaceComponent(Vec3d vec, EnumFacing.Axis axis, double newValue) {
        double[] components = new double[]{vec.field_72450_a, vec.field_72448_b, vec.field_72449_c};
        components[axis.ordinal()] = newValue;
        return new Vec3d(components[0], components[1], components[2]);
    }

    public static Vec3i replaceComponent(Vec3i vec, EnumFacing.Axis axis, int newValue) {
        int[] components = new int[]{vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p()};
        components[axis.ordinal()] = newValue;
        return new Vec3i(components[0], components[1], components[2]);
    }

    public static Vec3d horizontalise(Vec3d vec) {
        return GeometryUtils.replaceComponent(vec, EnumFacing.Axis.Y, 0.0).func_72432_b();
    }

    public static Vec3d[] getVertices(AxisAlignedBB box) {
        return new Vec3d[]{new Vec3d(box.field_72340_a, box.field_72338_b, box.field_72339_c), new Vec3d(box.field_72336_d, box.field_72338_b, box.field_72339_c), new Vec3d(box.field_72336_d, box.field_72338_b, box.field_72334_f), new Vec3d(box.field_72340_a, box.field_72338_b, box.field_72334_f), new Vec3d(box.field_72340_a, box.field_72337_e, box.field_72339_c), new Vec3d(box.field_72336_d, box.field_72337_e, box.field_72339_c), new Vec3d(box.field_72336_d, box.field_72337_e, box.field_72334_f), new Vec3d(box.field_72340_a, box.field_72337_e, box.field_72334_f)};
    }

    public static Vec3d[] getVertices(World world, BlockPos pos) {
        return GeometryUtils.getVertices(world.func_180495_p(pos).func_185900_c((IBlockAccess)world, pos).func_72317_d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()));
    }

    public static float getPitch(EnumFacing facing) {
        return facing == EnumFacing.UP ? 90.0f : (facing == EnumFacing.DOWN ? -90.0f : 0.0f);
    }
}

