/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.util;

import electroblob.wizardry.entity.ICustomHitbox;
import electroblob.wizardry.util.EntityUtils;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public final class RayTracer {
    private RayTracer() {
    }

    @Nullable
    public static RayTraceResult standardBlockRayTrace(World world, EntityLivingBase entity, double range, boolean hitLiquids, boolean ignoreUncollidables, boolean returnLastUncollidable) {
        Vec3d origin = entity.func_174824_e(1.0f);
        Vec3d endpoint = origin.func_178787_e(entity.func_70040_Z().func_186678_a(range));
        return world.func_147447_a(origin, endpoint, hitLiquids, ignoreUncollidables, returnLastUncollidable);
    }

    @Nullable
    public static RayTraceResult standardBlockRayTrace(World world, EntityLivingBase entity, double range, boolean hitLiquids) {
        return RayTracer.standardBlockRayTrace(world, entity, range, hitLiquids, false, false);
    }

    @Nullable
    public static RayTraceResult standardEntityRayTrace(World world, Entity entity, double range, boolean hitLiquids) {
        Vec3d origin = entity.func_174824_e(1.0f);
        Vec3d endpoint = origin.func_178787_e(entity.func_70040_Z().func_186678_a(range));
        return RayTracer.rayTrace(world, origin, endpoint, 0.0f, hitLiquids, false, false, Entity.class, RayTracer.ignoreEntityFilter(entity));
    }

    public static Predicate<Entity> ignoreEntityFilter(Entity entity) {
        return e -> e == entity || e instanceof EntityLivingBase && ((EntityLivingBase)e).field_70725_aQ > 0;
    }

    @Nullable
    public static RayTraceResult rayTrace(World world, Vec3d origin, Vec3d endpoint, float aimAssist, boolean hitLiquids, boolean ignoreUncollidables, boolean returnLastUncollidable, Class<? extends Entity> entityType, Predicate<? super Entity> filter) {
        float borderSize = 1.0f + aimAssist;
        AxisAlignedBB searchVolume = new AxisAlignedBB(origin.field_72450_a, origin.field_72448_b, origin.field_72449_c, endpoint.field_72450_a, endpoint.field_72448_b, endpoint.field_72449_c).func_72314_b((double)borderSize, (double)borderSize, (double)borderSize);
        List entities = world.func_72872_a(entityType, searchVolume);
        entities.removeIf(filter);
        RayTraceResult result = world.func_147447_a(origin, endpoint, hitLiquids, ignoreUncollidables, returnLastUncollidable);
        if (result != null) {
            endpoint = result.field_72307_f;
        }
        Entity closestHitEntity = null;
        Vec3d closestHitPosition = endpoint;
        Vec3d intercept = null;
        for (Entity entity : entities) {
            float closestHitDistance;
            float currentHitDistance;
            float fuzziness;
            float f = fuzziness = EntityUtils.isLiving(entity) ? aimAssist : 0.0f;
            if (entity instanceof ICustomHitbox) {
                intercept = ((ICustomHitbox)entity).calculateIntercept(origin, endpoint, fuzziness);
            } else {
                AxisAlignedBB entityBounds = entity.func_174813_aQ();
                if (entityBounds != null) {
                    RayTraceResult hit;
                    float entityBorderSize = entity.func_70111_Y();
                    if (entityBorderSize != 0.0f) {
                        entityBounds = entityBounds.func_72314_b((double)entityBorderSize, (double)entityBorderSize, (double)entityBorderSize);
                    }
                    if (fuzziness != 0.0f) {
                        entityBounds = entityBounds.func_72314_b((double)fuzziness, (double)fuzziness, (double)fuzziness);
                    }
                    if ((hit = entityBounds.func_72327_a(origin, endpoint)) != null) {
                        intercept = hit.field_72307_f;
                    }
                }
            }
            if (intercept == null || !((currentHitDistance = (float)intercept.func_72438_d(origin)) < (closestHitDistance = (float)closestHitPosition.func_72438_d(origin)))) continue;
            closestHitEntity = entity;
            closestHitPosition = intercept;
        }
        if (closestHitEntity != null) {
            result = new RayTraceResult(closestHitEntity, closestHitPosition);
        }
        return result;
    }
}

