/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.gui;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.block.BlockBookshelf;
import electroblob.wizardry.client.DrawingUtils;
import electroblob.wizardry.client.gui.GuiButtonInvisible;
import electroblob.wizardry.client.gui.GuiButtonSpellSort;
import electroblob.wizardry.client.gui.GuiButtonTurnPage;
import electroblob.wizardry.client.gui.GuiSpellInfo;
import electroblob.wizardry.data.SpellGlyphData;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.packet.PacketLectern;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.tileentity.TileEntityLectern;
import electroblob.wizardry.util.GeometryUtils;
import electroblob.wizardry.util.ISpellSortable;
import electroblob.wizardry.util.ParticleBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketCloseWindow;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiLectern
extends GuiSpellInfo
implements ISpellSortable {
    private static final ResourceLocation TEXTURE = new ResourceLocation("ebwizardry", "textures/gui/container/lectern.png");
    private static final int PAGE_BUTTON_INSET_X = 22;
    private static final int PAGE_BUTTON_INSET_Y = 13;
    private static final int PAGE_BUTTON_SPACING = 20;
    private static final int SORT_BUTTON_INSET_X = 96;
    private static final int SORT_BUTTON_INSET_Y = 20;
    private static final int SORT_BUTTON_SPACING = 13;
    private static final int SPELL_BUTTON_INSET_X = 23;
    private static final int SPELL_BUTTON_INSET_Y = 44;
    private static final int SPELL_BUTTON_SPACING = 38;
    private static final int SPELL_ROWS = 3;
    private static final int SPELL_COLUMNS = 3;
    public static final int SPELL_BUTTON_COUNT = 18;
    private static final int SEARCH_TOOLTIP_HOVER_TIME = 20;
    private static final Style TOOLTIP_SYNTAX = new Style().func_150238_a(TextFormatting.YELLOW);
    private static final Style TOOLTIP_BODY = new Style().func_150238_a(TextFormatting.WHITE);
    private final TileEntityLectern lectern;
    private GuiButton nextPageButton;
    private GuiButton prevPageButton;
    private GuiButton lastPageButton;
    private GuiButton firstPageButton;
    private GuiButton indexButton;
    private GuiButton locateButton;
    private GuiButton[] sortButtons = new GuiButton[3];
    private GuiButtonSpell[] spellButtons = new GuiButtonSpell[18];
    private Spell currentSpell;
    private List<Spell> availableSpells = new ArrayList<Spell>();
    private List<Spell> matchingSpells;
    private ISpellSortable.SortType sortType = ISpellSortable.SortType.TIER;
    private boolean sortDescending = false;
    private GuiTextField searchField;
    private boolean searchNeedsClearing;
    private int searchBarHoverTime;
    private int currentPage = 0;

    public GuiLectern(TileEntityLectern lectern) {
        super(288, 180);
        this.lectern = lectern;
        this.currentSpell = lectern.currentSpell;
        this.setTextureSize(512, 512);
    }

    @Override
    public Spell getSpell() {
        return this.currentSpell;
    }

    @Override
    public ResourceLocation getTexture() {
        return TEXTURE;
    }

    @Override
    public ISpellSortable.SortType getSortType() {
        return this.sortType;
    }

    @Override
    public boolean isSortDescending() {
        return this.sortDescending;
    }

    private int getPageCount() {
        return MathHelper.func_76123_f((float)((float)this.matchingSpells.size() / 18.0f));
    }

    private Spell getSpellForButton(GuiButtonSpell button) {
        return this.matchingSpells.get(this.currentPage * 18 + button.index);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int left = this.field_146294_l / 2 - this.xSize / 2;
        int top = this.field_146295_m / 2 - this.ySize / 2;
        int buttonID = 0;
        this.nextPageButton = new GuiButtonTurnPage(buttonID++, left + this.xSize - 22 - 20, top + this.ySize - 13 - 12, GuiButtonTurnPage.Type.NEXT_PAGE, TEXTURE, this.textureWidth, this.textureHeight);
        this.field_146292_n.add(this.nextPageButton);
        this.prevPageButton = new GuiButtonTurnPage(buttonID++, left + 22, top + this.ySize - 13 - 12, GuiButtonTurnPage.Type.PREVIOUS_PAGE, TEXTURE, this.textureWidth, this.textureHeight);
        this.field_146292_n.add(this.prevPageButton);
        this.lastPageButton = new GuiButtonTurnPage(buttonID++, left + this.xSize - 22 - 20 - 20, top + this.ySize - 13 - 12, GuiButtonTurnPage.Type.NEXT_SECTION, TEXTURE, this.textureWidth, this.textureHeight);
        this.field_146292_n.add(this.lastPageButton);
        this.firstPageButton = new GuiButtonTurnPage(buttonID++, left + 22 + 20, top + this.ySize - 13 - 12, GuiButtonTurnPage.Type.PREVIOUS_SECTION, TEXTURE, this.textureWidth, this.textureHeight);
        this.field_146292_n.add(this.firstPageButton);
        this.indexButton = new GuiButtonTurnPage(buttonID++, left + this.xSize / 2 - 23, top + this.ySize - 13 - 12, GuiButtonTurnPage.Type.CONTENTS, TEXTURE, this.textureWidth, this.textureHeight);
        this.field_146292_n.add(this.indexButton);
        this.locateButton = new GuiButtonLocateBook(buttonID++, left + this.xSize / 2 - 34, top + this.ySize - 13 - 12);
        this.field_146292_n.add(this.locateButton);
        for (ISpellSortable.SortType sortType : ISpellSortable.SortType.values()) {
            GuiButtonSpellSort guiButtonSpellSort = new GuiButtonSpellSort(buttonID++, left + 96 + 13 * sortType.ordinal(), top + 20, sortType, this, this);
            this.sortButtons[sortType.ordinal()] = guiButtonSpellSort;
            this.field_146292_n.add(guiButtonSpellSort);
        }
        for (int i = 0; i < 18; ++i) {
            int row = i % 3;
            int column = i / 3 % 3;
            int x = i < 9 ? 23 + row * 38 : this.xSize - 23 - 34 - (2 - row) * 38;
            int y = 44 + column * 38;
            this.spellButtons[i] = new GuiButtonSpell(buttonID++, left + x, top + y, i);
            this.field_146292_n.add(this.spellButtons[i]);
        }
        this.searchField = new GuiTextField(0, this.field_146289_q, left + 157, top + 21, 106, this.field_146289_q.field_78288_b);
        this.searchField.func_146203_f(50);
        this.searchField.func_146185_a(false);
        this.searchField.func_146189_e(true);
        this.searchField.func_146193_g(0xFFFFFF);
        this.searchField.func_146205_d(false);
        this.searchField.func_146195_b(true);
        this.refreshAvailableSpells();
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.searchBarHoverTime > 0 && this.searchBarHoverTime < 20) {
            ++this.searchBarHoverTime;
        }
    }

    @Override
    public void func_146281_b() {
        WizardryPacketHandler.net.sendToServer((IMessage)new PacketLectern.Message(this.lectern.func_174877_v(), this.currentSpell));
        super.func_146281_b();
    }

    @Override
    protected void drawBackgroundLayer(int left, int top, int mouseX, int mouseY) {
        if (this.currentSpell == Spells.none) {
            this.drawIndexPage(left, top);
        } else {
            super.drawBackgroundLayer(left, top, mouseX, mouseY);
        }
    }

    @Override
    protected void drawForegroundLayer(int left, int top, int mouseX, int mouseY) {
        if (this.currentSpell == Spells.none) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.ebwizardry:lectern.title", (Object[])new Object[0]), left + 20, top + 20, 0);
        } else {
            super.drawForegroundLayer(left, top, mouseX, mouseY);
        }
        this.field_146292_n.forEach(b -> b.func_146111_b(mouseX, mouseY));
        if (DrawingUtils.isPointInRegion(this.searchField.field_146209_f, this.searchField.field_146210_g, this.searchField.field_146218_h, this.searchField.field_146219_i, mouseX, mouseY)) {
            if (this.searchBarHoverTime == 0) {
                ++this.searchBarHoverTime;
            } else if (this.searchBarHoverTime == 20) {
                this.func_146279_a(I18n.func_135052_a((String)"container.ebwizardry:arcane_workbench.search_tooltip", (Object[])new Object[]{TOOLTIP_SYNTAX.func_150218_j(), TOOLTIP_BODY.func_150218_j()}), mouseX, mouseY);
            }
        } else {
            this.searchBarHoverTime = 0;
        }
    }

    private void drawIndexPage(int left, int top) {
        for (int i = 0; i < 18; ++i) {
            int index = this.currentPage * 18 + i;
            Spell spell = index < this.matchingSpells.size() ? this.matchingSpells.get(index) : Spells.none;
            boolean discovered = Wizardry.proxy.shouldDisplayDiscovered(spell, null);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(discovered ? spell.getIcon() : Spells.none.getIcon());
            int row = i % 3;
            int column = i / 3 % 3;
            int x = i < 9 ? 23 + row * 38 : this.xSize - 23 - 34 - (2 - row) * 38;
            int y = 44 + column * 38;
            DrawingUtils.drawTexturedRect(left + x + 1, top + y + 1, 0, 0, 32, 32, 32, 32);
        }
        this.field_146297_k.field_71446_o.func_110577_a(this.getTexture());
        DrawingUtils.drawTexturedRect(left, top, 0, 256, this.xSize, this.ySize, this.textureWidth, this.textureHeight);
        this.searchField.func_146194_f();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this.getTexture());
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.searchNeedsClearing = true;
    }

    protected void func_146284_a(GuiButton button) {
        int lastPage = this.getPageCount() - 1;
        if (button == this.indexButton) {
            this.currentSpell = Spells.none;
        } else if (button == this.locateButton) {
            this.field_146297_k.field_71439_g.field_71174_a.func_147297_a((Packet)new CPacketCloseWindow(this.field_146297_k.field_71439_g.field_71070_bA.field_75152_c));
            this.field_146297_k.func_147108_a(null);
            block0: for (IInventory bookshelf : BlockBookshelf.findNearbyBookshelves(this.lectern.func_145831_w(), this.lectern.func_174877_v(), new TileEntity[0])) {
                for (int i = 0; i < bookshelf.func_70302_i_(); ++i) {
                    Spell spell;
                    ItemStack stack = bookshelf.func_70301_a(i);
                    if (!(stack.func_77973_b() instanceof ItemSpellBook) || (spell = Spell.byMetadata(stack.func_77960_j())) != this.currentSpell) continue;
                    BlockPos pos = ((TileEntity)bookshelf).func_174877_v();
                    for (EnumFacing side : EnumFacing.field_82609_l) {
                        ParticleBuilder.create(ParticleBuilder.Type.BLOCK_HIGHLIGHT).pos(GeometryUtils.getFaceCentre(pos, side).func_178787_e(new Vec3d(side.func_176730_m()).func_186678_a(0.005))).face(side).clr(0.9f, 0.5f, 0.8f).fade(0.7f, 0.0f, 1.0f).spawn((World)this.field_146297_k.field_71441_e);
                    }
                    this.field_146297_k.field_71441_e.func_184156_a(pos, WizardrySounds.BLOCK_LECTERN_LOCATE_SPELL, SoundCategory.BLOCKS, 1.0f, 0.7f, false);
                    continue block0;
                }
            }
        } else if (button == this.nextPageButton) {
            if (this.currentPage < lastPage) {
                ++this.currentPage;
            }
        } else if (button == this.prevPageButton) {
            if (this.currentPage > 0) {
                --this.currentPage;
            }
        } else if (button == this.lastPageButton) {
            this.currentPage = lastPage;
        } else if (button == this.firstPageButton) {
            this.currentPage = 0;
        } else if (button instanceof GuiButtonSpell) {
            this.currentSpell = this.getSpellForButton((GuiButtonSpell)button);
        } else if (button instanceof GuiButtonSpellSort) {
            ISpellSortable.SortType sortType = ((GuiButtonSpellSort)button).sortType;
            if (this.sortType == sortType) {
                this.sortDescending = !this.sortDescending;
            } else {
                this.sortType = sortType;
                this.sortDescending = false;
            }
            this.updateMatchingSpells();
        }
        this.updateButtonVisiblity();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.searchNeedsClearing) {
            this.searchNeedsClearing = false;
            this.searchField.func_146180_a("");
            this.currentPage = 0;
        }
        if (this.searchField.func_146201_a(typedChar, keyCode)) {
            this.currentPage = 0;
            this.updateMatchingSpells();
            this.updateButtonVisiblity();
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    private void updateButtonVisiblity() {
        if (this.currentSpell == Spells.none) {
            this.searchField.func_146189_e(true);
            int lastPage = this.getPageCount() - 1;
            this.prevPageButton.field_146125_m = this.currentPage > 0;
            this.firstPageButton.field_146125_m = this.currentPage > 0;
            this.nextPageButton.field_146125_m = this.currentPage < lastPage;
            this.lastPageButton.field_146125_m = this.currentPage < lastPage;
            this.indexButton.field_146125_m = false;
            this.locateButton.field_146125_m = false;
            for (GuiButton guiButton : this.sortButtons) {
                guiButton.field_146125_m = true;
            }
            for (GuiButton guiButton : this.spellButtons) {
                guiButton.field_146125_m = this.currentPage * 18 + ((GuiButtonSpell)guiButton).index < this.matchingSpells.size();
            }
        } else {
            this.searchField.func_146189_e(false);
            this.field_146292_n.forEach(b -> {
                b.field_146125_m = false;
            });
            this.indexButton.field_146125_m = true;
            this.locateButton.field_146125_m = true;
        }
    }

    private void updateMatchingSpells() {
        this.matchingSpells = this.availableSpells.stream().filter(s -> s.matches(this.searchField.func_146179_b().toLowerCase(Locale.ROOT))).sorted(this.sortDescending ? this.sortType.comparator.reversed() : this.sortType.comparator).collect(Collectors.toList());
    }

    public void refreshAvailableSpells() {
        this.availableSpells.clear();
        for (IInventory bookshelf : BlockBookshelf.findNearbyBookshelves(this.lectern.func_145831_w(), this.lectern.func_174877_v(), new TileEntity[0])) {
            for (int i = 0; i < bookshelf.func_70302_i_(); ++i) {
                Spell spell;
                ItemStack stack = bookshelf.func_70301_a(i);
                if (!(stack.func_77973_b() instanceof ItemSpellBook) || (spell = Spell.byMetadata(stack.func_77960_j())) == Spells.none || this.availableSpells.contains(spell)) continue;
                this.availableSpells.add(spell);
            }
        }
        if (!this.availableSpells.contains(this.currentSpell)) {
            this.currentSpell = Spells.none;
        }
        this.updateMatchingSpells();
        this.updateButtonVisiblity();
    }

    private class GuiButtonSpell
    extends GuiButtonInvisible {
        private static final int WIDTH = 34;
        private static final int HEIGHT = 34;
        private final int index;

        public GuiButtonSpell(int id, int x, int y, int index) {
            super(id, x, y, 34, 34);
            this.index = index;
        }

        public void func_146113_a(SoundHandler soundHandler) {
            soundHandler.func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)WizardrySounds.MISC_PAGE_TURN, (float)1.0f));
        }

        @Override
        public void func_191745_a(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                super.func_191745_a(minecraft, mouseX, mouseY, partialTicks);
                if (this.field_146123_n) {
                    GuiLectern.this.field_146297_k.field_71446_o.func_110577_a(GuiLectern.this.getTexture());
                    DrawingUtils.drawTexturedRect(this.field_146128_h, this.field_146129_i, 40, 180, this.field_146120_f, this.field_146121_g, GuiLectern.this.textureWidth, GuiLectern.this.textureHeight);
                }
            }
        }

        public void func_146111_b(int mouseX, int mouseY) {
            if (this.field_146125_m && this.field_146123_n) {
                Spell spell = GuiLectern.this.getSpellForButton(this);
                if (Wizardry.proxy.shouldDisplayDiscovered(spell, null)) {
                    GuiLectern.this.drawHoveringText(Collections.singletonList(spell.getDisplayName()), mouseX, mouseY, GuiLectern.this.field_146289_q);
                } else {
                    GuiLectern.this.drawHoveringText(Collections.singletonList(SpellGlyphData.getGlyphName(spell, (World)GuiLectern.this.field_146297_k.field_71441_e)), mouseX, mouseY, GuiLectern.this.field_146297_k.field_71464_q);
                }
            }
        }
    }

    private class GuiButtonLocateBook
    extends GuiButton {
        public GuiButtonLocateBook(int id, int x, int y) {
            super(id, x, y, 12, 12, "");
        }

        public void func_191745_a(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                boolean flag = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                minecraft.func_110434_K().func_110577_a(TEXTURE);
                DrawingUtils.drawTexturedRect(this.field_146128_h, this.field_146129_i, flag ? this.field_146120_f : 0, 184, this.field_146120_f, this.field_146121_g, GuiLectern.this.textureWidth, GuiLectern.this.textureHeight);
            }
        }
    }
}

