/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.constants;

import electroblob.wizardry.Wizardry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum SpellType {
    ATTACK("attack"),
    DEFENCE("defence"),
    UTILITY("utility"),
    MINION("minion"),
    BUFF("buff"),
    CONSTRUCT("construct"),
    PROJECTILE("projectile"),
    ALTERATION("alteration");

    private final String unlocalisedName;

    private SpellType(String name) {
        this.unlocalisedName = name;
    }

    public static SpellType fromName(String name) {
        for (SpellType type : SpellType.values()) {
            if (!type.unlocalisedName.equals(name)) continue;
            return type;
        }
        throw new IllegalArgumentException("No such spell type with unlocalised name: " + name);
    }

    public String getUnlocalisedName() {
        return this.unlocalisedName;
    }

    @SideOnly(value=Side.CLIENT)
    public String getDisplayName() {
        return Wizardry.proxy.translate("spelltype." + this.unlocalisedName, new Object[0]);
    }
}

