/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity.construct;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.entity.ICustomHitbox;
import electroblob.wizardry.entity.construct.EntityMagicConstruct;
import electroblob.wizardry.entity.projectile.EntityMagicArrow;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.GeometryUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class EntityForcefield
extends EntityMagicConstruct
implements ICustomHitbox {
    private static final double SEARCH_BORDER_SIZE = 4.0;
    private static final float BOUNCINESS = 0.2f;
    private float radius;

    public EntityForcefield(World world) {
        super(world);
        this.setRadius(3.0f);
        this.field_70158_ak = true;
        this.field_70145_X = true;
    }

    public void setRadius(float radius) {
        this.radius = radius;
        this.field_70131_O = 2.0f * radius;
        this.field_70130_N = 2.0f * radius;
        this.func_174826_a(new AxisAlignedBB(this.field_70165_t - (double)radius, this.field_70163_u - (double)radius, this.field_70161_v - (double)radius, this.field_70165_t + (double)radius, this.field_70163_u + (double)radius, this.field_70161_v + (double)radius));
    }

    public float getRadius() {
        return this.radius;
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return super.func_70046_E();
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa == 1 && this.field_70170_p.field_72995_K) {
            Wizardry.proxy.playMovingSound(this, WizardrySounds.ENTITY_FORCEFIELD_AMBIENT, WizardrySounds.SPELLS, 0.5f, 1.0f, true);
        }
        List<Entity> targets = EntityUtils.getEntitiesWithinRadius((double)this.radius + 4.0, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70170_p, Entity.class);
        targets.remove(this);
        targets.removeIf(t -> t instanceof EntityXPOrb);
        if (this.getCaster() instanceof EntityPlayer && ItemArtefact.isArtefactActive((EntityPlayer)this.getCaster(), WizardryItems.ring_defender)) {
            targets.removeIf(t -> t instanceof EntityMagicArrow && !this.isValidTarget((Entity)((EntityMagicArrow)((Object)t)).getCaster()) || t instanceof EntityThrowable && !this.isValidTarget((Entity)((EntityThrowable)t).func_85052_h()) || t instanceof EntityArrow && !this.isValidTarget(((EntityArrow)t).field_70250_c));
        }
        for (Entity target : targets) {
            double nudgeVelocity;
            boolean flag;
            if (!this.isValidTarget(target)) continue;
            Vec3d currentPos = Arrays.stream(GeometryUtils.getVertices(target.func_174813_aQ())).min(Comparator.comparingDouble(v -> v.func_72438_d(this.func_174791_d()))).orElse(target.func_174791_d());
            double currentDistance = target.func_70032_d((Entity)this);
            Vec3d nextTickPos = currentPos.func_72441_c(target.field_70159_w, target.field_70181_x, target.field_70179_y);
            double nextTickDistance = nextTickPos.func_72438_d(this.func_174791_d());
            if (EntityUtils.isLiving(target)) {
                flag = nextTickDistance <= (double)this.radius;
            } else {
                boolean bl = flag = currentDistance > (double)this.radius && nextTickDistance <= (double)this.radius || currentDistance < (double)this.radius && nextTickDistance >= (double)this.radius;
            }
            if (!flag) continue;
            if (this.getCaster() instanceof EntityPlayer && ItemArtefact.isArtefactActive((EntityPlayer)this.getCaster(), WizardryItems.ring_interdiction) && EntityUtils.isLiving(target)) {
                target.func_70097_a(MagicDamage.causeIndirectMagicDamage(this, (Entity)this.getCaster(), MagicDamage.DamageType.MAGIC), 1.0f);
            }
            Vec3d targetRelativePos = currentPos.func_178788_d(this.func_174791_d());
            double d = nudgeVelocity = this.contains(target) ? -0.1 : 0.1;
            if (EntityUtils.isLiving(target)) {
                nudgeVelocity = 0.25;
            }
            Vec3d extraVelocity = targetRelativePos.func_72432_b().func_186678_a(nudgeVelocity);
            target.field_70159_w = target.field_70159_w * (double)-0.2f + extraVelocity.field_72450_a;
            target.field_70181_x = target.field_70181_x * (double)-0.2f + extraVelocity.field_72448_b;
            target.field_70179_y = target.field_70179_y * (double)-0.2f + extraVelocity.field_72449_c;
            if (target.field_70122_E && target.field_70181_x < 0.0) {
                target.field_70181_x = 0.1;
            }
            double distanceTowardsCentre = -(targetRelativePos.func_72433_c() - (double)this.radius) - ((double)this.radius - nextTickDistance);
            Vec3d targetNewPos = target.func_174791_d().func_178787_e(targetRelativePos.func_72432_b().func_186678_a(distanceTowardsCentre));
            target.func_70107_b(targetNewPos.field_72450_a, targetNewPos.field_72448_b, targetNewPos.field_72449_c);
            this.field_70170_p.func_184134_a(target.field_70165_t, target.field_70163_u, target.field_70161_v, WizardrySounds.ENTITY_FORCEFIELD_DEFLECT, WizardrySounds.SPELLS, 0.3f, 1.3f, false);
            if (!this.field_70170_p.field_72995_K) {
                if (!(target instanceof EntityPlayerMP)) continue;
                ((EntityPlayerMP)target).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(target));
                continue;
            }
            Vec3d relativeImpactPos = targetRelativePos.func_72432_b().func_186678_a((double)this.radius);
            float yaw = (float)Math.atan2(relativeImpactPos.field_72450_a, -relativeImpactPos.field_72449_c);
            float pitch = (float)Math.asin(relativeImpactPos.field_72448_b / (double)this.radius);
            ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(this.func_174791_d().func_178787_e(relativeImpactPos)).time(6).face((float)((double)(yaw * 180.0f) / Math.PI), (float)((double)(pitch * 180.0f) / Math.PI)).clr(0.9f, 0.95f, 1.0f).spawn(this.field_70170_p);
            for (int i = 0; i < 12; ++i) {
                float yaw1 = yaw + 0.3f * (this.field_70146_Z.nextFloat() - 0.5f) - 1.5707964f;
                float pitch1 = pitch + 0.3f * (this.field_70146_Z.nextFloat() - 0.5f);
                float brightness = this.field_70146_Z.nextFloat();
                double r = (double)this.radius + 0.05;
                double x = this.field_70165_t + r * (double)MathHelper.func_76134_b((float)yaw1) * (double)MathHelper.func_76134_b((float)pitch1);
                double y = this.field_70163_u + r * (double)MathHelper.func_76126_a((float)pitch1);
                double z = this.field_70161_v + r * (double)MathHelper.func_76126_a((float)yaw1) * (double)MathHelper.func_76134_b((float)pitch1);
                ParticleBuilder.create(ParticleBuilder.Type.DUST).pos(x, y, z).time(6 + this.field_70146_Z.nextInt(6)).face((float)((double)(yaw1 * 180.0f) / Math.PI) + 90.0f, (float)((double)(pitch1 * 180.0f) / Math.PI)).scale(1.5f).clr(0.7f + 0.3f * brightness, 0.85f + 0.15f * brightness, 1.0f).spawn(this.field_70170_p);
            }
        }
    }

    @Override
    public boolean contains(Vec3d vec) {
        return vec.func_72438_d(this.func_174791_d()) < (double)this.radius;
    }

    public boolean contains(AxisAlignedBB box) {
        return Arrays.stream(GeometryUtils.getVertices(box)).allMatch(this::contains);
    }

    public boolean contains(Entity entity) {
        return this.contains(entity.func_174813_aQ());
    }

    @Override
    public Vec3d calculateIntercept(Vec3d origin, Vec3d endpoint, float fuzziness) {
        double rsquared;
        double t;
        Vec3d line = endpoint.func_178788_d(origin);
        Vec3d closestPoint = origin.func_178787_e(line.func_186678_a(t = -origin.func_178788_d(this.func_174791_d()).func_72430_b(line) / line.func_189985_c()));
        double dsquared = closestPoint.func_72436_e(this.func_174791_d());
        if (dsquared > (rsquared = Math.pow(this.radius + fuzziness, 2.0))) {
            return null;
        }
        return closestPoint.func_178788_d(line.func_72432_b().func_186678_a((double)MathHelper.func_76133_a((double)(rsquared - dsquared))));
    }

    @Override
    public void writeSpawnData(ByteBuf data) {
        super.writeSpawnData(data);
        data.writeFloat(this.getRadius());
    }

    @Override
    public void readSpawnData(ByteBuf data) {
        super.readSpawnData(data);
        this.setRadius(data.readFloat());
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74776_a("radius", this.radius);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.radius = nbt.func_74760_g("radius");
    }

    @Override
    public boolean func_90999_ad() {
        return false;
    }

    @SubscribeEvent
    public static void onLivingAttackEvent(LivingAttackEvent event) {
        if (event.getSource().func_76346_g() instanceof EntityPlayer && event.getSource().func_76352_a() && ItemArtefact.isArtefactActive((EntityPlayer)event.getSource().func_76346_g(), WizardryItems.ring_defender)) {
            return;
        }
        if (!event.getSource().func_76363_c() && event.getSource().func_76346_g() != null && event.getEntityLiving() != null && !(event.getSource().func_76364_f() instanceof EntityForcefield) && EntityForcefield.getSurroundingForcefield((Entity)event.getEntityLiving()) != EntityForcefield.getSurroundingForcefield(event.getSource().func_76346_g())) {
            event.setCanceled(true);
        }
    }

    @Nullable
    private static EntityForcefield getSurroundingForcefield(World world, Vec3d vec) {
        double searchRadius = 20.0;
        List<EntityForcefield> forcefields = EntityUtils.getEntitiesWithinRadius(searchRadius, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, world, EntityForcefield.class);
        forcefields.removeIf(f -> !f.contains(vec));
        return forcefields.stream().min(Comparator.comparingDouble(f -> vec.func_72436_e(f.func_174791_d()))).orElse(null);
    }

    @Nullable
    private static EntityForcefield getSurroundingForcefield(World world, AxisAlignedBB box, Vec3d vec) {
        double searchRadius = 20.0;
        List<EntityForcefield> forcefields = EntityUtils.getEntitiesWithinRadius(searchRadius, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, world, EntityForcefield.class);
        forcefields.removeIf(f -> !f.contains(box));
        return forcefields.stream().min(Comparator.comparingDouble(f -> vec.func_72436_e(f.func_174791_d()))).orElse(null);
    }

    @Nullable
    private static EntityForcefield getSurroundingForcefield(Entity entity) {
        return EntityForcefield.getSurroundingForcefield(entity.field_70170_p, entity.func_174813_aQ(), entity.func_174791_d());
    }

    @SubscribeEvent
    public static void onPlayerInteractEvent(PlayerInteractEvent event) {
        if (!event.isCancelable()) {
            return;
        }
        AxisAlignedBB box = event.getWorld().func_180495_p(event.getPos()).func_185900_c((IBlockAccess)event.getWorld(), event.getPos()).func_72317_d((double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p());
        if (event instanceof PlayerInteractEvent.EntityInteract) {
            box = ((PlayerInteractEvent.EntityInteract)event).getTarget().func_174813_aQ();
        } else if (event instanceof PlayerInteractEvent.EntityInteractSpecific) {
            box = ((PlayerInteractEvent.EntityInteractSpecific)event).getTarget().func_174813_aQ();
        }
        if (EntityForcefield.getSurroundingForcefield(event.getWorld(), GeometryUtils.getCentre(box)) != EntityForcefield.getSurroundingForcefield(event.getWorld(), event.getEntityPlayer().func_174791_d())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onExplosionEvent(ExplosionEvent event) {
        EntityForcefield forcefield = EntityForcefield.getSurroundingForcefield(event.getWorld(), event.getExplosion().getPosition());
        event.getExplosion().func_180343_e().removeIf(p -> EntityForcefield.getSurroundingForcefield(event.getWorld(), new Vec3d((Vec3i)p).func_72441_c(0.5, 0.5, 0.5)) != forcefield);
        event.getExplosion().func_77277_b().keySet().removeIf(p -> EntityForcefield.getSurroundingForcefield((Entity)p) != forcefield);
    }
}

