/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.data.IVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class Charge
extends Spell {
    public static final IVariable<Integer> CHARGE_TIME = new IVariable.Variable<Integer>(Persistence.NEVER).withTicker(Charge::update);
    public static final IVariable<SpellModifiers> CHARGE_MODIFIERS = new IVariable.Variable<SpellModifiers>(Persistence.NEVER);
    public static final String CHARGE_SPEED = "charge_speed";
    public static final String KNOCKBACK_STRENGTH = "knockback_strength";
    private static final double EXTRA_HIT_MARGIN = 1.0;

    public Charge() {
        super("charge", SpellActions.POINT, false);
        this.addProperties(CHARGE_SPEED, "duration", "damage", KNOCKBACK_STRENGTH);
        this.soundValues(0.6f, 1.0f, 0.0f);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        WizardData.get(caster).setVariable(CHARGE_TIME, (int)(this.getProperty("duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade)));
        WizardData.get(caster).setVariable(CHARGE_MODIFIERS, modifiers);
        if (world.field_72995_K) {
            world.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, caster.field_70165_t, caster.field_70163_u + (double)(caster.field_70131_O / 2.0f), caster.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    private static int update(EntityPlayer player, Integer chargeTime) {
        if (chargeTime == null) {
            chargeTime = 0;
        }
        if (chargeTime > 0) {
            SpellModifiers modifiers = WizardData.get(player).getVariable(CHARGE_MODIFIERS);
            if (modifiers == null) {
                modifiers = new SpellModifiers();
            }
            Vec3d look = player.func_70040_Z();
            float speed = Spells.charge.getProperty(CHARGE_SPEED).floatValue() * modifiers.get(WizardryItems.range_upgrade);
            player.field_70159_w = look.field_72450_a * (double)speed;
            player.field_70179_y = look.field_72449_c * (double)speed;
            if (player.field_70170_p.field_72995_K) {
                for (int i = 0; i < 5; ++i) {
                    ParticleBuilder.create(ParticleBuilder.Type.SPARK, (Entity)player).spawn(player.field_70170_p);
                }
            }
            List collided = player.field_70170_p.func_72872_a(EntityLivingBase.class, player.func_174813_aQ().func_186662_g(1.0));
            collided.remove(player);
            float damage = Spells.charge.getProperty("damage").floatValue() * modifiers.get("potency");
            float knockback = Spells.charge.getProperty(KNOCKBACK_STRENGTH).floatValue();
            collided.forEach(e -> e.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)player, MagicDamage.DamageType.SHOCK), damage));
            collided.forEach(e -> e.func_70024_g(player.field_70159_w * (double)knockback, player.field_70181_x * (double)knockback + (double)0.3f, player.field_70179_y * (double)knockback));
            if (player.field_70170_p.field_72995_K) {
                player.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, player.field_70165_t + player.field_70159_w, player.field_70163_u + (double)(player.field_70131_O / 2.0f), player.field_70161_v + player.field_70179_y, 0.0, 0.0, 0.0, new int[0]);
            }
            if (collided.isEmpty()) {
                Integer n = chargeTime;
                Integer n2 = chargeTime = Integer.valueOf(chargeTime - 1);
            } else {
                EntityUtils.playSoundAtPlayer(player, SoundEvents.field_187543_bD, 1.0f, 1.0f);
                chargeTime = 0;
            }
        }
        return chargeTime;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLivingAttackEvent(LivingAttackEvent event) {
        if (event.getEntity() instanceof EntityPlayer && event.getSource().func_76346_g() instanceof EntityLivingBase) {
            Integer chargeTime;
            EntityPlayer player = (EntityPlayer)event.getEntity();
            EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76346_g();
            if (WizardData.get(player) != null && (chargeTime = WizardData.get(player).getVariable(CHARGE_TIME)) != null && chargeTime > 0 && player.func_174813_aQ().func_186662_g(1.0).func_72326_a(attacker.func_174813_aQ())) {
                event.setCanceled(true);
            }
        }
    }
}

