/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class LightningBolt
extends SpellRay {
    public static final String SUMMONER_NBT_KEY = "summoner";
    public static final String DAMAGE_MODIFIER_NBT_KEY = "damageModifier";
    public static final String IMMUNE_TO_LIGHTNING_NBT_KEY = "immuneToLightning";

    public LightningBolt() {
        super("lightning_bolt", SpellActions.POINT, false);
        this.ignoreLivingEntities(true);
        this.addProperties("damage");
    }

    @Override
    public boolean requiresPacket() {
        return false;
    }

    @Override
    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    @Override
    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (world.func_175710_j(pos.func_177984_a())) {
            if (!world.field_72995_K) {
                boolean doFireTick = world.func_82736_K().func_82766_b("doFireTick");
                if (doFireTick && !Wizardry.settings.playerBlockDamage) {
                    world.func_82736_K().func_82764_b("doFireTick", "false");
                }
                EntityLightningBolt lightning = new EntityLightningBolt(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), false);
                if (caster != null) {
                    lightning.getEntityData().func_186854_a(SUMMONER_NBT_KEY, caster.func_110124_au());
                }
                lightning.getEntityData().func_74776_a(DAMAGE_MODIFIER_NBT_KEY, modifiers.get("potency"));
                world.func_72942_c((Entity)lightning);
                if (doFireTick && !Wizardry.settings.playerBlockDamage) {
                    world.func_82736_K().func_82764_b("doFireTick", "true");
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onEntityStruckByLightningEvent(EntityStruckByLightningEvent event) {
        float damageModifier = event.getLightning().getEntityData().func_74760_g(DAMAGE_MODIFIER_NBT_KEY);
        Entity summoner = null;
        if (event.getLightning().getEntityData().func_186855_b(SUMMONER_NBT_KEY) && !((summoner = EntityUtils.getEntityByUUID(event.getLightning().field_70170_p, event.getLightning().getEntityData().func_186857_a(SUMMONER_NBT_KEY))) instanceof EntityLivingBase)) {
            summoner = null;
        }
        if (damageModifier > 0.0f || summoner != null) {
            DamageSource source = summoner == null ? DamageSource.field_180137_b : MagicDamage.causeIndirectMagicDamage((Entity)event.getLightning(), summoner, MagicDamage.DamageType.SHOCK);
            float damage = Spells.lightning_bolt.getProperty("damage").floatValue() * damageModifier;
            EntityUtils.attackEntityWithoutKnockback(event.getEntity(), source, damage);
            event.getEntity().getEntityData().func_74757_a(IMMUNE_TO_LIGHTNING_NBT_KEY, true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingAttackEvent(LivingAttackEvent event) {
        if (event.getEntity().getEntityData().func_74764_b(IMMUNE_TO_LIGHTNING_NBT_KEY) && event.getSource() == DamageSource.field_180137_b) {
            event.setCanceled(true);
            event.getEntity().getEntityData().func_82580_o(IMMUNE_TO_LIGHTNING_NBT_KEY);
        }
    }
}

