/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellAreaEffect;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class Shockwave
extends SpellAreaEffect {
    public static final String MAX_REPULSION_VELOCITY = "max_repulsion_velocity";
    private static final double EPICENTRE_RADIUS = 1.0;

    public Shockwave() {
        super("shockwave", SpellActions.POINT_DOWN, false);
        this.soundValues(2.0f, 0.5f, 0.0f);
        this.alwaysSucceed(true);
        this.addProperties("damage", MAX_REPULSION_VELOCITY);
    }

    @Override
    protected boolean affectEntity(World world, Vec3d origin, @Nullable EntityLivingBase caster, EntityLivingBase target, int targetCount, int ticksInUse, SpellModifiers modifiers) {
        float radius = this.getProperty("effect_radius").floatValue() * modifiers.get(WizardryItems.blast_upgrade);
        if (target instanceof EntityPlayer) {
            if (!Wizardry.settings.playersMoveEachOther) {
                return false;
            }
            if (ItemArtefact.isArtefactActive((EntityPlayer)target, WizardryItems.amulet_anchoring)) {
                if (!world.field_72995_K && caster instanceof EntityPlayer) {
                    ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getNameForTranslationFormatted()}), true);
                }
                return false;
            }
        }
        float proximity = (float)(1.0 - Math.max(origin.func_72438_d(target.func_174791_d()) - 1.0, 0.0) / ((double)radius - 1.0));
        target.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.BLAST), this.getProperty("damage").floatValue() * proximity * modifiers.get("potency"));
        if (!world.field_72995_K) {
            double velocityFactor = proximity * this.getProperty(MAX_REPULSION_VELOCITY).floatValue();
            double dx = target.field_70165_t - origin.field_72450_a;
            double dy = target.field_70163_u + 1.0 - origin.field_72448_b;
            double dz = target.field_70161_v - origin.field_72449_c;
            target.field_70159_w = velocityFactor * dx;
            target.field_70181_x = velocityFactor * dy;
            target.field_70179_y = velocityFactor * dz;
            if (target instanceof EntityPlayerMP) {
                ((EntityPlayerMP)target).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)target));
            }
        }
        return true;
    }

    @Override
    protected void spawnParticleEffect(World world, Vec3d origin, double radius, @Nullable EntityLivingBase caster, SpellModifiers modifiers) {
        EntityUtils.getEntitiesWithinRadius(radius, origin.field_72450_a, origin.field_72448_b, origin.field_72449_c, world, EntityPlayer.class).forEach(p -> Wizardry.proxy.shakeScreen((EntityPlayer)p, 10.0f));
        for (int i = 0; i < 40; ++i) {
            double particleX = origin.field_72450_a - 1.0 + 2.0 * world.field_73012_v.nextDouble();
            double particleZ = origin.field_72449_c - 1.0 + 2.0 * world.field_73012_v.nextDouble();
            IBlockState block = world.func_180495_p(new BlockPos(origin.field_72450_a, origin.field_72448_b - 0.5, origin.field_72449_c));
            if (block == null) continue;
            world.func_175688_a(EnumParticleTypes.BLOCK_DUST, particleX, origin.field_72448_b, particleZ, particleX - origin.field_72450_a, 0.0, particleZ - origin.field_72449_c, new int[]{Block.func_176210_f((IBlockState)block)});
        }
        ParticleBuilder.create(ParticleBuilder.Type.SPHERE).pos(origin.func_72441_c(0.0, 0.1, 0.0)).scale((float)radius * 0.8f).clr(0.8f, 0.9f, 1.0f).spawn(world);
        world.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, origin.field_72450_a, origin.field_72448_b + 0.1, origin.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
    }
}

