/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.elenaidodge.network.message;

import com.elenai.elenaidodge.ElenaiDodge;
import com.elenai.elenaidodge.particle.ParticleGenerator;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class CParticleMessage
implements IMessage {
    private int level;
    private double x;
    private double y;
    private double z;
    private boolean messageValid;

    public CParticleMessage() {
        this.messageValid = false;
    }

    public CParticleMessage(int level, double x, double y, double z) {
        this.level = level;
        this.x = x;
        this.y = y;
        this.z = z;
        this.messageValid = true;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.level = buf.readInt();
            this.x = buf.readDouble();
            this.y = buf.readDouble();
            this.z = buf.readDouble();
        }
        catch (IndexOutOfBoundsException ioe) {
            ElenaiDodge.LOG.error("Error occured whilst networking!", (Throwable)ioe);
            return;
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeInt(this.level);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
    }

    public static class Handler
    implements IMessageHandler<CParticleMessage, IMessage> {
        public IMessage onMessage(CParticleMessage message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.CLIENT) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.processMessage(message, ctx));
            return null;
        }

        void processMessage(CParticleMessage message, MessageContext ctx) {
            EnumParticleTypes particleType = null;
            switch (message.level) {
                case 0: {
                    particleType = EnumParticleTypes.CLOUD;
                    break;
                }
                case 1: {
                    particleType = EnumParticleTypes.HEART;
                    break;
                }
                case 2: {
                    particleType = EnumParticleTypes.FLAME;
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    particleType = EnumParticleTypes.END_ROD;
                    break;
                }
            }
            if (particleType != null && message.level > 0) {
                for (int i = 0; i < 8; ++i) {
                    double d0 = Minecraft.func_71410_x().field_71439_g.field_70170_p.field_73012_v.nextGaussian() * 0.02;
                    double d1 = Minecraft.func_71410_x().field_71439_g.field_70170_p.field_73012_v.nextGaussian() * 0.02;
                    double d2 = Minecraft.func_71410_x().field_71439_g.field_70170_p.field_73012_v.nextGaussian() * 0.02;
                    Minecraft.func_71410_x().field_71439_g.field_70170_p.func_175688_a(particleType, message.x + (double)(Minecraft.func_71410_x().field_71439_g.field_70170_p.field_73012_v.nextFloat() * 0.6f * 2.0f) - (double)0.6f - d0 * 10.0, message.y + 0.1, message.z + (double)(Minecraft.func_71410_x().field_71439_g.field_70170_p.field_73012_v.nextFloat() * 0.6f * 2.0f) - (double)0.6f - d2 * 10.0, d0, d1, d2, new int[0]);
                }
            } else if (particleType != null) {
                for (int i = 0; i < 8; ++i) {
                    double d0 = Minecraft.func_71410_x().field_71439_g.field_70170_p.field_73012_v.nextGaussian() * 0.02;
                    double d1 = Minecraft.func_71410_x().field_71439_g.field_70170_p.field_73012_v.nextGaussian() * 0.02;
                    double d2 = Minecraft.func_71410_x().field_71439_g.field_70170_p.field_73012_v.nextGaussian() * 0.02;
                    Minecraft.func_71410_x().field_71439_g.field_70170_p.func_175688_a(particleType, message.x + (double)(Minecraft.func_71410_x().field_71439_g.field_70170_p.field_73012_v.nextFloat() * 0.6f * 2.0f) - (double)0.6f - d0 * 10.0, message.y + (double)(Minecraft.func_71410_x().field_71439_g.field_70170_p.field_73012_v.nextFloat() * 1.8f) - d1 * 10.0, message.z + (double)(Minecraft.func_71410_x().field_71439_g.field_70170_p.field_73012_v.nextFloat() * 0.6f * 2.0f) - (double)0.6f - d2 * 10.0, d0, d1, d2, new int[0]);
                }
            } else {
                ParticleGenerator.generate(message.level, message.x, message.y, message.z);
            }
        }
    }
}

