/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.elenaidodge.util;

import codersafterdark.reskillable.api.ReskillableRegistries;
import codersafterdark.reskillable.api.data.PlayerDataHandler;
import codersafterdark.reskillable.api.skill.Skill;
import codersafterdark.reskillable.api.unlockable.Unlockable;
import com.elenai.elenaidodge.ElenaiDodge;
import com.elenai.elenaidodge.ModConfig;
import com.elenai.elenaidodge.api.DodgeEvent;
import com.elenai.elenaidodge.api.LedgeGrabEvent;
import com.elenai.elenaidodge.api.WallJumpEvent;
import com.elenai.elenaidodge.capability.weight.IWeight;
import com.elenai.elenaidodge.capability.weight.WeightProvider;
import com.elenai.elenaidodge.effects.ServerDodgeEffects;
import com.elenai.elenaidodge.effects.ServerLedgeGrabEffects;
import com.elenai.elenaidodge.effects.ServerWallJumpEffects;
import com.elenai.elenaidodge.network.PacketHandler;
import com.elenai.elenaidodge.network.message.CDodgeEffectsMessage;
import com.elenai.elenaidodge.network.message.CInitPlayerMessage;
import com.elenai.elenaidodge.network.message.CUpdateConfigMessage;
import com.elenai.elenaidodge.network.message.CVelocityMessage;
import com.elenai.elenaidodge.util.WeightTier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class Utils {
    public static void setPlayerVelocity(double x, double y, double z, EntityPlayer player) {
        PacketHandler.instance.sendTo((IMessage)new CVelocityMessage(x, y, z), (EntityPlayerMP)player);
    }

    public static void handleDodge(DodgeEvent.Direction direction, DodgeEvent.ServerDodgeEvent event, EntityPlayerMP player) {
        double motionZ;
        double motionX;
        double f = event.getForce();
        switch (direction) {
            case LEFT: {
                motionX = (double)(MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)0.017453294f)) * f;
                motionZ = -((double)(-MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)0.017453294f)) * f);
                break;
            }
            case RIGHT: {
                motionX = -((double)(MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)0.017453294f)) * f);
                motionZ = (double)(-MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)0.017453294f)) * f;
                break;
            }
            case FORWARD: {
                motionX = (double)(-MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)0.017453294f)) * f;
                motionZ = (double)(MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)0.017453294f)) * f;
                break;
            }
            case BACK: {
                motionX = -((double)(-MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)0.017453294f)) * f);
                motionZ = -((double)(MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)0.017453294f)) * f);
                break;
            }
            default: {
                motionX = 0.0;
                motionZ = 0.0;
                ElenaiDodge.LOG.error("DodgeEvent Posted and Received but no direction given!");
            }
        }
        Utils.setPlayerVelocity(motionX, ModConfig.common.balance.verticality, motionZ, (EntityPlayer)player);
        ServerDodgeEffects.run(player);
        PacketHandler.instance.sendTo((IMessage)new CDodgeEffectsMessage(), player);
    }

    public static double calculateForce(EntityPlayer player) {
        return ModConfig.common.balance.force;
    }

    public static void initPlayer(EntityPlayer player) {
        PacketHandler.instance.sendTo((IMessage)new CInitPlayerMessage(), (EntityPlayerMP)player);
    }

    public static void updateClientConfig(EntityPlayerMP player) {
        PacketHandler.instance.sendTo((IMessage)new CUpdateConfigMessage(ModConfig.common.weights.enable ? Utils.getWeightTier((EntityPlayer)player).getCooldown() : ModConfig.common.balance.regenSpeed, Utils.arrayToString(ModConfig.common.weights.weights), ModConfig.common.weights.enable), player);
    }

    public static void updateClientConfig() {
        PacketHandler.instance.sendToAll((IMessage)new CUpdateConfigMessage(ModConfig.common.balance.regenSpeed, Utils.arrayToString(ModConfig.common.weights.weights), ModConfig.common.weights.enable));
    }

    public static int getTotalEnchantmentLevel(Enchantment enchantment, EntityLivingBase entity) {
        List iterable = enchantment.func_185260_a(entity);
        if (iterable == null) {
            return 0;
        }
        int i = 0;
        for (ItemStack itemstack : iterable) {
            int j = EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)itemstack);
            i += j;
        }
        return i;
    }

    public static String arrayToString(String[] string) {
        if (string.length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String n : string) {
                stringBuilder.append("").append(n.replace("'", "\\'")).append(",");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            return stringBuilder.toString();
        }
        return "";
    }

    public static boolean dodgeTraitUnlocked(EntityPlayer player) {
        if (Loader.isModLoaded((String)"reskillable")) {
            return PlayerDataHandler.get((EntityPlayer)player).getSkillInfo((Skill)ReskillableRegistries.SKILLS.getValue(new ResourceLocation("reskillable", "agility"))).isUnlocked((Unlockable)ReskillableRegistries.UNLOCKABLES.getValue(new ResourceLocation("elenaidodge", "dodge")));
        }
        return true;
    }

    public static boolean wallJumpTraitUnlocked(EntityPlayer player) {
        if (Loader.isModLoaded((String)"reskillable")) {
            return PlayerDataHandler.get((EntityPlayer)player).getSkillInfo((Skill)ReskillableRegistries.SKILLS.getValue(new ResourceLocation("reskillable", "agility"))).isUnlocked((Unlockable)ReskillableRegistries.UNLOCKABLES.getValue(new ResourceLocation("elenaidodge", "walljump")));
        }
        return true;
    }

    public static boolean ledgeGrabTraitUnlocked(EntityPlayer player) {
        if (Loader.isModLoaded((String)"reskillable")) {
            return PlayerDataHandler.get((EntityPlayer)player).getSkillInfo((Skill)ReskillableRegistries.SKILLS.getValue(new ResourceLocation("reskillable", "agility"))).isUnlocked((Unlockable)ReskillableRegistries.UNLOCKABLES.getValue(new ResourceLocation("elenaidodge", "ledgegrab")));
        }
        return true;
    }

    public static WeightTier getWeightTier(EntityPlayer player) {
        ArrayList tiers = new ArrayList();
        Collections.addAll(tiers, ModConfig.common.weights.tiers);
        Collections.reverse(tiers);
        for (String tier : tiers) {
            String[] tierValue = tier.split("[:\\|]");
            IWeight w = (IWeight)player.getCapability(WeightProvider.WEIGHT_CAP, null);
            if (!(w.getWeight() >= Double.valueOf(tierValue[0]))) continue;
            return new WeightTier(Double.valueOf(tierValue[0]), Integer.valueOf(tierValue[1]), Double.valueOf(tierValue[2]));
        }
        return new WeightTier(0.0, ModConfig.common.balance.regenSpeed, ModConfig.common.balance.force);
    }

    public static boolean hasGamestage(EntityPlayer player) {
        if (!Loader.isModLoaded((String)"gamestages")) {
            return true;
        }
        return GameStageHelper.hasStage((EntityPlayer)player, (String)ModConfig.common.gamestages.name);
    }

    public static boolean hasAirborneGamestage(EntityPlayer player) {
        if (!Loader.isModLoaded((String)"gamestages")) {
            return false;
        }
        return GameStageHelper.hasStage((EntityPlayer)player, (String)ModConfig.common.gamestages.nameAirborne);
    }

    public static void handleWallJump(WallJumpEvent.ServerWallJumpEvent event, EntityPlayerMP player) {
        double f = event.getForce();
        WallJumpEvent.Direction dir = event.getDirection();
        double motionX = (double)(-MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)0.017453294f)) * f;
        double motionZ = (double)(MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)0.017453294f)) * f;
        switch (dir) {
            case NORTH: {
                motionZ -= ModConfig.common.wallJump.outwardsForce;
                break;
            }
            case EAST: {
                motionX += ModConfig.common.wallJump.outwardsForce;
                break;
            }
            case SOUTH: {
                motionZ += ModConfig.common.wallJump.outwardsForce;
                break;
            }
            case WEST: {
                motionX -= ModConfig.common.wallJump.outwardsForce;
                break;
            }
        }
        Utils.setPlayerVelocity(motionX, ModConfig.common.wallJump.verticality, motionZ, (EntityPlayer)player);
        ServerWallJumpEffects.run(player);
    }

    public static void handleLedgeGrab(LedgeGrabEvent.ServerLedgeGrabEvent event, EntityPlayerMP player) {
        double f = event.getForce();
        double motionX = (double)(-MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)0.017453294f)) * f;
        double motionZ = (double)(MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)0.017453294f)) * f;
        Utils.setPlayerVelocity(motionX, ModConfig.common.ledgeGrab.upwardsForce, motionZ, (EntityPlayer)player);
        ServerLedgeGrabEffects.run(player);
    }
}

