/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import teamroots.embers.compat.BaublesIntegration;
import teamroots.embers.compat.MysticalMechanicsIntegration;
import teamroots.embers.item.ItemCinderStaff;
import teamroots.embers.item.ItemIgnitionCannon;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.tileentity.TileEntityCharger;
import teamroots.embers.tileentity.TileEntityCinderPlinth;
import teamroots.embers.tileentity.TileEntityDawnstoneAnvil;
import teamroots.embers.tileentity.TileEntityEmberBore;
import teamroots.embers.tileentity.TileEntityFurnaceBottom;
import teamroots.embers.tileentity.TileEntityInfernoForge;
import teamroots.embers.tileentity.TileEntityStampBase;
import teamroots.embers.tileentity.TileEntityTank;

public class ConfigManager {
    public static Configuration config;
    public static int copperVeinSize;
    public static int copperMinY;
    public static int copperMaxY;
    public static int copperVeinsPerChunk;
    public static int leadVeinSize;
    public static int leadMinY;
    public static int leadMaxY;
    public static int leadVeinsPerChunk;
    public static int silverVeinSize;
    public static int silverMinY;
    public static int silverMaxY;
    public static int silverVeinsPerChunk;
    public static int quartzVeinSize;
    public static int quartzMinY;
    public static int quartzMaxY;
    public static int quartzVeinsPerChunk;
    public static int ancientGolemSpawnWeight;
    public static HashSet<Integer> orespawnGraylist;
    public static boolean orespawnIsWhiteList;
    public static int smallRuinChance;
    public static HashSet<Integer> smallRuinGraylist;
    public static boolean smallRuinIsWhiteList;
    public static HashSet<Integer> emberBoreGraylist;
    public static boolean emberBoreIsWhiteList;
    @Deprecated
    public static List<Integer> orespawnBlacklist;
    @Deprecated
    public static List<Integer> smallRuinBlacklist;
    public static float emberBoreSpeedMod;
    public static int emberBoreMaxYLevel;
    public static boolean enableNickel;
    public static boolean enableTin;
    public static boolean enableAluminum;
    public static boolean enableBronze;
    public static boolean enableElectrum;
    public static int nickelVeinSize;
    public static int nickelMinY;
    public static int nickelMaxY;
    public static int nickelVeinsPerChunk;
    public static int tinVeinSize;
    public static int tinMinY;
    public static int tinMaxY;
    public static int tinVeinsPerChunk;
    public static int aluminumVeinSize;
    public static int aluminumMinY;
    public static int aluminumMaxY;
    public static int aluminumVeinsPerChunk;
    public static boolean enableBaublesIntegration;
    public static boolean enableMysticalMechanicsIntegration;
    public static boolean pvpEverybodyIsEnemy;
    public static boolean codexCategoryIsProgress;
    public static boolean codexEntryIsProgress;
    public static boolean enableParticleCollisions;
    public static boolean enableParticles;
    public static int melterOreAmount;
    public static int stampPlateAmount;
    public static int stampAspectusAmount;
    public static int stampGearAmount;
    public static int reservoirCapacity;
    public static int miniBoilerCapacity;
    public static float miniBoilerHeatMultiplier;
    public static boolean miniBoilerCanExplode;
    public static int geoSeparatorCapacity;
    public static double ancientGolemKnockbackResistance;
    static Pattern damageRatePattern;
    public static String[] defaultScaleDamagePasses;
    public static String[] defaultScaleDamageRates;
    public static Map<String, Double> scaleDamagePasses;
    public static Map<String, Double> scaleDamageRates;

    public static boolean isBaublesIntegrationEnabled() {
        return enableBaublesIntegration && Loader.isModLoaded((String)"baubles");
    }

    public static boolean isMysticalMechanicsIntegrationEnabled() {
        return enableMysticalMechanicsIntegration && Loader.isModLoaded((String)"mysticalmechanics");
    }

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            ConfigManager.load();
        }
    }

    public static void load() {
        Matcher matcher;
        config.addCustomCategoryComment("ores", "Settings related to ore generation.");
        for (String s : config.getStringList("oreBlacklist", "ores", new String[]{"-1", "1"}, "A list of all dimension IDs in which Embers orespawn is prohibited. Embers ores will spawn in any dimension not on this list, but only in vanilla stone.")) {
            orespawnGraylist.add(Integer.valueOf(s));
        }
        orespawnIsWhiteList = config.getBoolean("oreBlacklistIsWhitelist", "ores", false, "Whether the orespawn blacklist is a whitelist.");
        copperVeinSize = config.getInt("copperVeinSize", "ores", 12, 0, 255, "Maximum size of a copper ore vein (in blocks)");
        copperMinY = config.getInt("copperMinY", "ores", 0, 0, 254, "Minimum height over which copper ore will spawn.");
        copperMaxY = config.getInt("copperMaxY", "ores", 64, 1, 255, "Maximum height under which copper ore will spawn.");
        copperVeinsPerChunk = config.getInt("copperVeinsPerChunk", "ores", 6, 0, 255, "Number of attempts to spawn copper ore the world generator will make for each chunk.");
        leadVeinSize = config.getInt("leadVeinSize", "ores", 8, 0, 255, "Maximum size of a lead ore vein (in blocks)");
        leadMinY = config.getInt("leadMinY", "ores", 0, 0, 254, "Minimum height over which lead ore will spawn.");
        leadMaxY = config.getInt("leadMaxY", "ores", 28, 1, 255, "Maximum height under which lead ore will spawn.");
        leadVeinsPerChunk = config.getInt("leadVeinsPerChunk", "ores", 4, 0, 255, "Number of attempts to spawn lead ore the world generator will make for each chunk.");
        silverVeinSize = config.getInt("silverVeinSize", "ores", 6, 0, 255, "Maximum size of a silver ore vein (in blocks)");
        silverMinY = config.getInt("silverMinY", "ores", 0, 0, 254, "Minimum height over which silver ore will spawn.");
        silverMaxY = config.getInt("silverMaxY", "ores", 28, 1, 255, "Maximum height under which silver ore will spawn.");
        silverVeinsPerChunk = config.getInt("silverVeinsPerChunk", "ores", 4, 0, 255, "Number of attempts to spawn silver ore the world generator will make for each chunk.");
        quartzVeinSize = config.getInt("quartzVeinSize", "ores", 8, 0, 255, "Maximum size of a quartz ore vein (in blocks)");
        quartzMinY = config.getInt("quartzMinY", "ores", 0, 0, 254, "Minimum height over which quartz ore will spawn.");
        quartzMaxY = config.getInt("quartzMaxY", "ores", 18, 1, 255, "Maximum height under which quartz ore will spawn.");
        quartzVeinsPerChunk = config.getInt("quartzVeinsPerChunk", "ores", 4, 0, 255, "Number of attempts to spawn quartz ore the world generator will make for each chunk.");
        config.addCustomCategoryComment("mobs", "Settings related to ore generation.");
        ancientGolemSpawnWeight = config.getInt("ancientGolemSpawnWeight", "mobs", 25, 0, Short.MAX_VALUE, "Spawning weight of the Ancient Golem mob. Higher values make golems spawn more frequently.");
        ancientGolemKnockbackResistance = config.getFloat("ancientGolemKnockbackResistance", "mobs", 1.0f, 0.0f, 1.0f, "How much knockback resistance Ancient Golems have.");
        config.addCustomCategoryComment("structures", "Settings related to structure generation.");
        smallRuinChance = config.getInt("smallRuinChance", "structures", 5, 0, Short.MAX_VALUE, "Spawning frequency of the small ruin structure. A value of 0 will prevent spawning altogether.");
        for (String s : config.getStringList("smallRuinBlacklist", "structures", new String[]{"0"}, "A list of all dimension IDs in which Embers small ruin generation is prohibited.")) {
            smallRuinGraylist.add(Integer.valueOf(s));
        }
        smallRuinIsWhiteList = config.getBoolean("smallRuinBlacklistIsWhitelist", "structures", true, "Whether the small ruin generation blacklist is a whitelist.");
        config.addCustomCategoryComment("compat", "Settings related to compatibility with other mods.");
        enableNickel = config.getBoolean("enableNickel", "compat", true, "If true, Embers will register items, blocks, and recipes providing support for other mods' nickel.");
        enableTin = config.getBoolean("enableTin", "compat", true, "If true, Embers will register items, blocks, and recipes providing support for other mods' tin.");
        enableAluminum = config.getBoolean("enableAluminum", "compat", true, "If true, Embers will register items, blocks, and recipes providing support for other mods' aluminum.");
        enableBronze = config.getBoolean("enableBronze", "compat", true, "If true, Embers will register items, blocks, and recipes providing support for other mods' bronze.");
        enableElectrum = config.getBoolean("enableElectrum", "compat", true, "If true, Embers will register items, blocks, and recipes providing support for other mods' electrum.");
        aluminumVeinSize = config.getInt("aluminumVeinSize", "compat", 6, 0, 255, "Maximum size of a aluminum ore vein (in blocks)");
        aluminumMinY = config.getInt("aluminumMinY", "compat", 0, 0, 254, "Minimum height over which aluminum ore will spawn.");
        aluminumMaxY = config.getInt("aluminumMaxY", "compat", 58, 1, 255, "Maximum height under which aluminum ore will spawn.");
        aluminumVeinsPerChunk = config.getInt("aluminumVeinsPerChunk", "compat", 4, 0, 255, "Number of attempts to spawn aluminum ore the world generator will make for each chunk.");
        nickelVeinSize = config.getInt("nickelVeinSize", "compat", 6, 0, 255, "Maximum size of a nickel ore vein (in blocks)");
        nickelMinY = config.getInt("nickelMinY", "compat", 0, 0, 254, "Minimum height over which nickel ore will spawn.");
        nickelMaxY = config.getInt("nickelMaxY", "compat", 24, 1, 255, "Maximum height under which nickel ore will spawn.");
        nickelVeinsPerChunk = config.getInt("nickelVeinsPerChunk", "compat", 4, 0, 255, "Number of attempts to spawn nickel ore the world generator will make for each chunk.");
        tinVeinSize = config.getInt("tinVeinSize", "compat", 6, 0, 255, "Maximum size of a tin ore vein (in blocks)");
        tinMinY = config.getInt("tinMinY", "compat", 0, 0, 254, "Minimum height over which tin ore will spawn.");
        tinMaxY = config.getInt("tinMaxY", "compat", 48, 1, 255, "Maximum height under which tin ore will spawn.");
        tinVeinsPerChunk = config.getInt("tinVeinsPerChunk", "compat", 6, 0, 255, "Number of attempts to spawn tin ore the world generator will make for each chunk.");
        enableBaublesIntegration = config.getBoolean("enableBaubles", "compat", true, "If true, Embers will register items, blocks and recipes providing Baubles integration.");
        enableMysticalMechanicsIntegration = config.getBoolean("enableMysticalMechanics", "compat", true, "If true, Embers will register items, blocks and recipes providing Mystical Mechanics integration.");
        pvpEverybodyIsEnemy = config.getBoolean("everybodyIsAnEnemy", "misc", false, "If true, Embers homing projectiles will go for neutral players.");
        codexCategoryIsProgress = config.getBoolean("codexCategoryIsProgress", "misc", true, "Codex category is shut. Progression is open.");
        codexEntryIsProgress = config.getBoolean("codexEntryIsProgress", "misc", true, "Codex entry is shut and hide. Progression is open and show.");
        enableParticleCollisions = config.getBoolean("enableParticleCollisions", "client", true, "Whether or not particles should collide with blocks. Disabling this might significantly improve performance.");
        enableParticles = config.getBoolean("enableParticles", "client", true, "Whether or not particles are enabled. Disabling this will change the gameplay experience but significantly improve performance.");
        DefaultEmberCapability.allAcceptVolatile = ConfigManager.loadBoolean("parameters.allAcceptVolatile", false, "Whether ember conduits can attach to any ember consumer/producer");
        config.addCustomCategoryComment("parameters", "Settings for machine/item/misc parameters");
        melterOreAmount = ConfigManager.loadInteger("parameters.melter.oreAmount", 144, "How many mb of fluid are obtained per ore output in the melter. This is multiplied by the amount of output a melter would produce, so by default 144mb * 2 ingots.");
        TileEntityFurnaceBottom.PROCESS_TIME = ConfigManager.loadInteger("parameters.melter.processTime", TileEntityFurnaceBottom.PROCESS_TIME, "The time in ticks it takes to process one recipe.");
        TileEntityFurnaceBottom.EMBER_COST = ConfigManager.loadDouble("parameters.melter.cost", TileEntityFurnaceBottom.EMBER_COST, "The ember cost per tick.");
        geoSeparatorCapacity = ConfigManager.loadInteger("parameters.geoSeparator.capacity", 1000, "How much fluid (in mb) fits into a Geologic Seperator");
        stampPlateAmount = ConfigManager.loadInteger("parameters.stamper.plateAmount", 1, "How many ingots are required to make one plate in the stamper.");
        stampAspectusAmount = ConfigManager.loadInteger("parameters.stamper.aspectusAmount", 1, "How many ingots are required to make one aspectus in the stamper.");
        stampGearAmount = ConfigManager.loadInteger("parameters.stamper.gearAmount", 2, "How many ingots are required to make one gear in the stamper.");
        TileEntityStampBase.capacity = ConfigManager.loadInteger("parameters.stamper.capacity", TileEntityStampBase.capacity, "How much fluid (in mb) fits into the Stamp Base.");
        for (String s : ConfigManager.loadStringList("parameters.emberBore.blacklist", new String[0], "A list of all dimension IDs in which Embers Ember Bore will not mine.")) {
            emberBoreGraylist.add(Integer.valueOf(s));
        }
        emberBoreIsWhiteList = ConfigManager.loadBoolean("parameters.emberBore.isWhiteList", false, "Whether the Ember Bore blacklist is a whitelist.");
        emberBoreMaxYLevel = ConfigManager.loadInteger("parameters.emberBore.yMax", 7, "The maximum y-level at which the Ember Bore can mine ember.");
        emberBoreSpeedMod = ConfigManager.loadFloat("parameters.emberBore.speedMod", 1.0f, "The speed modifier of the Ember Bore before upgrades.");
        TileEntityEmberBore.BORE_TIME = ConfigManager.loadInteger("parameters.emberBore.processTime", TileEntityEmberBore.BORE_TIME, "The time in ticks it takes to try one dig attempt.");
        TileEntityEmberBore.FUEL_CONSUMPTION = ConfigManager.loadDouble("parameters.emberBore.fuelCost", TileEntityEmberBore.FUEL_CONSUMPTION, "The amount of fuel consumed each tick");
        TileEntityCharger.MAX_TRANSFER = ConfigManager.loadDouble("parameters.charger.transfer", TileEntityCharger.MAX_TRANSFER, "How much ember is transferred between item and charger per tick");
        TileEntityCinderPlinth.PROCESS_TIME = ConfigManager.loadInteger("parameters.cinderPlinth.processTime", TileEntityCinderPlinth.PROCESS_TIME, "The time in ticks it takes to process one item.");
        TileEntityCinderPlinth.EMBER_COST = ConfigManager.loadDouble("parameters.cinderPlinth.cost", TileEntityCinderPlinth.EMBER_COST, "The ember cost per tick.");
        TileEntityDawnstoneAnvil.MAX_HITS = ConfigManager.loadInteger("parameters.dawnstoneAnvil.maxHits", TileEntityDawnstoneAnvil.MAX_HITS, "Number of hammer hits it takes to finish one process");
        TileEntityInfernoForge.PROCESS_TIME = ConfigManager.loadInteger("parameters.infernoForge.processTime", TileEntityInfernoForge.PROCESS_TIME, "The time in ticks it takes to process one item.");
        TileEntityInfernoForge.EMBER_COST = ConfigManager.loadDouble("parameters.infernoForge.cost", TileEntityInfernoForge.EMBER_COST, "The ember cost per tick.");
        TileEntityInfernoForge.MAX_LEVEL = ConfigManager.loadInteger("parameters.infernoForge.maxLevel", TileEntityInfernoForge.MAX_LEVEL, "The maximum augment level that can be reforged to.");
        TileEntityInfernoForge.MAX_CRYSTAL_VALUE = ConfigManager.loadDouble("parameters.infernoForge.maxCrystalValue", TileEntityInfernoForge.MAX_CRYSTAL_VALUE, "The maximum amount of ember items that can be placed in the forge, in ember energy. Ember clusters are worth 3600 ember, and so the default value is 32 clusters worth.");
        TileEntityInfernoForge.CHANCE_MIDPOINT = ConfigManager.loadDouble("parameters.infernoForge.chanceMidPoint", TileEntityInfernoForge.CHANCE_MIDPOINT, "At exactly this amount of ember items, the chance to successfully reforge is exactly 50%. The default value is 4 clusters worth.");
        TileEntityTank.capacity = ConfigManager.loadInteger("parameters.tank.capacity", TileEntityTank.capacity, "How much fluid (in mb) fits into the Fluid Vessel.");
        reservoirCapacity = ConfigManager.loadInteger("parameters.reservoir.capacity", 40000, "How much fluid (in mb) fits into each Caminite Ring on a Reservoir.");
        miniBoilerCapacity = ConfigManager.loadInteger("parameters.miniBoiler.capacity", 16000, "How much fluid (in mb) fits into a mini boiler.");
        miniBoilerHeatMultiplier = ConfigManager.loadFloat("parameters.miniBoiler.heatMultiplier", 1.0f, "How efficient, heat-wise, the mini boiler is at making steam.");
        miniBoilerCanExplode = ConfigManager.loadBoolean("parameters.miniBoiler.canExplode", true, "Whether or not the mini boiler should explode when at maximum steam pressure.");
        ItemIgnitionCannon.EMBER_COST = ConfigManager.loadDouble("parameters.blazingRay.cost", ItemIgnitionCannon.EMBER_COST, "Ember used up by each shot.");
        ItemIgnitionCannon.MAX_CHARGE = ConfigManager.loadDouble("parameters.blazingRay.charge", ItemIgnitionCannon.MAX_CHARGE, "Time in ticks to fully charge.");
        ItemIgnitionCannon.COOLDOWN = ConfigManager.loadInteger("parameters.blazingRay.cooldown", ItemIgnitionCannon.COOLDOWN, "Cooldown in ticks between each shot.");
        ItemIgnitionCannon.DAMAGE = ConfigManager.loadFloat("parameters.blazingRay.damage", ItemIgnitionCannon.DAMAGE, "Damage dealt by one shot.");
        ItemIgnitionCannon.MAX_DISTANCE = ConfigManager.loadFloat("parameters.blazingRay.distance", ItemIgnitionCannon.MAX_DISTANCE, "Maximum shot distance.");
        ItemIgnitionCannon.MAX_SPREAD = ConfigManager.loadDouble("parameters.blazingRay.spread", ItemIgnitionCannon.MAX_SPREAD, "Maximum spread.");
        ItemCinderStaff.EMBER_COST = ConfigManager.loadDouble("parameters.cinderStaff.cost", ItemCinderStaff.EMBER_COST, "Ember used up by each shot.");
        ItemCinderStaff.MAX_CHARGE = ConfigManager.loadDouble("parameters.cinderStaff.charge", ItemCinderStaff.MAX_CHARGE, "Time in ticks to fully charge.");
        ItemCinderStaff.COOLDOWN = ConfigManager.loadInteger("parameters.cinderStaff.cooldown", ItemCinderStaff.COOLDOWN, "Cooldown in ticks between each shot.");
        ItemCinderStaff.DAMAGE = ConfigManager.loadFloat("parameters.cinderStaff.damage", ItemCinderStaff.DAMAGE, "Damage dealt by one shot.");
        ItemCinderStaff.SIZE = ConfigManager.loadFloat("parameters.cinderStaff.size", ItemCinderStaff.SIZE, "Size of the projectile.");
        ItemCinderStaff.AOE_SIZE = ConfigManager.loadFloat("parameters.cinderStaff.aoe", ItemCinderStaff.AOE_SIZE, "Area of Effect on impact.");
        ItemCinderStaff.LIFETIME = ConfigManager.loadInteger("parameters.cinderStaff.lifetime", ItemCinderStaff.LIFETIME, "Lifetime in ticks of projectile.");
        scaleDamagePasses.clear();
        for (String pair : ConfigManager.loadStringList("parameters.shiftingScales.damagePasses", defaultScaleDamagePasses, "Syntax is 'damagetype:rate'. Determines which damage types are partially unaffected by the shifting scales augment.")) {
            matcher = damageRatePattern.matcher(pair);
            if (!matcher.matches()) continue;
            scaleDamagePasses.put(matcher.group(1), Double.parseDouble(matcher.group(2)));
        }
        scaleDamageRates.clear();
        for (String pair : ConfigManager.loadStringList("parameters.shiftingScales.damageRates", defaultScaleDamageRates, "Syntax is 'damagetype:rate'. Specifies a separate damage rate for depleting the scales.")) {
            matcher = damageRatePattern.matcher(pair);
            if (!matcher.matches()) continue;
            scaleDamageRates.put(matcher.group(1), Double.parseDouble(matcher.group(2)));
        }
        if (ConfigManager.isMysticalMechanicsIntegrationEnabled()) {
            MysticalMechanicsIntegration.loadConfig();
        }
        if (ConfigManager.isBaublesIntegrationEnabled()) {
            BaublesIntegration.loadConfig();
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    private static String[] splitName(String toSplit) {
        String[] splitString = new String[2];
        int i = toSplit.lastIndexOf(".");
        if (i >= 0) {
            splitString[1] = toSplit.substring(i + 1);
            if (i > 1) {
                splitString[0] = toSplit.substring(0, i);
            }
        }
        return splitString;
    }

    public static double loadDouble(String name, double defaultValue, String comment) {
        String[] splitName = ConfigManager.splitName(name);
        return config.getFloat(splitName[1], splitName[0], (float)defaultValue, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY, comment);
    }

    public static float loadFloat(String name, float defaultValue, String comment) {
        String[] splitName = ConfigManager.splitName(name);
        return config.getFloat(splitName[1], splitName[0], defaultValue, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY, comment);
    }

    public static int loadInteger(String name, int defaultValue, String comment) {
        String[] splitName = ConfigManager.splitName(name);
        return config.getInt(splitName[1], splitName[0], defaultValue, Integer.MIN_VALUE, Integer.MAX_VALUE, comment);
    }

    public static boolean loadBoolean(String name, boolean defaultValue, String comment) {
        String[] splitName = ConfigManager.splitName(name);
        return config.getBoolean(splitName[1], splitName[0], defaultValue, comment);
    }

    public static String[] loadStringList(String name, String[] defaultValue, String comment) {
        String[] splitName = ConfigManager.splitName(name);
        return config.getStringList(splitName[1], splitName[0], defaultValue, comment);
    }

    public static boolean isSmallRuinEnabled(int dimension) {
        return smallRuinGraylist.contains(dimension) == smallRuinIsWhiteList && !smallRuinBlacklist.contains(dimension);
    }

    public static boolean isOreSpawnEnabled(int dimension) {
        return orespawnGraylist.contains(dimension) == orespawnIsWhiteList && !orespawnBlacklist.contains(dimension);
    }

    public static boolean isEmberBoreEnabled(int dimension) {
        return emberBoreGraylist.contains(dimension) == emberBoreIsWhiteList;
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("embers")) {
            ConfigManager.load();
        }
    }

    static {
        orespawnGraylist = new HashSet();
        smallRuinGraylist = new HashSet();
        emberBoreGraylist = new HashSet();
        orespawnBlacklist = new ArrayList<Integer>();
        smallRuinBlacklist = new ArrayList<Integer>();
        damageRatePattern = Pattern.compile("(\\w+):(\\d+(?:\\.\\d+|))");
        defaultScaleDamagePasses = new String[]{"drown:1.0", "starve:1.0"};
        defaultScaleDamageRates = new String[0];
        scaleDamagePasses = new HashMap<String, Double>();
        scaleDamageRates = new HashMap<String, Double>();
    }
}

