/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.compat;

import java.util.List;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import mysticalmechanics.api.IGearBehavior;
import mysticalmechanics.api.IGearData;
import mysticalmechanics.api.IMechCapability;
import mysticalmechanics.api.MysticalMechanicsAPI;
import mysticalmechanics.handler.RegistryHandler;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.oredict.ShapedOreRecipe;
import teamroots.embers.ConfigManager;
import teamroots.embers.RegistryManager;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.block.BlockMechActuator;
import teamroots.embers.block.BlockMechActuatorSingle;
import teamroots.embers.block.BlockSteamEngine;
import teamroots.embers.item.ItemBase;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.recipe.ItemStampingRecipe;
import teamroots.embers.recipe.RecipeRegistry;
import teamroots.embers.research.ResearchBase;
import teamroots.embers.research.ResearchManager;
import teamroots.embers.research.subtypes.ResearchFakePage;
import teamroots.embers.research.subtypes.ResearchShowItem;
import teamroots.embers.tileentity.TileEntityMechActuator;
import teamroots.embers.tileentity.TileEntityMechActuatorRenderer;
import teamroots.embers.tileentity.TileEntityMechActuatorSingle;
import teamroots.embers.tileentity.TileEntitySteamEngine;
import teamroots.embers.util.Misc;

public class MysticalMechanicsIntegration {
    public static final ResourceLocation IRON_GEAR_BEHAVIOR = new ResourceLocation("mysticalmechanics", "gear_iron");
    public static final ResourceLocation GOLD_GEAR_BEHAVIOR = new ResourceLocation("mysticalmechanics", "gear_gold");
    public static final ResourceLocation GOLD_GEAR_ON_BEHAVIOR = new ResourceLocation("mysticalmechanics", "gear_gold_on");
    public static final ResourceLocation GOLD_GEAR_OFF_BEHAVIOR = new ResourceLocation("mysticalmechanics", "gear_gold_off");
    public static final ResourceLocation DAWNSTONE_GEAR_BEHAVIOR = new ResourceLocation("embers", "gear_dawnstone");
    public static final double IRON_GEAR_MAX_POWER = 80.0;
    public static final double GOLD_GEAR_MAX_POWER = 320.0;
    public static Item gear_dawnstone;
    public static Block steam_engine;
    public static Block mech_actuator;
    public static Block mech_actuator_single;
    static Random random;

    public static ResourceLocation getRL(String s) {
        return new ResourceLocation("embers", s);
    }

    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        Block axle_iron = Block.func_149684_b((String)"mysticalmechanics:axle_iron");
        event.getRegistry().register(new ShapedOreRecipe(MysticalMechanicsIntegration.getRL("gear_dawnstone"), new ItemStack(gear_dawnstone, 1), new Object[]{true, new Object[]{" N ", "NCN", " N ", Character.valueOf('C'), "nuggetDawnstone", Character.valueOf('N'), "ingotDawnstone"}}).setRegistryName(MysticalMechanicsIntegration.getRL("gear_dawnstone")));
        event.getRegistry().register(new ShapedOreRecipe(MysticalMechanicsIntegration.getRL("mech_actuator_single"), new ItemStack(mech_actuator_single, 1), new Object[]{true, new Object[]{"SPI", Character.valueOf('P'), "gearIron", Character.valueOf('S'), RegistryManager.mech_accessor, Character.valueOf('I'), axle_iron}}).setRegistryName(MysticalMechanicsIntegration.getRL("mech_actuator_single")));
        event.getRegistry().register(new ShapedOreRecipe(MysticalMechanicsIntegration.getRL("mech_actuator"), new ItemStack(mech_actuator, 1), new Object[]{true, new Object[]{" I ", "IPI", "SI ", Character.valueOf('P'), "gearIron", Character.valueOf('S'), RegistryManager.mech_accessor, Character.valueOf('I'), axle_iron}}).setRegistryName(MysticalMechanicsIntegration.getRL("mech_actuator")));
        event.getRegistry().register(new ShapedOreRecipe(MysticalMechanicsIntegration.getRL("steam_engine"), new ItemStack(steam_engine, 1), new Object[]{true, new Object[]{" II", "APC", "FFC", Character.valueOf('C'), "plateCopper", Character.valueOf('P'), "gearIron", Character.valueOf('A'), axle_iron, Character.valueOf('I'), RegistryManager.pipe, Character.valueOf('F'), "plateIron"}}).setRegistryName(MysticalMechanicsIntegration.getRL("steam_engine")));
        Ingredient stampGear = Ingredient.func_193367_a((Item)RegistryManager.stamp_gear);
        int gearAmount = ConfigManager.stampGearAmount * 144;
        RecipeRegistry.stampingRecipes.add(new ItemStampingRecipe(Ingredient.field_193370_a, new FluidStack(RegistryManager.fluid_molten_iron, gearAmount), stampGear, new ItemStack(RegistryHandler.IRON_GEAR, 1)));
        RecipeRegistry.stampingRecipes.add(new ItemStampingRecipe(Ingredient.field_193370_a, new FluidStack(RegistryManager.fluid_molten_gold, gearAmount), stampGear, new ItemStack(RegistryHandler.GOLD_GEAR, 1)));
        RecipeRegistry.stampingRecipes.add(new ItemStampingRecipe(Ingredient.field_193370_a, new FluidStack(RegistryManager.fluid_molten_dawnstone, gearAmount), stampGear, new ItemStack(gear_dawnstone, 1)));
    }

    public static void registerAll() {
        steam_engine = new BlockSteamEngine(Material.field_151576_e, "steam_engine", true).setIsFullCube(false).setIsOpaqueCube(false).setHarvestProperties("pickaxe", 0).func_149711_c(1.0f);
        RegistryManager.blocks.add(steam_engine);
        mech_actuator = new BlockMechActuator(Material.field_151576_e, "mech_actuator", true).setIsFullCube(false).setIsOpaqueCube(false).setHarvestProperties("pickaxe", 0).func_149711_c(1.0f);
        RegistryManager.blocks.add(mech_actuator);
        mech_actuator_single = new BlockMechActuatorSingle(Material.field_151576_e, "mech_actuator_single", true).setIsFullCube(false).setIsOpaqueCube(false).setHarvestProperties("pickaxe", 0).func_149711_c(1.0f);
        RegistryManager.blocks.add(mech_actuator_single);
        gear_dawnstone = new ItemBase("gear_dawnstone", true);
        RegistryManager.items.add(gear_dawnstone);
        GameRegistry.registerTileEntity(TileEntitySteamEngine.class, (String)"embers:tile_entity_steam_engine");
        GameRegistry.registerTileEntity(TileEntityMechActuator.class, (String)"embers:tile_entity_mech_actuator");
        GameRegistry.registerTileEntity(TileEntityMechActuatorSingle.class, (String)"embers:tile_entity_mech_actuator_single");
    }

    public static void initOreDict() {
        OreDictionary.registerOre((String)"gearDawnstone", (Item)gear_dawnstone);
    }

    public static void init() {
        MysticalMechanicsAPI.IMPL.registerGear(DAWNSTONE_GEAR_BEHAVIOR, (Ingredient)new OreIngredient("gearDawnstone"), new IGearBehavior(){

            public double transformPower(TileEntity tile, @Nullable EnumFacing facing, ItemStack gear, IGearData data, double power) {
                return power;
            }

            public void visualUpdate(TileEntity tile, @Nullable EnumFacing facing, ItemStack gear, IGearData data, double powerIn, double powerOut) {
                int particles = Math.min((int)Math.ceil(powerIn / 40.0), 5);
                if (powerIn >= 80.0) {
                    for (int i = 0; i < particles; ++i) {
                        float xOff = 0.1f + random.nextFloat() * 0.8f;
                        float yOff = 0.1f + random.nextFloat() * 0.8f;
                        float zOff = 0.1f + random.nextFloat() * 0.8f;
                        switch (facing.func_176740_k()) {
                            case X: {
                                xOff = 0.5f + (float)facing.func_82601_c() / 2.0f;
                                break;
                            }
                            case Y: {
                                yOff = 0.5f + (float)facing.func_96559_d() / 2.0f;
                                break;
                            }
                            case Z: {
                                zOff = 0.5f + (float)facing.func_82599_e() / 2.0f;
                            }
                        }
                        ParticleUtil.spawnParticleGlow(tile.func_145831_w(), (float)tile.func_174877_v().func_177958_n() + xOff, (float)tile.func_174877_v().func_177956_o() + yOff, (float)tile.func_174877_v().func_177952_p() + zOff, 0.0f, 0.0f, 0.0f, 255.0f, 64.0f, 16.0f, 2.0f, 24);
                    }
                }
            }
        });
        MysticalMechanicsIntegration.replaceBehavior(IRON_GEAR_BEHAVIOR, (Ingredient)new OreIngredient("gearIron"), behavior -> MysticalMechanicsIntegration.wrapPowerLevelBehavior(behavior, 80.0, 1.0));
        MysticalMechanicsIntegration.replaceBehavior(GOLD_GEAR_BEHAVIOR, (Ingredient)new OreIngredient("gearGold"), behavior -> MysticalMechanicsIntegration.wrapPowerLevelBehavior(behavior, 320.0, 1.0));
        MysticalMechanicsIntegration.replaceBehavior(GOLD_GEAR_ON_BEHAVIOR, Ingredient.func_193367_a((Item)RegistryHandler.GOLD_GEAR_ON), behavior -> MysticalMechanicsIntegration.wrapPowerLevelBehavior(behavior, 320.0, 1.0));
        MysticalMechanicsIntegration.replaceBehavior(GOLD_GEAR_OFF_BEHAVIOR, Ingredient.func_193367_a((Item)RegistryHandler.GOLD_GEAR_OFF), behavior -> MysticalMechanicsIntegration.wrapPowerLevelBehavior(behavior, 320.0, 1.0));
    }

    private static void replaceBehavior(ResourceLocation name, Ingredient ingredient, Function<IGearBehavior, IGearBehavior> transformer) {
        IGearBehavior behavior = MysticalMechanicsAPI.IMPL.getGearBehavior(name);
        MysticalMechanicsAPI.IMPL.unregisterGear(name);
        MysticalMechanicsAPI.IMPL.registerGear(name, ingredient, transformer.apply(behavior));
    }

    private static IGearBehavior wrapPowerLevelBehavior(final IGearBehavior behavior, final double max_power, final double slope) {
        return new IGearBehavior(){

            public double transformPower(TileEntity tile, @Nullable EnumFacing facing, ItemStack gear, IGearData data, double power) {
                power = behavior.transformPower(tile, facing, gear, data, power);
                return Misc.getDiminishedPower(power, max_power, slope);
            }

            public void visualUpdate(TileEntity tile, @Nullable EnumFacing facing, ItemStack gear, IGearData data, double powerIn, double powerOut) {
                behavior.visualUpdate(tile, facing, gear, data, powerIn, powerOut);
            }
        };
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerClientSide() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMechActuator.class, (TileEntitySpecialRenderer)new TileEntityMechActuatorRenderer());
    }

    public static void initMysticalMechanicsCategory() {
        ResearchManager.gearbox = new ResearchBase("gearbox", new ItemStack((Block)RegistryHandler.GEARBOX_FRAME), 2.0, 4.0);
        ResearchManager.mergebox = new ResearchBase("mergebox", new ItemStack((Block)RegistryHandler.MERGEBOX_FRAME), 1.0, 6.0).addAncestor(ResearchManager.gearbox);
        ResearchManager.axle_iron = new ResearchBase("axle_iron", new ItemStack((Block)RegistryHandler.IRON_AXLE), 2.0, 0.0).addAncestor(ResearchManager.gearbox);
        ItemStack gearIron = new ItemStack(RegistryHandler.IRON_GEAR);
        ItemStack gearGold = new ItemStack(RegistryHandler.GOLD_GEAR);
        ItemStack gearDawnstone = new ItemStack(gear_dawnstone);
        ItemStack gearGoldOn = new ItemStack(RegistryHandler.GOLD_GEAR_ON);
        ItemStack gearGoldOff = new ItemStack(RegistryHandler.GOLD_GEAR_OFF);
        ResearchManager.gear_iron = new ResearchShowItem("gear_iron", gearIron, 4.0, 1.0).addItem(new ResearchShowItem.DisplayItem(gearIron)).addAncestor(ResearchManager.gearbox).addPage(new ResearchShowItem("gear_gold", gearGold, 0.0, 0.0).addItem(new ResearchShowItem.DisplayItem(gearGold))).addPage(new ResearchShowItem("gear_redstone", gearGoldOn, 0.0, 0.0).addItem(new ResearchShowItem.DisplayItem(gearGoldOff, gearGoldOn))).addPage(new ResearchShowItem("gear_dawnstone", gearDawnstone, 0.0, 0.0).addItem(new ResearchShowItem.DisplayItem(gearDawnstone)));
        ResearchManager.actuator = new ResearchBase("actuator", new ItemStack(mech_actuator_single), 9.0, 5.0).addAncestor(ResearchManager.gearbox).addPage(new ResearchShowItem("actuator_multi", ItemStack.field_190927_a, 0.0, 0.0).addItem(new ResearchShowItem.DisplayItem(new ItemStack(mech_actuator)))).addPage(new ResearchShowItem("actuator_bore", ItemStack.field_190927_a, 0.0, 0.0).addItem(new ResearchShowItem.DisplayItem(new ItemStack(RegistryManager.ember_bore)))).addPage(new ResearchShowItem("actuator_pump", ItemStack.field_190927_a, 0.0, 0.0).addItem(new ResearchShowItem.DisplayItem(new ItemStack(RegistryManager.mechanical_pump)))).addPage(new ResearchShowItem("actuator_stamper", ItemStack.field_190927_a, 0.0, 0.0).addItem(new ResearchShowItem.DisplayItem(new ItemStack(RegistryManager.stamper)))).addPage(new ResearchShowItem("actuator_mixer", ItemStack.field_190927_a, 0.0, 0.0).addItem(new ResearchShowItem.DisplayItem(new ItemStack(RegistryManager.mixer)))).addPage(new ResearchShowItem("actuator_auto_hammer", ItemStack.field_190927_a, 0.0, 0.0).addItem(new ResearchShowItem.DisplayItem(new ItemStack(RegistryManager.auto_hammer))));
        ResearchFakePage mechanical_mini_boiler = new ResearchFakePage(ResearchManager.mini_boiler, 12.0, 0.0);
        ResearchManager.steam_engine = new ResearchBase("steam_engine", new ItemStack(steam_engine), 9.0, 2.0).addAncestor(ResearchManager.gearbox).addAncestor(mechanical_mini_boiler).addPage(new ResearchBase("steam_engine_overclock", ItemStack.field_190927_a, 0.0, 0.0));
        ResearchManager.subCategoryMechanicalPower.addResearch(ResearchManager.gearbox);
        ResearchManager.subCategoryMechanicalPower.addResearch(ResearchManager.mergebox);
        ResearchManager.subCategoryMechanicalPower.addResearch(ResearchManager.axle_iron);
        ResearchManager.subCategoryMechanicalPower.addResearch(ResearchManager.gear_iron);
        ResearchManager.subCategoryMechanicalPower.addResearch(ResearchManager.actuator);
        ResearchManager.subCategoryMechanicalPower.addResearch(ResearchManager.steam_engine);
        ResearchManager.subCategoryMechanicalPower.addResearch(mechanical_mini_boiler);
    }

    public static void addCapabilityInformation(List<String> text, TileEntity tileEntity, EnumFacing facing) {
        MysticalMechanicsIntegration.addCapabilityMechanicalDescription(text, tileEntity, facing);
    }

    public static void addCapabilityMechanicalDescription(List<String> text, TileEntity tile, EnumFacing facing) {
        Capability capability = MysticalMechanicsAPI.MECH_CAPABILITY;
        if (tile.hasCapability(capability, facing)) {
            IMechCapability mechCapability = (IMechCapability)tile.getCapability(capability, facing);
            boolean canInput = mechCapability.isInput(facing);
            boolean canOutput = mechCapability.isOutput(facing);
            IExtraCapabilityInformation.EnumIOType ioType = MysticalMechanicsIntegration.getEnumIOType(canInput, canOutput);
            if (tile instanceof IExtraCapabilityInformation && ((IExtraCapabilityInformation)tile).hasCapabilityDescription(capability)) {
                ((IExtraCapabilityInformation)tile).addCapabilityDescription(text, capability, facing);
            } else {
                text.add(IExtraCapabilityInformation.formatCapability(ioType, "embers.tooltip.goggles.mechanical", null));
            }
        }
    }

    private static IExtraCapabilityInformation.EnumIOType getEnumIOType(boolean canInput, boolean canOutput) {
        IExtraCapabilityInformation.EnumIOType ioType = canInput && canOutput ? IExtraCapabilityInformation.EnumIOType.BOTH : (canInput ? IExtraCapabilityInformation.EnumIOType.INPUT : (canOutput ? IExtraCapabilityInformation.EnumIOType.OUTPUT : IExtraCapabilityInformation.EnumIOType.NONE));
        return ioType;
    }

    public static void loadConfig() {
        TileEntitySteamEngine.NORMAL_FLUID_THRESHOLD = ConfigManager.loadInteger("parameters.steamEngine.fluidThreshold", TileEntitySteamEngine.NORMAL_FLUID_THRESHOLD, "How much water (in mb) is necessary to start burning solid fuel.");
        TileEntitySteamEngine.NORMAL_FLUID_CONSUMPTION = ConfigManager.loadInteger("parameters.steamEngine.fluidConsumption", TileEntitySteamEngine.NORMAL_FLUID_CONSUMPTION, "How much water (in mb) is consumed every tick while burning solid fuel.");
        TileEntitySteamEngine.FUEL_MULTIPLIER = ConfigManager.loadDouble("parameters.steamEngine.fuelEfficiency", TileEntitySteamEngine.FUEL_MULTIPLIER, "How efficient, time-wise, solid fuel is in the steam turbine. 1 = fuel lasts as long as it would in a furnace.");
        TileEntitySteamEngine.SOLID_POWER = ConfigManager.loadDouble("parameters.steamEngine.fuelPower", TileEntitySteamEngine.SOLID_POWER, "How much mechanical power is generated while burning solid fuel.");
        TileEntitySteamEngine.MAX_POWER = ConfigManager.loadDouble("parameters.steamEngine.maximumPower", TileEntitySteamEngine.MAX_POWER, "How much mechanical power can be generated at max.");
        TileEntitySteamEngine.GAS_CONSUMPTION = ConfigManager.loadInteger("parameters.steamEngine.gasConsumption", TileEntitySteamEngine.GAS_CONSUMPTION, "How much gas (in mb), such as steam, is consumed every tick.");
        TileEntitySteamEngine.CAPACITY = ConfigManager.loadInteger("parameters.steamEngine.capacity", TileEntitySteamEngine.CAPACITY, "How much fluid (in mb) fits into a Steam Engine.");
    }

    static {
        random = new Random();
    }
}

