/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.entity.magmaworm;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import teamroots.embers.entity.EntityMagmaProjectile;
import teamroots.embers.entity.EntityMagmaWorm;
import teamroots.embers.entity.MagmaWormPhase;
import teamroots.embers.entity.magmaworm.Down;

public class DownSeism
extends Down {
    private static final double RANGE_ATTACK = 36.0;
    private boolean impacted;
    private double velocity = 0.5;

    public DownSeism(MagmaWormPhase.PhaseSupplier supplier) {
        super(supplier);
    }

    @Override
    public double getVelocity(EntityMagmaWorm worm) {
        if (this.impacted) {
            return 0.5;
        }
        return this.velocity;
    }

    @Override
    public void onUpdate(EntityMagmaWorm worm) {
        this.velocity = Math.min(2.0, this.velocity + 0.05);
    }

    @Override
    protected Vec3d getTarget(EntityMagmaWorm worm) {
        List<Entity> targets = worm.getAttackTargets(new AxisAlignedBB(worm.field_70165_t - 36.0, worm.field_70163_u - 36.0, worm.field_70161_v - 36.0, worm.field_70165_t + 36.0, worm.field_70163_u + 36.0, worm.field_70161_v + 36.0));
        if (!targets.isEmpty()) {
            Entity target = targets.get(this.random.nextInt(targets.size()));
            double bottom = MagmaWormPhase.getHeight(target.field_70170_p, target.field_70165_t, target.field_70161_v) - 10.0;
            return new Vec3d(target.field_70165_t, bottom, target.field_70161_v);
        }
        return super.getTarget(worm);
    }

    @Override
    public void onDig(EntityMagmaWorm worm) {
        super.onDig(worm);
        if (!this.impacted) {
            int delay = 30;
            for (int i = 0; i < 10; ++i) {
                double angle = this.random.nextDouble() * Math.PI * 2.0;
                double distance = this.random.nextDouble() * 9.0 + 1.0;
                double dx = Math.sin(angle) * distance;
                double dz = Math.cos(angle) * distance;
                double height = MagmaWormPhase.getHeight(worm.field_70170_p, worm.field_70165_t + dx, worm.field_70161_v + dz);
                EntityMagmaProjectile projectile = new EntityMagmaProjectile(worm.field_70170_p, worm);
                projectile.func_70107_b(worm.field_70165_t + dx, height + 0.5, worm.field_70161_v + dz);
                projectile.makePillar(12.0f, delay + i * 5);
                worm.field_70170_p.func_72838_d((Entity)projectile);
            }
            this.impacted = true;
        }
    }
}

