/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.item;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import teamroots.embers.api.power.IEmberPacketProducer;
import teamroots.embers.api.power.IEmberPacketReceiver;
import teamroots.embers.api.tile.ITargetable;
import teamroots.embers.item.ItemBase;
import teamroots.embers.util.Misc;

public class ItemTinkerHammer
extends ItemBase {
    public ItemTinkerHammer() {
        super("tinker_hammer", true);
        this.func_77625_d(1);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        boolean success;
        ItemStack stack = player.func_184586_b(hand);
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (player.func_70093_af()) {
            tagCompound.func_74768_a("targetWorld", world.field_73011_w.getDimension());
            tagCompound.func_74768_a("targetX", pos.func_177958_n());
            tagCompound.func_74768_a("targetY", pos.func_177956_o());
            tagCompound.func_74768_a("targetZ", pos.func_177952_p());
            world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187689_f, SoundCategory.BLOCKS, 1.0f, 1.9f + Misc.random.nextFloat() * 0.2f, false);
            return EnumActionResult.SUCCESS;
        }
        if (tagCompound.func_74764_b("targetX") && (success = this.targetBlock(world, pos, face, stack))) {
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public boolean targetBlock(World world, BlockPos pos, EnumFacing face, ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        int dimension = tagCompound.func_74762_e("targetWorld");
        if (world.field_73011_w.getDimension() != dimension) {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos);
        BlockPos targetPos = new BlockPos(tagCompound.func_74762_e("targetX"), tagCompound.func_74762_e("targetY"), tagCompound.func_74762_e("targetZ"));
        if (tile instanceof IEmberPacketProducer) {
            TileEntity targetTile = world.func_175625_s(targetPos);
            if (targetTile instanceof IEmberPacketReceiver) {
                ((IEmberPacketProducer)tile).setTargetPosition(targetPos, face);
                world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187689_f, SoundCategory.BLOCKS, 1.0f, 0.95f + Misc.random.nextFloat() * 0.1f, false);
                return true;
            }
        } else if (tile instanceof ITargetable) {
            ITargetable targetable = (ITargetable)tile;
            targetable.setTarget(targetPos);
            return true;
        }
        return false;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return new ItemStack((Item)this, 1);
    }

    public boolean func_77634_r() {
        return true;
    }

    public Item func_77668_q() {
        return this;
    }

    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        NBTTagCompound tagCompound;
        if (stack.func_77942_o() && (tagCompound = stack.func_77978_p()).func_74764_b("targetX")) {
            int dimension = tagCompound.func_74762_e("targetWorld");
            if (world.field_73011_w.getDimension() == dimension) {
                BlockPos pos = new BlockPos(tagCompound.func_74762_e("targetX"), tagCompound.func_74762_e("targetY"), tagCompound.func_74762_e("targetZ"));
                IBlockState blockState = world.func_180495_p(pos);
                tooltip.add(I18n.func_135052_a((String)"embers.tooltip.targetingBlock", (Object[])new Object[]{blockState.func_177230_c().func_149732_F()}));
                tooltip.add(" X=" + pos.func_177958_n());
                tooltip.add(" Y=" + pos.func_177956_o());
                tooltip.add(" Z=" + pos.func_177952_p());
            }
        }
    }
}

