/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.itemmod;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import teamroots.embers.SoundManager;
import teamroots.embers.api.EmbersAPI;
import teamroots.embers.api.itemmod.ItemModUtil;
import teamroots.embers.api.itemmod.ModifierBase;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageResonatingBellFX;
import teamroots.embers.util.EmberInventoryUtil;

public class ModifierResonatingBell
extends ModifierBase {
    public static HashMap<UUID, Float> cooldownTicksServer = new HashMap();

    public ModifierResonatingBell() {
        super(ModifierBase.EnumType.TOOL, "resonating_bell", 5.0, true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void setCooldown(UUID uuid, float ticks) {
        cooldownTicksServer.put(uuid, Float.valueOf(ticks));
    }

    public static boolean hasCooldown(UUID uuid) {
        return cooldownTicksServer.getOrDefault(uuid, Float.valueOf(0.0f)).floatValue() > 0.0f;
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            for (UUID uuid : cooldownTicksServer.keySet()) {
                Float ticks = Float.valueOf(cooldownTicksServer.get(uuid).floatValue() - 1.0f);
                cooldownTicksServer.put(uuid, ticks);
            }
        }
    }

    @SubscribeEvent
    public void onClick(PlayerInteractEvent.RightClickBlock event) {
        ItemStack heldStack = event.getItemStack();
        World world = event.getWorld();
        EntityPlayer player = event.getEntityPlayer();
        BlockPos pos = event.getPos();
        if (ItemModUtil.hasHeat(heldStack)) {
            int level = ItemModUtil.getModifierLevel(heldStack, EmbersAPI.RESONATING_BELL);
            UUID uuid = player.func_110124_au();
            if (!world.field_72995_K && level > 0 && EmberInventoryUtil.getEmberTotal(player) >= EmbersAPI.RESONATING_BELL.cost && !ModifierResonatingBell.hasCooldown(uuid)) {
                double resonance = EmbersAPI.getEmberEfficiency(heldStack);
                int blockLimit = (int)((double)(150 * level) * resonance);
                int radius = (int)(1.0 + (double)(3 * level) * resonance);
                ModifierResonatingBell.setCooldown(uuid, 80.0f);
                IBlockState state = world.func_180495_p(pos);
                int count = 0;
                ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
                BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(pos);
                int baseX = pos.func_177958_n();
                int baseY = pos.func_177956_o();
                int baseZ = pos.func_177952_p();
                for (int i = -radius; i <= radius; ++i) {
                    block1: for (int j = -radius; j <= radius; ++j) {
                        for (int k = -radius; k <= radius; ++k) {
                            mutablePos.func_181079_c(baseX + i, baseY + j, baseZ + k);
                            if (world.func_180495_p((BlockPos)mutablePos) != state) continue;
                            positions.add(mutablePos.func_185334_h());
                            if (++count > blockLimit) continue block1;
                        }
                    }
                }
                if (count <= blockLimit) {
                    for (BlockPos p : positions) {
                        PacketHandler.INSTANCE.sendToAll((IMessage)new MessageResonatingBellFX((double)p.func_177958_n() + 0.5, (double)p.func_177956_o() + 0.5, (double)p.func_177952_p() + 0.5));
                    }
                    world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundManager.RESONATING_BELL, SoundCategory.PLAYERS, 1.0f, 1.0f);
                } else {
                    world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundManager.RESONATING_BELL, SoundCategory.PLAYERS, 1.0f, 0.1f);
                }
                EmberInventoryUtil.removeEmber(player, EmbersAPI.RESONATING_BELL.cost);
            }
        }
    }
}

