/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.api.tile.IExtraDialInformation;
import teamroots.embers.block.BlockMechAccessor;
import teamroots.embers.tileentity.IMultiblockMachine;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;

public class TileEntityMechAccessor
extends TileEntity
implements ITileEntityBase,
IExtraDialInformation,
IExtraCapabilityInformation {
    static HashSet<Class<? extends TileEntity>> ACCESSIBLE_TILES = new HashSet();
    Random random = new Random();

    public static void registerAccessibleTile(Class<? extends TileEntity> type) {
        ACCESSIBLE_TILES.add(type);
    }

    public static boolean canAccess(TileEntity tile) {
        Class<?> tileClass = tile.getClass();
        return tile instanceof IMultiblockMachine || ACCESSIBLE_TILES.stream().anyMatch(type -> type.isAssignableFrom(tileClass));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        EnumFacing accessFace = this.getFacing();
        TileEntity tile = this.getAttachedMultiblock(accessFace);
        return tile != null && TileEntityMechAccessor.canAccess(tile) && tile.hasCapability(capability, accessFace) || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        EnumFacing accessFace = this.getFacing();
        TileEntity tile = this.getAttachedMultiblock(accessFace);
        return (T)(tile != null && TileEntityMechAccessor.canAccess(tile) ? tile.getCapability(capability, accessFace) : super.getCapability(capability, facing));
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        world.func_175690_a(pos, null);
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this);
    }

    public EnumFacing getFacing() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() instanceof BlockMechAccessor) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockMechAccessor.facing);
        }
        return null;
    }

    public TileEntity getAttachedMultiblock(EnumFacing facing) {
        if (facing != null) {
            TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing.func_176734_d()));
            return tileEntity;
        }
        return null;
    }

    @Override
    public void addDialInformation(EnumFacing facing, List<String> information, String dialType) {
        EnumFacing accessFace = this.getFacing();
        TileEntity tile = this.getAttachedMultiblock(accessFace);
        if (tile instanceof IExtraDialInformation && TileEntityMechAccessor.canAccess(tile)) {
            ((IExtraDialInformation)tile).addDialInformation(accessFace, information, dialType);
        }
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        EnumFacing accessFace = this.getFacing();
        TileEntity tile = this.getAttachedMultiblock(accessFace);
        if (tile instanceof IExtraCapabilityInformation && TileEntityMechAccessor.canAccess(tile)) {
            return ((IExtraCapabilityInformation)tile).hasCapabilityDescription(capability);
        }
        return false;
    }

    @Override
    public void addCapabilityDescription(List<String> strings, Capability<?> capability, EnumFacing facing) {
        EnumFacing accessFace = this.getFacing();
        TileEntity tile = this.getAttachedMultiblock(accessFace);
        if (tile instanceof IExtraCapabilityInformation && TileEntityMechAccessor.canAccess(tile)) {
            ((IExtraCapabilityInformation)tile).addCapabilityDescription(strings, capability, accessFace);
        }
    }

    @Override
    public void addOtherDescription(List<String> strings, EnumFacing facing) {
        EnumFacing accessFace = this.getFacing();
        TileEntity tile = this.getAttachedMultiblock(accessFace);
        if (tile instanceof IExtraCapabilityInformation && TileEntityMechAccessor.canAccess(tile)) {
            ((IExtraCapabilityInformation)tile).addOtherDescription(strings, accessFace);
        }
    }
}

