/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.itemmod;

import java.util.ListIterator;
import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import teamroots.embers.api.EmbersAPI;
import teamroots.embers.api.event.EmberProjectileEvent;
import teamroots.embers.api.itemmod.ItemModUtil;
import teamroots.embers.api.itemmod.ModifierProjectileBase;
import teamroots.embers.api.projectile.EffectArea;
import teamroots.embers.api.projectile.EffectDamage;
import teamroots.embers.api.projectile.EffectMulti;
import teamroots.embers.api.projectile.IProjectileEffect;
import teamroots.embers.api.projectile.IProjectilePreset;
import teamroots.embers.api.projectile.ProjectileFireball;
import teamroots.embers.api.projectile.ProjectileRay;

public class ModifierDiffraction
extends ModifierProjectileBase {
    public ModifierDiffraction() {
        super("diffraction", 2.0, true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SubscribeEvent
    public void onProjectileFire(EmberProjectileEvent event) {
        ListIterator<IProjectilePreset> projectiles = event.getProjectiles().listIterator();
        ItemStack weapon = event.getStack();
        if (weapon.func_190926_b() || !ItemModUtil.hasHeat(weapon)) return;
        int level = ItemModUtil.getModifierLevel(weapon, EmbersAPI.DIFFRACTION);
        EntityLivingBase shooter = event.getShooter();
        Random random = shooter.field_70170_p.field_73012_v;
        if (level <= 0) return;
        while (projectiles.hasNext()) {
            IProjectilePreset projectile = projectiles.next();
            Vec3d velocity = projectile.getVelocity();
            double speed = velocity.func_72433_c();
            int bullets = 3 + level;
            IProjectileEffect effect = projectile.getEffect();
            if (projectile instanceof ProjectileRay) {
                double newspeed = 1.0;
                this.adjustEffect(effect, 0.3333333333333333);
                projectiles.remove();
                for (int i = 0; i < bullets; ++i) {
                    double spread = 0.1 * (double)level;
                    Vec3d newVelocity = velocity.func_72441_c((random.nextDouble() - 0.5) * speed * 2.0 * spread, (random.nextDouble() - 0.5) * speed * 2.0 * spread, (random.nextDouble() - 0.5) * speed * 2.0 * spread).func_186678_a(newspeed / speed);
                    projectiles.add(new ProjectileFireball(projectile.getShooter(), projectile.getPos(), newVelocity, 2.4, 80, effect));
                }
                continue;
            }
            if (!(projectile instanceof ProjectileFireball)) continue;
            ProjectileFireball fireball = (ProjectileFireball)projectile;
            this.adjustEffect(effect, 0.3333333333333333);
            projectiles.remove();
            for (int i = 0; i < bullets; ++i) {
                double spread = 0.1 * (double)level;
                Vec3d newVelocity = velocity.func_72441_c((random.nextDouble() - 0.5) * speed * 2.0 * spread, (random.nextDouble() - 0.5) * speed * 2.0 * spread, (random.nextDouble() - 0.5) * speed * 2.0 * spread);
                projectiles.add(new ProjectileFireball(projectile.getShooter(), projectile.getPos(), newVelocity, fireball.getSize() / 3.0, fireball.getLifetime() / 2, effect));
            }
        }
    }

    private void adjustEffect(IProjectileEffect effect, double multiplier) {
        if (effect instanceof EffectArea) {
            EffectArea areaEffect = (EffectArea)effect;
            this.adjustEffect(areaEffect.getEffect(), multiplier);
        } else if (effect instanceof EffectMulti) {
            for (IProjectileEffect subEffect : ((EffectMulti)effect).getEffects()) {
                this.adjustEffect(subEffect, multiplier);
            }
        } else if (effect instanceof EffectDamage) {
            EffectDamage damageEffect = (EffectDamage)effect;
            damageEffect.setDamage((float)((double)damageEffect.getDamage() * multiplier));
            damageEffect.setInvinciblityMultiplier(0.0);
        }
    }
}

