/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.itemmod;

import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import teamroots.embers.SoundManager;
import teamroots.embers.api.EmbersAPI;
import teamroots.embers.api.itemmod.ItemModUtil;
import teamroots.embers.api.itemmod.ModifierBase;
import teamroots.embers.util.RenderUtil;

public class ModifierWindingGears
extends ModifierBase {
    public static final ResourceLocation TEXTURE_HUD = new ResourceLocation("embers:textures/gui/icons.png");
    public static final int BAR_U = 0;
    public static final int BAR_V = 32;
    public static final int BAR_WIDTH = 180;
    public static final int BAR_HEIGHT = 8;
    public static final String TAG_CHARGE = "windingGearsCharge";
    public static final String TAG_CHARGE_TIME = "windingGearsLastTime";
    public static final double MAX_CHARGE = 500.0;
    public static final int CHARGE_DECAY_DELAY = 20;
    public static final double CHARGE_DECAY = 0.25;
    static int ticks;
    static double angle;
    static double angleLast;
    static int spool;
    static int spoolLast;
    static ThreadLocal<Map<Entity, Double>> bounceLocal;

    public ModifierWindingGears() {
        super(ModifierBase.EnumType.ALL, "winding_gears", 0.0, true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean canApplyTo(ItemStack stack) {
        return super.canApplyTo(stack) && (this.canApplyToType(stack, ModifierBase.EnumType.TOOL) || this.canApplyToType(stack, ModifierBase.EnumType.BOOTS));
    }

    @SideOnly(value=Side.CLIENT)
    private int getBarY(ScaledResolution resolution) {
        return resolution.func_78328_b() - 31;
    }

    @SideOnly(value=Side.CLIENT)
    private int getBarX(ScaledResolution resolution) {
        return resolution.func_78326_a() / 2 - 11 - 81;
    }

    public static ItemStack getHeldClockworkTool(EntityLivingBase entity) {
        boolean isClockworkOff;
        ItemStack mainStack = entity.func_184614_ca();
        ItemStack offStack = entity.func_184592_cb();
        boolean isClockworkMain = ModifierWindingGears.isClockworkTool(mainStack);
        if (isClockworkMain == (isClockworkOff = ModifierWindingGears.isClockworkTool(offStack))) {
            return ItemStack.field_190927_a;
        }
        if (isClockworkMain) {
            return mainStack;
        }
        return offStack;
    }

    public static boolean isClockworkTool(ItemStack stack) {
        return ItemModUtil.hasHeat(stack) && ItemModUtil.hasModifier(stack, EmbersAPI.WINDING_GEARS);
    }

    public static double getChargeDecay(World world, ItemStack stack) {
        return 0.25;
    }

    public static double getCharge(World world, ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null) {
            long dTime = ModifierWindingGears.getTimeSinceLastCharge(world, stack);
            return Math.max(0.0, tagCompound.func_74769_h(TAG_CHARGE) - (double)Math.max(0L, dTime - 20L) * ModifierWindingGears.getChargeDecay(world, stack));
        }
        return 0.0;
    }

    private static long getTimeSinceLastCharge(World world, ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null) {
            long currentTime;
            long lastTime = tagCompound.func_74763_f(TAG_CHARGE_TIME);
            if (lastTime > (currentTime = world.func_82737_E())) {
                return 0L;
            }
            return currentTime - lastTime;
        }
        return Long.MAX_VALUE;
    }

    public static double getMaxCharge(World world, ItemStack stack) {
        int level = ModifierWindingGears.getClockworkLevel(stack);
        return Math.min(200.0 * (double)level, 500.0);
    }

    private static int getClockworkLevel(ItemStack stack) {
        int level = ItemModUtil.getModifierLevel(stack, EmbersAPI.WINDING_GEARS);
        return level;
    }

    public static void setCharge(World world, ItemStack stack, double charge) {
        if (world.field_72995_K) {
            return;
        }
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null) {
            tagCompound.func_74780_a(TAG_CHARGE, charge);
            tagCompound.func_74772_a(TAG_CHARGE_TIME, world.func_82737_E());
        }
    }

    public static void depleteCharge(World world, ItemStack stack, double charge) {
        ModifierWindingGears.setCharge(world, stack, Math.max(0.0, ModifierWindingGears.getCharge(world, stack) - charge));
    }

    public static void addCharge(World world, ItemStack stack, double charge) {
        if (world.field_72995_K) {
            return;
        }
        ModifierWindingGears.setCharge(world, stack, Math.min(ModifierWindingGears.getMaxCharge(world, stack), ModifierWindingGears.getCharge(world, stack) + charge));
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null) {
            tagCompound.func_74772_a(TAG_CHARGE_TIME, world.func_82737_E());
        }
    }

    public static float getSpeedBonus(World world, ItemStack stack) {
        double charge = ModifierWindingGears.getCharge(world, stack);
        return (float)MathHelper.func_151238_b((double)-0.2, (double)20.0, (double)((charge - 50.0) / 300.0));
    }

    public static float getDamageBonus(World world, ItemStack stack) {
        double charge = ModifierWindingGears.getCharge(world, stack);
        return (float)MathHelper.func_151238_b((double)1.0, (double)6.0, (double)((charge - 50.0) / 300.0));
    }

    public static double getRotationSpeed(World world, ItemStack stack) {
        long dTime = ModifierWindingGears.getTimeSinceLastCharge(world, stack);
        double charge = ModifierWindingGears.getCharge(world, stack);
        double standardSpeed = MathHelper.func_151238_b((double)0.0, (double)400.0, (double)(charge / 500.0));
        if (dTime > 20L && charge > 0.0) {
            return MathHelper.func_151238_b((double)0.0, (double)-10.0, (double)((double)(dTime - 20L) / 10.0));
        }
        return MathHelper.func_151238_b((double)standardSpeed, (double)0.0, (double)((double)(dTime - 10L) / 10.0));
    }

    @SubscribeEvent
    public void onJump(LivingEvent.LivingJumpEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        ItemStack stack = ModifierWindingGears.getHeldClockworkTool(entity);
        if (!stack.func_190926_b() && ModifierWindingGears.isClockworkTool(entity.func_184582_a(EntityEquipmentSlot.FEET))) {
            double charge = ModifierWindingGears.getCharge(entity.field_70170_p, stack);
            double cost = Math.max(16.0, charge * 0.16);
            if (charge > 0.0) {
                if (entity.func_70051_ag() && charge > Math.max(40.0, cost * 1.5)) {
                    entity.field_70159_w *= 2.0;
                    entity.field_70179_y *= 2.0;
                    cost = Math.max(40.0, cost * 1.5);
                }
                entity.field_70181_x += MathHelper.func_151238_b((double)0.0, (double)0.35, (double)(charge / 500.0));
                if (charge >= cost) {
                    entity.func_184185_a(SoundManager.WINDING_GEARS_SPRING, 1.0f, 1.0f);
                }
            }
            if (!entity.field_70170_p.field_72995_K) {
                ModifierWindingGears.depleteCharge(entity.field_70170_p, stack, cost);
            }
        }
    }

    @SubscribeEvent
    public void onTick(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        Map<Entity, Double> bounce = bounceLocal.get();
        if (bounce.containsKey(entity)) {
            entity.field_70181_x += bounce.get(entity).doubleValue();
            bounce.remove(entity);
        }
    }

    @SubscribeEvent
    public void onFall(LivingFallEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        ItemStack stack = ModifierWindingGears.getHeldClockworkTool(entity);
        if (!stack.func_190926_b() && ModifierWindingGears.isClockworkTool(entity.func_184582_a(EntityEquipmentSlot.FEET))) {
            double spoolCost = Math.max(0.0f, event.getDistance() - 1.0f) * 5.0f;
            if (ModifierWindingGears.getCharge(entity.field_70170_p, stack) >= spoolCost) {
                event.setDamageMultiplier(0.0f);
                if (entity.field_70181_x < -0.5) {
                    if (!entity.field_70170_p.field_72995_K) {
                        ModifierWindingGears.depleteCharge(entity.field_70170_p, stack, spoolCost);
                    }
                    bounceLocal.get().put((Entity)entity, -entity.field_70181_x);
                }
            }
        }
    }

    @SubscribeEvent
    public void onAttack(LivingDamageEvent event) {
        DamageSource source = event.getSource();
        if (source.func_76346_g() instanceof EntityLivingBase) {
            EntityLivingBase player = (EntityLivingBase)source.func_76346_g();
            ItemStack mainStack = player.func_184614_ca();
            float damage = event.getAmount();
            if (ModifierWindingGears.isClockworkTool(mainStack)) {
                double charge = ModifierWindingGears.getCharge(player.field_70170_p, mainStack);
                double cost = 5.0;
                if (charge >= ModifierWindingGears.getMaxCharge(player.field_70170_p, mainStack)) {
                    cost = charge;
                }
                if (!player.field_70170_p.field_72995_K) {
                    ModifierWindingGears.depleteCharge(player.field_70170_p, mainStack, cost);
                }
            }
        }
    }

    @SubscribeEvent
    public void getBreakSpeed(PlayerEvent.BreakSpeed event) {
        double charge;
        EntityPlayer player = event.getEntityPlayer();
        ItemStack mainStack = player.func_184614_ca();
        float speed = event.getNewSpeed();
        if (ModifierWindingGears.isClockworkTool(mainStack) && (charge = ModifierWindingGears.getCharge(player.field_70170_p, mainStack)) > 0.0) {
            event.setNewSpeed(Math.max(Math.min(speed, 0.1f), speed + ModifierWindingGears.getSpeedBonus(player.field_70170_p, mainStack)));
        }
    }

    @SubscribeEvent
    public void onBreak(BlockEvent.BreakEvent event) {
        double charge;
        ItemStack mainStack;
        EntityPlayer player = event.getPlayer();
        if (!event.isCanceled() && player != null && ModifierWindingGears.isClockworkTool(mainStack = player.func_184614_ca()) && (charge = ModifierWindingGears.getCharge(player.field_70170_p, mainStack)) > 0.0 && !player.field_70170_p.field_72995_K) {
            ModifierWindingGears.depleteCharge(player.field_70170_p, mainStack, charge);
        }
    }

    @SubscribeEvent
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = event.getItemStack();
        if (ModifierWindingGears.isClockworkTool(stack)) {
            int level = ModifierWindingGears.getClockworkLevel(stack);
            double maxCharge = ModifierWindingGears.getMaxCharge(player.field_70170_p, stack);
            if (level > 0) {
                if (stack.func_77978_p() == null) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                double resonance = EmbersAPI.getEmberEfficiency(stack);
                double charge = ModifierWindingGears.getCharge(player.field_70170_p, stack);
                double addAmount = Math.max((0.025 + 0.01 * (double)level) * (maxCharge - charge), 5.0 * resonance);
                ModifierWindingGears.addCharge(player.field_70170_p, stack, addAmount);
                player.func_184609_a(event.getHand());
                event.setCancellationResult(EnumActionResult.PASS);
                event.setCanceled(true);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientUpdate(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ItemStack stack;
            ++ticks;
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayerSP player = mc.field_71439_g;
            if (player != null && !(stack = ModifierWindingGears.getHeldClockworkTool((EntityLivingBase)player)).func_190926_b()) {
                spoolLast = spool;
                spool = (int)(720.0 * ModifierWindingGears.getCharge(player.field_70170_p, stack) / 500.0);
                angleLast = angle;
                angle += ModifierWindingGears.getRotationSpeed(player.field_70170_p, stack);
                RayTraceResult objectMouseOver = mc.field_71476_x;
                if (mc.field_71474_y.field_74312_F.func_151470_d() && this.canAutoAttack(player, stack, objectMouseOver)) {
                    mc.field_71442_b.func_78764_a((EntityPlayer)player, objectMouseOver.field_72308_g);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private boolean canAutoAttack(EntityPlayerSP player, ItemStack stack, RayTraceResult objectMouseOver) {
        return player.func_184825_o(0.0f) >= 1.0f && ModifierWindingGears.getCharge(player.field_70170_p, stack) > 0.0 && objectMouseOver != null && objectMouseOver.field_72313_a == RayTraceResult.Type.ENTITY && !player.func_184838_M();
    }

    @SideOnly(value=Side.CLIENT)
    private boolean isInvulnerable(Entity entity) {
        return entity.func_190530_aW() || entity instanceof EntityLivingBase && entity.field_70172_ad > 0;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDrawScreenPre(RenderGameOverlayEvent.Pre event) {
        float partialTicks = event.getPartialTicks();
        ScaledResolution resolution = event.getResolution();
        int fill = (int)((float)spoolLast * (1.0f - partialTicks) + (float)spool * partialTicks);
        double currentAngle = angleLast * (double)(1.0f - partialTicks) + angle * (double)partialTicks;
        int gearFrame = (int)(currentAngle * 4.0 / 360.0);
        int uGear = gearFrame % 4 * 10;
        int vGear = 16;
        fill += 16;
        if (event.getType() == RenderGameOverlayEvent.ElementType.JUMPBAR || event.getType() == RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayerSP player = mc.field_71439_g;
            if (player == null) {
                return;
            }
            ItemStack stack = ModifierWindingGears.getHeldClockworkTool((EntityLivingBase)player);
            if (!stack.func_190926_b()) {
                mc.field_71446_o.func_110577_a(TEXTURE_HUD);
                int x = this.getBarX(resolution);
                int y = this.getBarY(resolution);
                int segs = fill / 32;
                int last = fill % 32;
                int u = 0;
                int v = 32;
                int evenWidth = segs * 8;
                int oddWidth = segs * 8 - 4;
                int evenFillBack = MathHelper.func_76125_a((int)(last - 16), (int)0, (int)8);
                int evenFillFront = MathHelper.func_76125_a((int)(last - 24), (int)0, (int)8);
                int oddFillBack = MathHelper.func_76125_a((int)(last - 0), (int)0, (int)8);
                int oddFillFront = MathHelper.func_76125_a((int)(last - 8), (int)0, (int)8);
                RenderUtil.drawTexturedModalRect(x - 9, y - 1, -80.0, (double)uGear / 256.0, (double)vGear / 256.0, (double)(uGear + 10) / 256.0, (double)(vGear + 10) / 256.0, 10, 10);
                RenderUtil.drawTexturedModalRect(x, y, -80.0, (double)u / 256.0, (double)v / 256.0, (double)(u + evenWidth) / 256.0, (double)(v + 8) / 256.0, evenWidth, 8);
                RenderUtil.drawTexturedModalRect(x + evenWidth, y, -80.0, (double)(u + evenWidth) / 256.0, (double)v / 256.0, (double)(u + evenWidth + 8) / 256.0, (double)(v + evenFillFront) / 256.0, 8, evenFillFront);
                RenderUtil.drawTexturedModalRect(x, y, -90.0, (double)u / 256.0, (double)(v += 8) / 256.0, (double)(u + evenWidth) / 256.0, (double)(v + 8) / 256.0, evenWidth, 8);
                RenderUtil.drawTexturedModalRect(x + evenWidth, y + 8 - evenFillBack, -90.0, (double)(u + evenWidth) / 256.0, (double)(v + 8 - evenFillBack) / 256.0, (double)(u + evenWidth + 8) / 256.0, (double)(v + 8) / 256.0, 8, evenFillBack);
                RenderUtil.drawTexturedModalRect(x, y, -80.0, (double)u / 256.0, (double)(v += 8) / 256.0, (double)(u + oddWidth) / 256.0, (double)(v + 8) / 256.0, oddWidth, 8);
                RenderUtil.drawTexturedModalRect(x + oddWidth, y, -80.0, (double)(u + oddWidth) / 256.0, (double)v / 256.0, (double)(u + oddWidth + 8) / 256.0, (double)(v + oddFillFront) / 256.0, 8, oddFillFront);
                RenderUtil.drawTexturedModalRect(x, y, -90.0, (double)u / 256.0, (double)(v += 8) / 256.0, (double)(u + oddWidth) / 256.0, (double)(v + 8) / 256.0, oddWidth, 8);
                RenderUtil.drawTexturedModalRect(x + oddWidth, y + 8 - oddFillBack, -90.0, (double)(u + oddWidth) / 256.0, (double)(v + 8 - oddFillBack) / 256.0, (double)(u + oddWidth + 8) / 256.0, (double)(v + 8) / 256.0, 8, oddFillBack);
                GlStateManager.func_179141_d();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.field_71446_o.func_110577_a(Gui.field_110324_m);
            }
        }
    }

    static {
        bounceLocal = ThreadLocal.withInitial(WeakHashMap::new);
    }
}

