/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import teamroots.embers.EventManager;
import teamroots.embers.SoundManager;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageExplosionCharmFX;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;

public class TileEntityExplosionPedestal
extends TileEntity
implements ITileEntityBase,
ITickable,
IExtraCapabilityInformation {
    Random random = new Random();
    int active = 0;

    public boolean isActive() {
        return this.active > 0;
    }

    public void setActive(int time) {
        this.active = time;
    }

    public void absorb(Explosion explosion) {
        Vec3d explosionPos = explosion.getPosition();
        this.setActive(20);
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184148_a(null, explosionPos.field_72450_a, explosionPos.field_72448_b, explosionPos.field_72449_c, SoundManager.EXPLOSION_CHARM_ABSORB, SoundCategory.BLOCKS, 1.0f, 1.0f);
            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageExplosionCharmFX(explosionPos.field_72450_a, explosionPos.field_72448_b, explosionPos.field_72449_c, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5));
        }
        this.func_70296_d();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("active", this.active);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.active = tag.func_74762_e("active");
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        world.func_175690_a(pos, null);
    }

    public void func_73660_a() {
        --this.active;
        if (!this.field_145850_b.field_72995_K) {
            EventManager.putExplosionCharm(this.field_145850_b, this.field_174879_c);
        }
        if (this.field_145850_b.field_72995_K && this.isActive()) {
            for (int i = 0; i < 4; ++i) {
                float dist = this.random.nextFloat() * ((float)this.active * 1.2f) / 20.0f;
                float xOffset = this.random.nextBoolean() ? 1.0f : -1.0f;
                float zOffset = 0.0f;
                if (this.random.nextBoolean()) {
                    float h = xOffset;
                    xOffset = zOffset;
                    zOffset = h;
                }
                float size = (float)MathHelper.func_151238_b((double)6.0, (double)2.0, (double)(dist / 0.8f));
                int lifetime = (int)(this.random.nextDouble() * MathHelper.func_151238_b((double)20.0, (double)10.0, (double)((double)dist / 20.0)));
                float speed = -1.0f / (float)lifetime;
                ParticleUtil.spawnParticleGlow(this.func_145831_w(), (float)this.field_174879_c.func_177958_n() + 0.5f + (xOffset *= dist), (float)this.field_174879_c.func_177956_o() + 1.0f, (float)this.field_174879_c.func_177952_p() + 0.5f + (zOffset *= dist), xOffset * speed, (this.random.nextFloat() - 0.5f) * 2.0f * 0.04f, zOffset * speed, 255.0f, 64.0f, 16.0f, size, lifetime);
            }
        }
    }
}

