/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.awt.Color;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import teamroots.embers.ConfigManager;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.api.tile.IExtraDialInformation;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.recipe.FluidReactionRecipe;
import teamroots.embers.recipe.RecipeRegistry;
import teamroots.embers.tileentity.IFluidPipeConnectable;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.EnumPipeConnection;
import teamroots.embers.util.Misc;

public class TileEntityReactionChamber
extends TileEntity
implements ITileEntityBase,
ITickable,
IExtraDialInformation,
IExtraCapabilityInformation,
IFluidPipeConnectable {
    Random random = new Random();
    protected FluidTank fluidTank = new FluidTank(this.getCapacity());
    protected FluidTank gasTank = new FluidTank(this.getCapacity());
    FluidStack lastReaction;
    protected IFluidHandler fluidInterface = new IFluidHandler(){

        public IFluidTankProperties[] getTankProperties() {
            return new IFluidTankProperties[]{TileEntityReactionChamber.this.fluidTank.getTankProperties()[0], TileEntityReactionChamber.this.gasTank.getTankProperties()[0]};
        }

        public int fill(FluidStack resource, boolean doFill) {
            return TileEntityReactionChamber.this.fluidTank.fill(resource, doFill);
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return TileEntityReactionChamber.this.gasTank.drain(resource, doDrain);
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return TileEntityReactionChamber.this.gasTank.drain(maxDrain, doDrain);
        }
    };

    public TileEntityReactionChamber() {
        this.fluidTank.setTileEntity((TileEntity)this);
        this.gasTank.setTileEntity((TileEntity)this);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.fluidTank.readFromNBT(tag.func_74775_l("fluidTank"));
        this.gasTank.readFromNBT(tag.func_74775_l("gasTank"));
        this.lastReaction = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("lastReaction"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag.func_74782_a("fluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        tag.func_74782_a("gasTank", (NBTBase)this.gasTank.writeToNBT(new NBTTagCompound()));
        if (this.lastReaction != null) {
            tag.func_74782_a("lastReaction", (NBTBase)this.lastReaction.writeToNBT(new NBTTagCompound()));
        }
        return tag;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return facing != null;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.fluidInterface;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public int getCapacity() {
        return ConfigManager.miniBoilerCapacity;
    }

    public int getFluidAmount() {
        return this.fluidTank.getFluidAmount();
    }

    public int getGasAmount() {
        return this.gasTank.getFluidAmount();
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public FluidTank getGasTank() {
        return this.gasTank;
    }

    public Fluid getFluid() {
        if (this.fluidTank.getFluid() != null) {
            return this.fluidTank.getFluid().getFluid();
        }
        return null;
    }

    public Fluid getGas() {
        if (this.gasTank.getFluid() != null) {
            return this.gasTank.getFluid().getFluid();
        }
        return null;
    }

    public FluidStack getFluidStack() {
        return this.fluidTank.getFluid();
    }

    public FluidStack getGasStack() {
        return this.gasTank.getFluid();
    }

    public void boil(int amount) {
        FluidStack fluid = this.getFluidStack();
        FluidReactionRecipe recipe = RecipeRegistry.getFluidReactionRecipe(fluid);
        if (recipe != null && fluid.amount > 0) {
            int fluidBoiled = MathHelper.func_76125_a((int)amount, (int)1, (int)fluid.amount);
            if (fluidBoiled > 0) {
                fluid = this.fluidTank.drain(fluidBoiled, false);
                FluidStack gas = recipe.getResult(fluid);
                if (gas != null) {
                    this.fluidTank.drain(fluidBoiled, true);
                    gas.amount -= this.gasTank.fill(gas, true);
                }
                this.lastReaction = fluid;
                this.func_70296_d();
            }
        } else {
            this.lastReaction = null;
            this.func_70296_d();
        }
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        world.func_175690_a(pos, null);
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this);
    }

    @Override
    public void addDialInformation(EnumFacing facing, List<String> information, String dialType) {
    }

    @Override
    public int getComparatorData(EnumFacing facing, int data, String dialType) {
        if ("fluid".equals(dialType) && facing.func_176740_k() != EnumFacing.Axis.Y) {
            double fill = (double)this.getGasAmount() / (double)this.getCapacity();
            return fill > 0.0 ? (int)(1.0 + fill * 14.0) : 0;
        }
        return data;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            this.spawnParticles();
        }
        if (!this.field_145850_b.field_72995_K) {
            this.boil(20);
        }
    }

    public void spawnParticles() {
        FluidReactionRecipe recipe = RecipeRegistry.getFluidReactionRecipe(this.lastReaction);
        if (recipe != null) {
            Color fluidColor = recipe.getColor();
            Random random = new Random();
            for (int i = 0; i < 5; ++i) {
                float xOffset = 0.5f + (random.nextFloat() - 0.5f) * 2.0f * 0.4f;
                float yOffset = 1.0f;
                float zOffset = 0.5f + (random.nextFloat() - 0.5f) * 2.0f * 0.4f;
                ParticleUtil.spawnParticleVapor(this.field_145850_b, (float)this.field_174879_c.func_177958_n() + xOffset, (float)this.field_174879_c.func_177956_o() + yOffset, (float)this.field_174879_c.func_177952_p() + zOffset, 0.0f, 0.05f, 0.0f, (float)fluidColor.getRed() / 255.0f, (float)fluidColor.getGreen() / 255.0f, (float)fluidColor.getBlue() / 255.0f, (float)fluidColor.getAlpha() / 255.0f, 4.0f, 2.0f, 20);
            }
        }
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public void addCapabilityDescription(List<String> strings, Capability<?> capability, EnumFacing facing) {
        strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.BOTH, "embers.tooltip.goggles.fluid", null));
    }

    @Override
    public EnumPipeConnection getConnection(EnumFacing facing) {
        return EnumPipeConnection.BLOCK;
    }
}

