/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.embersified.blocks.tiles;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import p455w0rd.embersified.init.ModConfig;
import teamroots.embers.SoundManager;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.power.IEmberPacketProducer;
import teamroots.embers.api.power.IEmberPacketReceiver;
import teamroots.embers.block.BlockEmberPulser;
import teamroots.embers.entity.EntityEmberPacket;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;

public class TileEmitter
extends TileEntity
implements ITileEntityBase,
ITickable,
IEmberPacketProducer {
    public static final double TRANSFER_RATE = 40.0;
    public static final double PULL_RATE = 10.0;
    public IEmberCapability embersCap = new DefaultEmberCapability();
    public IEnergyStorage forgeCap;
    public BlockPos target = null;
    public long ticksExisted = 0L;
    Random random = new Random();
    int offset = this.random.nextInt(40);
    public EnumConnection up = EnumConnection.NONE;
    public EnumConnection down = EnumConnection.NONE;
    public EnumConnection north = EnumConnection.NONE;
    public EnumConnection south = EnumConnection.NONE;
    public EnumConnection east = EnumConnection.NONE;
    public EnumConnection west = EnumConnection.NONE;

    public static EnumConnection connectionFromInt(int value) {
        switch (value) {
            case 0: {
                return EnumConnection.NONE;
            }
            case 1: {
                return EnumConnection.LEVER;
            }
        }
        return EnumConnection.NONE;
    }

    public TileEmitter() {
        this.embersCap.setEmberCapacity(200.0);
        this.forgeCap = new EnergySettable(this);
    }

    public void updateNeighbors(IBlockAccess world) {
        this.down = this.getConnection(world, this.func_174877_v().func_177977_b(), EnumFacing.DOWN);
        this.up = this.getConnection(world, this.func_174877_v().func_177984_a(), EnumFacing.UP);
        this.north = this.getConnection(world, this.func_174877_v().func_177978_c(), EnumFacing.NORTH);
        this.south = this.getConnection(world, this.func_174877_v().func_177968_d(), EnumFacing.SOUTH);
        this.west = this.getConnection(world, this.func_174877_v().func_177976_e(), EnumFacing.WEST);
        this.east = this.getConnection(world, this.func_174877_v().func_177974_f(), EnumFacing.EAST);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("up", this.up.ordinal());
        tag.func_74768_a("down", this.down.ordinal());
        tag.func_74768_a("north", this.north.ordinal());
        tag.func_74768_a("south", this.south.ordinal());
        tag.func_74768_a("west", this.west.ordinal());
        tag.func_74768_a("east", this.east.ordinal());
        if (this.target != null) {
            tag.func_74768_a("targetX", this.target.func_177958_n());
            tag.func_74768_a("targetY", this.target.func_177956_o());
            tag.func_74768_a("targetZ", this.target.func_177952_p());
        }
        this.embersCap.writeToNBT(tag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.up = TileEmitter.connectionFromInt(tag.func_74762_e("up"));
        this.down = TileEmitter.connectionFromInt(tag.func_74762_e("down"));
        this.north = TileEmitter.connectionFromInt(tag.func_74762_e("north"));
        this.south = TileEmitter.connectionFromInt(tag.func_74762_e("south"));
        this.west = TileEmitter.connectionFromInt(tag.func_74762_e("west"));
        this.east = TileEmitter.connectionFromInt(tag.func_74762_e("east"));
        if (tag.func_74764_b("targetX")) {
            this.target = new BlockPos(tag.func_74762_e("targetX"), tag.func_74762_e("targetY"), tag.func_74762_e("targetZ"));
        }
        this.embersCap.readFromNBT(tag);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public EnumConnection getConnection(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return Misc.isValidLever((IBlockAccess)world, (BlockPos)pos, (EnumFacing)side) ? EnumConnection.LEVER : EnumConnection.NONE;
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE((TileEntity)this);
    }

    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        world.func_175690_a(pos, null);
    }

    public void func_73660_a() {
        TileEntity targetTile;
        ++this.ticksExisted;
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockEmberPulser.facing);
        TileEntity attachedTile = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(facing.func_176734_d()));
        if (this.ticksExisted % 5L == 0L && attachedTile != null && this.embersCap.getEmber() < this.embersCap.getEmberCapacity() && attachedTile.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, facing) && ((IEmberCapability)attachedTile.getCapability(EmbersCapabilities.EMBER_CAPABILITY, facing)).getEmber() > 0.0) {
            double removed = ((IEmberCapability)attachedTile.getCapability(EmbersCapabilities.EMBER_CAPABILITY, facing)).removeAmount(10.0, true);
            this.embersCap.addAmount(removed, true);
            if (!this.func_145831_w().field_72995_K) {
                attachedTile.func_70296_d();
            }
        }
        if ((this.ticksExisted + (long)this.offset) % 20L == 0L && this.func_145831_w().func_175687_A(this.func_174877_v()) != 0 && this.target != null && !this.func_145831_w().field_72995_K && this.embersCap.getEmber() > 10.0 && (targetTile = this.func_145831_w().func_175625_s(this.target)) instanceof IEmberPacketReceiver && !((IEmberPacketReceiver)targetTile).isFull()) {
            EntityEmberPacket packet = new EntityEmberPacket(this.func_145831_w());
            Vec3d velocity = this.getBurstVelocity(facing);
            packet.initCustom(this.func_174877_v(), this.target, velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c, Math.min(40.0, this.embersCap.getEmber()));
            this.embersCap.removeAmount(Math.min(40.0, this.embersCap.getEmber()), true);
            this.func_145831_w().func_72838_d((Entity)packet);
            this.func_145831_w().func_184133_a(null, this.field_174879_c, SoundManager.EMBER_EMIT, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    private Vec3d getBurstVelocity(EnumFacing facing) {
        switch (facing) {
            case DOWN: {
                return new Vec3d(0.0, -0.5, 0.0);
            }
            case UP: {
                return new Vec3d(0.0, 0.5, 0.0);
            }
            case NORTH: {
                return new Vec3d(0.0, -0.01, -0.5);
            }
            case SOUTH: {
                return new Vec3d(0.0, -0.01, 0.5);
            }
            case WEST: {
                return new Vec3d(-0.5, -0.01, 0.0);
            }
            case EAST: {
                return new Vec3d(0.5, -0.01, 0.0);
            }
        }
        return Vec3d.field_186680_a;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY || ModConfig.Options.forgeEnergyCanGenerateEmbers && capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return (T)EmbersCapabilities.EMBER_CAPABILITY.cast((Object)this.embersCap);
        }
        if (ModConfig.Options.forgeEnergyCanGenerateEmbers && capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.forgeCap);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void setTargetPosition(BlockPos pos, EnumFacing side) {
        this.target = pos;
        this.func_70296_d();
    }

    public IEmberCapability getEmbersCap() {
        return this.embersCap;
    }

    public static enum EnumConnection {
        NONE,
        LEVER;

    }

    public static class EnergySettable
    implements IEnergyStorage {
        private final IEmberCapability embersCap;
        private final TileEmitter tile;

        public EnergySettable(@Nonnull TileEmitter tile) {
            this.embersCap = tile.getEmbersCap();
            this.tile = tile;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (!this.canReceive()) {
                return 0;
            }
            int amountInEmbersCap = (int)this.embersCap.getEmber();
            int spaceLeftInEmbersCap = (int)this.embersCap.getEmberCapacity() - amountInEmbersCap;
            if (spaceLeftInEmbersCap <= 0) {
                return 0;
            }
            int leftOver = 0;
            double tryToPush = this.embersCap.addAmount((double)maxReceive / ModConfig.Options.mulitiplier, false);
            if (tryToPush > (double)spaceLeftInEmbersCap) {
                leftOver = (int)tryToPush - spaceLeftInEmbersCap;
            }
            if (!simulate) {
                this.embersCap.addAmount((double)maxReceive / ModConfig.Options.mulitiplier, true);
                this.tile.func_70296_d();
                int ret = (int)((double)maxReceive - (double)leftOver * ModConfig.Options.mulitiplier);
                return ret;
            }
            return maxReceive;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return (int)(this.embersCap.getEmber() * ModConfig.Options.mulitiplier);
        }

        public int getMaxEnergyStored() {
            return (int)(this.embersCap.getEmberCapacity() * ModConfig.Options.mulitiplier);
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }

        public void setEnergy(int amount) {
            this.embersCap.setEmber((double)amount / ModConfig.Options.mulitiplier);
        }
    }
}

