/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.embersified.blocks.tiles;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import p455w0rd.embersified.blocks.BlockEmitter;
import p455w0rd.embersified.init.ModConfig;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.power.IEmberPacketReceiver;
import teamroots.embers.entity.EntityEmberPacket;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;

public class TileReceptor
extends TileEntity
implements ITileEntityBase,
ITickable,
IEmberPacketReceiver {
    public static final int TRANSFER_RATE = 10;
    public IEmberCapability embersCap = new DefaultEmberCapability();
    Random random = new Random();
    long ticksExisted = 0L;

    public TileReceptor() {
        this.embersCap.setEmberCapacity(2000.0);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.embersCap.writeToNBT(tag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.embersCap.readFromNBT(tag);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        world.func_175690_a(pos, null);
    }

    public void func_73660_a() {
        ++this.ticksExisted;
        BlockPos pos = this.func_174877_v();
        IBlockState state = this.func_145831_w().func_180495_p(pos);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockEmitter.FACING);
        TileEntity attachedTile = this.func_145831_w().func_175625_s(pos.func_177972_a(facing.func_176734_d()));
        if (this.ticksExisted % 2L == 0L && attachedTile != null && this.embersCap.getEmber() > 0.0) {
            IEnergyStorage cap;
            if (attachedTile.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, facing) && attachedTile.getCapability(EmbersCapabilities.EMBER_CAPABILITY, facing) != null) {
                IEmberCapability cap2 = (IEmberCapability)attachedTile.getCapability(EmbersCapabilities.EMBER_CAPABILITY, facing);
                if (cap2.getEmber() < cap2.getEmberCapacity()) {
                    double added = cap2.addAmount(Math.min(10.0, this.embersCap.getEmber()), true);
                    this.embersCap.removeAmount(added, true);
                    if (!this.func_145831_w().field_72995_K) {
                        attachedTile.func_70296_d();
                    }
                }
            } else if (ModConfig.Options.embersEnergyCanGenerateForgeEnergy && attachedTile.hasCapability(CapabilityEnergy.ENERGY, facing) && attachedTile.getCapability(CapabilityEnergy.ENERGY, facing) != null && (cap = (IEnergyStorage)attachedTile.getCapability(CapabilityEnergy.ENERGY, facing)).canReceive() && cap.getEnergyStored() < cap.getMaxEnergyStored()) {
                int added = cap.receiveEnergy((int)Math.min(10.0 * ModConfig.Options.mulitiplier, this.embersCap.getEmber() * ModConfig.Options.mulitiplier), true);
                if (added > 0) {
                    cap.receiveEnergy((int)Math.min(10.0 * ModConfig.Options.mulitiplier, this.embersCap.getEmber() * ModConfig.Options.mulitiplier), false);
                    this.embersCap.removeAmount((double)added / ModConfig.Options.mulitiplier, true);
                }
                if (!this.func_145831_w().field_72995_K) {
                    attachedTile.func_70296_d();
                }
            }
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return (T)EmbersCapabilities.EMBER_CAPABILITY.cast((Object)this.embersCap);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean isFull() {
        return this.embersCap.getEmber() >= this.embersCap.getEmberCapacity();
    }

    public boolean onReceive(EntityEmberPacket packet) {
        return true;
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE((TileEntity)this);
    }
}

