/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import meldexun.entityculling.plugin.MethodTransformer;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ClassTransformer
implements IClassTransformer {
    private static final Map<String, Map<String, List<MethodTransformer>>> METHOD_TRANSFORMERS = new HashMap<String, Map<String, List<MethodTransformer>>>();
    public static final boolean IS_OPTIFINE_DETECTED;

    private static void registerMethodTransformer(MethodTransformer methodTransformer) {
        Map map = METHOD_TRANSFORMERS.computeIfAbsent(methodTransformer.transformedClassName, key -> new HashMap());
        List list1 = map.computeIfAbsent(methodTransformer.methodName, key -> new ArrayList());
        List list2 = map.computeIfAbsent(methodTransformer.transformedMethodName, key -> new ArrayList());
        list1.add(methodTransformer);
        list2.add(methodTransformer);
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        Map<String, List<MethodTransformer>> map = METHOD_TRANSFORMERS.get(transformedName);
        if (map == null || map.isEmpty()) {
            return basicClass;
        }
        try {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(basicClass);
            classReader.accept((ClassVisitor)classNode, 0);
            for (MethodNode method : classNode.methods) {
                List<MethodTransformer> list = map.get(method.name);
                if (list == null || list.isEmpty()) continue;
                for (MethodTransformer methodTransformer : list) {
                    if (!methodTransformer.canApplyMethodTransform(method)) continue;
                    methodTransformer.applyMethodTransform(method);
                }
            }
            ClassWriter classWriter = new ClassWriter(3);
            try {
                classNode.accept((ClassVisitor)classWriter);
            }
            catch (Exception e) {
                e.printStackTrace();
                return basicClass;
            }
            return classWriter.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return basicClass;
        }
    }

    public static void printMethodInstructions(MethodNode method) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (AbstractInsnNode instruction : method.instructions.toArray()) {
            if (i >= 0) {
                sb.append("\n" + i + " " + ClassTransformer.insnToString(instruction));
            }
            ++i;
        }
        System.out.println(sb.toString());
    }

    public static String insnToString(AbstractInsnNode insn) {
        StringBuilder sb = new StringBuilder(insn.getOpcode() + " " + insn.getClass().getSimpleName() + "\t");
        if (insn instanceof MethodInsnNode) {
            sb.append(" " + ((MethodInsnNode)insn).owner);
            sb.append(" " + ((MethodInsnNode)insn).name);
            sb.append(" " + ((MethodInsnNode)insn).desc);
        } else if (insn instanceof VarInsnNode) {
            sb.append(" " + ((VarInsnNode)insn).var);
        } else if (insn instanceof FieldInsnNode) {
            sb.append(" " + ((FieldInsnNode)insn).owner);
            sb.append(" " + ((FieldInsnNode)insn).name);
            sb.append(" " + ((FieldInsnNode)insn).desc);
        } else if (insn instanceof JumpInsnNode) {
            sb.append(" " + ((JumpInsnNode)insn).label.getLabel());
        } else if (insn instanceof LabelNode) {
            sb.append(" " + ((LabelNode)insn).getLabel());
        } else if (insn instanceof FrameNode) {
            sb.append(" " + ((FrameNode)insn).local);
            sb.append(" " + ((FrameNode)insn).stack);
        }
        return sb.toString();
    }

    static {
        boolean flag = false;
        try {
            Class.forName("optifine.OptiFineClassTransformer", false, ClassTransformer.class.getClassLoader());
            flag = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        IS_OPTIFINE_DETECTED = flag;
        if (!IS_OPTIFINE_DETECTED) {
            ClassTransformer.registerMethodTransformer(new MethodTransformer("buw", "net.minecraft.client.renderer.RenderGlobal", "a", "renderEntities", "(Lvg;Lbxy;F)V", "(Lnet/minecraft/entity/Entity;Lnet/minecraft/client/renderer/culling/ICamera;F)V", method -> {
                AbstractInsnNode targetNode1 = method.instructions.get(297);
                AbstractInsnNode popNode1 = method.instructions.get(691);
                AbstractInsnNode targetNode2 = method.instructions.get(706);
                AbstractInsnNode popNode2 = method.instructions.get(835);
                method.instructions.insertBefore(targetNode1, (AbstractInsnNode)new MethodInsnNode(184, "meldexun/entityculling/plugin/Hook", "renderEntities", "()Z", false));
                method.instructions.insertBefore(targetNode1, (AbstractInsnNode)new JumpInsnNode(154, (LabelNode)popNode1));
                method.instructions.insertBefore(targetNode2, (AbstractInsnNode)new MethodInsnNode(184, "meldexun/entityculling/plugin/Hook", "renderTileEntities", "()Z", false));
                method.instructions.insertBefore(targetNode2, (AbstractInsnNode)new JumpInsnNode(154, (LabelNode)popNode2));
            }));
        } else {
            ClassTransformer.registerMethodTransformer(new MethodTransformer("buw", "net.minecraft.client.renderer.RenderGlobal", "a", "renderEntities", "(Lvg;Lbxy;F)V", "(Lnet/minecraft/entity/Entity;Lnet/minecraft/client/renderer/culling/ICamera;F)V", method -> {
                AbstractInsnNode targetNode1 = method.instructions.get(388);
                AbstractInsnNode popNode1 = method.instructions.get(1034);
                AbstractInsnNode targetNode2 = method.instructions.get(1076);
                AbstractInsnNode popNode2 = method.instructions.get(1271);
                method.instructions.insertBefore(targetNode1, (AbstractInsnNode)new MethodInsnNode(184, "meldexun/entityculling/plugin/Hook$Optifine", "renderEntities", "()Z", false));
                method.instructions.insertBefore(targetNode1, (AbstractInsnNode)new JumpInsnNode(154, (LabelNode)popNode1));
                method.instructions.insertBefore(targetNode2, (AbstractInsnNode)new MethodInsnNode(184, "meldexun/entityculling/plugin/Hook$Optifine", "renderTileEntities", "()Z", false));
                method.instructions.insertBefore(targetNode2, (AbstractInsnNode)new JumpInsnNode(154, (LabelNode)popNode2));
            }));
        }
        ClassTransformer.registerMethodTransformer(new MethodTransformer("bze", "net.minecraft.client.renderer.entity.Render", "a", "shouldRender", "(Lvg;Lbxy;DDD)Z", "(Lnet/minecraft/entity/Entity;Lnet/minecraft/client/renderer/culling/ICamera;DDD)Z", method -> {
            AbstractInsnNode targetNode = method.instructions.get(0);
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new VarInsnNode(25, 0));
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new VarInsnNode(25, 1));
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new VarInsnNode(25, 2));
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new VarInsnNode(24, 3));
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new VarInsnNode(24, 5));
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new VarInsnNode(24, 7));
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new MethodInsnNode(184, "meldexun/entityculling/plugin/Hook", "shouldRender", "(Lnet/minecraft/client/renderer/entity/Render;Lnet/minecraft/entity/Entity;Lnet/minecraft/client/renderer/culling/ICamera;DDD)Z", false));
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new InsnNode(172));
        }));
        ClassTransformer.registerMethodTransformer(new MethodTransformer("bwv", "net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher", "a", "render", "(Lavj;FI)V", "(Lnet/minecraft/tileentity/TileEntity;FI)V", method -> {
            AbstractInsnNode targetNode = method.instructions.get(0);
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new VarInsnNode(25, 1));
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new VarInsnNode(21, 3));
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new VarInsnNode(25, 0));
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/client/renderer/tileentity/TileEntityRendererDispatcher", "drawingBatch", "Z"));
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new MethodInsnNode(184, "meldexun/entityculling/plugin/Hook", "render", "(Lnet/minecraft/tileentity/TileEntity;IZ)Z", false));
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new JumpInsnNode(153, (LabelNode)targetNode));
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new InsnNode(177));
        }));
    }
}

