/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling.plugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import meldexun.entityculling.EntityCullingConfig;
import meldexun.entityculling.integration.CubicChunks;
import meldexun.entityculling.reflection.ReflectionField;
import meldexun.entityculling.reflection.ReflectionMethod;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderUtil;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.common.Loader;

public class Hook {
    private static final ReflectionField<RegistryNamespaced<ResourceLocation, Class<? extends TileEntity>>> FIELD_REGISTRY = new ReflectionField(TileEntity.class, "field_190562_f", "REGISTRY");
    private static final ReflectionField<Set<TileEntity>> FIELD_SET_TILE_ENTITIES = new ReflectionField(RenderGlobal.class, "field_181024_n", "setTileEntities");
    private static final ReflectionField<Framebuffer> FIELD_ENTITY_OUTLINE_FRAMEBUFFER = new ReflectionField(RenderGlobal.class, "field_175015_z", "entityOutlineFramebuffer");
    private static final ReflectionField<ShaderGroup> FIELD_ENTITY_OUTLINE_SHADER = new ReflectionField(RenderGlobal.class, "field_174991_A", "entityOutlineShader");
    private static final List<Entity> ENTITY_LIST_NORMAL_0 = new ArrayList<Entity>();
    private static final List<Entity> ENTITY_LIST_OUTLINE_0 = new ArrayList<Entity>();
    private static final List<Entity> ENTITY_LIST_MULTIPASS_0 = new ArrayList<Entity>();
    private static final List<Entity> ENTITY_LIST_NORMAL_1 = new ArrayList<Entity>();
    private static final List<Entity> ENTITY_LIST_MULTIPASS_1 = new ArrayList<Entity>();
    private static final List<TileEntity> TILE_ENTITY_LIST_NORMAL_0 = new ArrayList<TileEntity>();
    private static final List<TileEntity> TILE_ENTITY_LIST_SYNCHRONIZED_0 = new ArrayList<TileEntity>();
    private static final List<TileEntity> TILE_ENTITY_LIST_NORMAL_1 = new ArrayList<TileEntity>();
    private static final List<TileEntity> TILE_ENTITY_LIST_SYNCHRONIZED_1 = new ArrayList<TileEntity>();
    private static final Set<Class<? extends Entity>> ENTITY_BLACKLIST = new HashSet<Class<? extends Entity>>();
    private static final Set<Class<? extends TileEntity>> TILE_ENTITY_BLACKLIST = new HashSet<Class<? extends TileEntity>>();
    private static boolean entityOutlinesRendered = false;

    private Hook() {
    }

    public static void updateBlacklists() {
        ENTITY_BLACKLIST.clear();
        TILE_ENTITY_BLACKLIST.clear();
        for (String s : EntityCullingConfig.skipHiddenEntityRenderingBlacklist) {
            Class entityClass = EntityList.func_192839_a((String)s);
            if (entityClass == null) continue;
            ENTITY_BLACKLIST.add(entityClass);
        }
        RegistryNamespaced<ResourceLocation, Class<? extends TileEntity>> tileEntityRegistry = FIELD_REGISTRY.get(null);
        for (String s : EntityCullingConfig.skipHiddenTileEntityRenderingBlacklist) {
            Class entityClass = (Class)tileEntityRegistry.func_82594_a((Object)new ResourceLocation(s));
            if (entityClass == null) continue;
            TILE_ENTITY_BLACKLIST.add(entityClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateEntityLists() {
        if (!EntityCullingConfig.enabled) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        RenderManager renderManager = mc.func_175598_ae();
        Entity renderViewEntity = mc.func_175606_aa();
        float partialTicks = mc.func_184121_ak();
        double x = renderViewEntity.field_70169_q + (renderViewEntity.field_70165_t - renderViewEntity.field_70169_q) * (double)partialTicks;
        double y = renderViewEntity.field_70167_r + (renderViewEntity.field_70163_u - renderViewEntity.field_70167_r) * (double)partialTicks;
        double z = renderViewEntity.field_70166_s + (renderViewEntity.field_70161_v - renderViewEntity.field_70166_s) * (double)partialTicks;
        Frustum camera = new Frustum();
        camera.func_78547_a(x, y, z);
        Vec3d camVec = new Vec3d(x, y + (double)renderViewEntity.func_70047_e(), z);
        boolean isThirdPersonView = mc.field_71474_y.field_74320_O != 0;
        boolean isSleeping = renderViewEntity instanceof EntityLivingBase && ((EntityLivingBase)renderViewEntity).func_70608_bn();
        boolean flag = !isThirdPersonView && !isSleeping;
        boolean flag1 = mc.field_71439_g.func_175149_v() && mc.field_71474_y.field_178883_an.func_151470_d();
        for (RenderChunk renderChunk : RenderUtil.getRenderChunks()) {
            List tileEntityList;
            ClassInheritanceMultiMap entityList;
            BlockPos chunkPos = renderChunk.func_178568_j();
            Chunk chunk = mc.field_71441_e.func_175726_f(chunkPos);
            ClassInheritanceMultiMap classInheritanceMultiMap = entityList = !Loader.isModLoaded((String)"cubicchunks") ? chunk.func_177429_s()[chunkPos.func_177956_o() >> 4] : CubicChunks.getEntityList((World)mc.field_71441_e, renderChunk.func_178568_j());
            if (!entityList.isEmpty()) {
                for (Entity entity : entityList) {
                    Render render = renderManager.func_78713_a(entity);
                    if (render == null || !render.func_177071_a(entity, (ICamera)camera, x, y, z) && !entity.func_184215_y((Entity)mc.field_71439_g) || entity == renderViewEntity && flag) continue;
                    boolean flag2 = Hook.checkEntityVisibility(entity, camVec);
                    if (entity.shouldRenderInPass(0)) {
                        if (entity.func_184202_aL() || flag1 && entity instanceof EntityPlayer) {
                            ENTITY_LIST_OUTLINE_0.add(entity);
                        }
                        if (flag2) {
                            ENTITY_LIST_NORMAL_0.add(entity);
                            if (render.func_188295_H_()) {
                                ENTITY_LIST_MULTIPASS_0.add(entity);
                            }
                        }
                    }
                    if (!entity.shouldRenderInPass(1) || !flag2) continue;
                    ENTITY_LIST_NORMAL_1.add(entity);
                    if (!render.func_188295_H_()) continue;
                    ENTITY_LIST_MULTIPASS_1.add(entity);
                }
            }
            if (chunk.func_76621_g() || (tileEntityList = renderChunk.field_178590_b.func_178485_b()).isEmpty()) continue;
            for (TileEntity tileEntity : tileEntityList) {
                if (tileEntity.func_145835_a(x, y, z) > tileEntity.func_145833_n() || !camera.func_78546_a(tileEntity.getRenderBoundingBox()) || !Hook.checkTileEntityVisibility(tileEntity, camVec)) continue;
                if (tileEntity.shouldRenderInPass(0)) {
                    TILE_ENTITY_LIST_NORMAL_0.add(tileEntity);
                }
                if (!tileEntity.shouldRenderInPass(1)) continue;
                TILE_ENTITY_LIST_NORMAL_1.add(tileEntity);
            }
        }
        Set<TileEntity> setTileEntities = FIELD_SET_TILE_ENTITIES.get(mc.field_71438_f);
        if (!setTileEntities.isEmpty()) {
            Set<TileEntity> set = setTileEntities;
            synchronized (set) {
                for (TileEntity tileEntity : setTileEntities) {
                    if (tileEntity.func_145835_a(x, y, z) > tileEntity.func_145833_n() || !camera.func_78546_a(tileEntity.getRenderBoundingBox()) || !mc.field_71441_e.func_175668_a(tileEntity.func_174877_v(), false) || !Hook.checkTileEntityVisibility(tileEntity, camVec)) continue;
                    if (tileEntity.shouldRenderInPass(0)) {
                        TILE_ENTITY_LIST_SYNCHRONIZED_0.add(tileEntity);
                    }
                    if (!tileEntity.shouldRenderInPass(1)) continue;
                    TILE_ENTITY_LIST_SYNCHRONIZED_1.add(tileEntity);
                }
            }
        }
    }

    private static void clearEntityLists() {
        if (!ENTITY_LIST_NORMAL_0.isEmpty()) {
            ENTITY_LIST_NORMAL_0.clear();
        }
        if (!ENTITY_LIST_OUTLINE_0.isEmpty()) {
            ENTITY_LIST_OUTLINE_0.clear();
        }
        if (!ENTITY_LIST_MULTIPASS_0.isEmpty()) {
            ENTITY_LIST_MULTIPASS_0.clear();
        }
        if (!ENTITY_LIST_NORMAL_1.isEmpty()) {
            ENTITY_LIST_NORMAL_1.clear();
        }
        if (!ENTITY_LIST_MULTIPASS_1.isEmpty()) {
            ENTITY_LIST_MULTIPASS_1.clear();
        }
        if (!TILE_ENTITY_LIST_NORMAL_0.isEmpty()) {
            TILE_ENTITY_LIST_NORMAL_0.clear();
        }
        if (!TILE_ENTITY_LIST_SYNCHRONIZED_0.isEmpty()) {
            TILE_ENTITY_LIST_SYNCHRONIZED_0.clear();
        }
        if (!TILE_ENTITY_LIST_NORMAL_1.isEmpty()) {
            TILE_ENTITY_LIST_NORMAL_1.clear();
        }
        if (!TILE_ENTITY_LIST_SYNCHRONIZED_1.isEmpty()) {
            TILE_ENTITY_LIST_SYNCHRONIZED_1.clear();
        }
    }

    public static boolean renderEntities() {
        int pass = MinecraftForgeClient.getRenderPass();
        if (pass == 0) {
            Hook.updateEntityLists();
        }
        if (EntityCullingConfig.enabled) {
            Minecraft mc = Minecraft.func_71410_x();
            RenderManager renderManager = mc.func_175598_ae();
            float partialTicks = mc.func_184121_ak();
            if (pass == 0) {
                if (!ENTITY_LIST_NORMAL_0.isEmpty()) {
                    for (Entity entity : ENTITY_LIST_NORMAL_0) {
                        renderManager.func_188388_a(entity, partialTicks, false);
                    }
                }
                if (!ENTITY_LIST_MULTIPASS_0.isEmpty()) {
                    for (Entity entity : ENTITY_LIST_MULTIPASS_0) {
                        renderManager.func_188388_a(entity, partialTicks, false);
                    }
                }
                if (Hook.isRenderEntityOutlines() && (!ENTITY_LIST_OUTLINE_0.isEmpty() || entityOutlinesRendered)) {
                    Framebuffer entityOutlineFramebuffer = FIELD_ENTITY_OUTLINE_FRAMEBUFFER.get(mc.field_71438_f);
                    ShaderGroup entityOutlineShader = FIELD_ENTITY_OUTLINE_SHADER.get(mc.field_71438_f);
                    mc.field_71441_e.field_72984_F.func_76318_c("entityOutlines");
                    entityOutlineFramebuffer.func_147614_f();
                    boolean bl = entityOutlinesRendered = !ENTITY_LIST_OUTLINE_0.isEmpty();
                    if (!ENTITY_LIST_OUTLINE_0.isEmpty()) {
                        GlStateManager.func_179143_c((int)519);
                        GlStateManager.func_179106_n();
                        entityOutlineFramebuffer.func_147610_a(false);
                        RenderHelper.func_74518_a();
                        renderManager.func_178632_c(true);
                        for (Entity entity : ENTITY_LIST_OUTLINE_0) {
                            renderManager.func_188388_a(entity, partialTicks, false);
                        }
                        renderManager.func_178632_c(false);
                        RenderHelper.func_74519_b();
                        GlStateManager.func_179132_a((boolean)false);
                        entityOutlineShader.func_148018_a(partialTicks);
                        GlStateManager.func_179145_e();
                        GlStateManager.func_179132_a((boolean)true);
                        GlStateManager.func_179127_m();
                        GlStateManager.func_179147_l();
                        GlStateManager.func_179142_g();
                        GlStateManager.func_179143_c((int)515);
                        GlStateManager.func_179126_j();
                        GlStateManager.func_179141_d();
                    }
                    mc.func_147110_a().func_147610_a(false);
                }
            } else if (pass == 1) {
                if (!ENTITY_LIST_NORMAL_1.isEmpty()) {
                    for (Entity entity : ENTITY_LIST_NORMAL_1) {
                        renderManager.func_188388_a(entity, partialTicks, false);
                    }
                }
                if (!ENTITY_LIST_MULTIPASS_1.isEmpty()) {
                    for (Entity entity : ENTITY_LIST_MULTIPASS_1) {
                        renderManager.func_188388_a(entity, partialTicks, false);
                    }
                }
            }
        }
        return EntityCullingConfig.enabled;
    }

    private static boolean isRenderEntityOutlines() {
        RenderGlobal renderGlobal = Minecraft.func_71410_x().field_71438_f;
        if (FIELD_ENTITY_OUTLINE_FRAMEBUFFER.get(renderGlobal) == null) {
            return false;
        }
        return FIELD_ENTITY_OUTLINE_SHADER.get(renderGlobal) != null;
    }

    public static boolean renderTileEntities() {
        int pass = MinecraftForgeClient.getRenderPass();
        if (EntityCullingConfig.enabled) {
            Minecraft mc = Minecraft.func_71410_x();
            float partialTicks = mc.func_184121_ak();
            if (pass == 0) {
                if (!TILE_ENTITY_LIST_NORMAL_0.isEmpty()) {
                    for (TileEntity tileEntity : TILE_ENTITY_LIST_NORMAL_0) {
                        TileEntityRendererDispatcher.field_147556_a.func_180546_a(tileEntity, partialTicks, -1);
                    }
                }
                if (!TILE_ENTITY_LIST_SYNCHRONIZED_0.isEmpty()) {
                    for (TileEntity tileEntity : TILE_ENTITY_LIST_SYNCHRONIZED_0) {
                        TileEntityRendererDispatcher.field_147556_a.func_180546_a(tileEntity, partialTicks, -1);
                    }
                }
            } else if (pass == 1) {
                if (!TILE_ENTITY_LIST_NORMAL_1.isEmpty()) {
                    for (TileEntity tileEntity : TILE_ENTITY_LIST_NORMAL_1) {
                        TileEntityRendererDispatcher.field_147556_a.func_180546_a(tileEntity, partialTicks, -1);
                    }
                }
                if (!TILE_ENTITY_LIST_SYNCHRONIZED_1.isEmpty()) {
                    for (TileEntity tileEntity : TILE_ENTITY_LIST_SYNCHRONIZED_1) {
                        TileEntityRendererDispatcher.field_147556_a.func_180546_a(tileEntity, partialTicks, -1);
                    }
                }
            }
        }
        if (pass == 1) {
            Hook.clearEntityLists();
        }
        return EntityCullingConfig.enabled;
    }

    public static boolean shouldRender(Render<?> render, Entity entity, ICamera camera, double camX, double camY, double camZ) {
        if (!EntityCullingConfig.enabled) {
            AxisAlignedBB axisalignedbb = entity.func_184177_bl().func_186662_g(0.5);
            if (axisalignedbb.func_181656_b() || axisalignedbb.func_72320_b() == 0.0) {
                axisalignedbb = new AxisAlignedBB(entity.field_70165_t - 2.0, entity.field_70163_u - 2.0, entity.field_70161_v - 2.0, entity.field_70165_t + 2.0, entity.field_70163_u + 2.0, entity.field_70161_v + 2.0);
            }
            return entity.func_145770_h(camX, camY, camZ) && (entity.field_70158_ak || camera.func_78546_a(axisalignedbb));
        }
        if (!entity.func_145770_h(camX, camY, camZ)) {
            return false;
        }
        if (entity.field_70158_ak) {
            return true;
        }
        AxisAlignedBB axisalignedbb = entity.func_184177_bl().func_186662_g(0.5);
        if (axisalignedbb.func_181656_b()) {
            axisalignedbb = new AxisAlignedBB(entity.field_70165_t - 2.0, entity.field_70163_u - 2.0, entity.field_70161_v - 2.0, entity.field_70165_t + 2.0, entity.field_70163_u + 2.0, entity.field_70161_v + 2.0);
        }
        return camera.func_78546_a(axisalignedbb);
    }

    public static boolean render(TileEntity tileEntity, int destroyStage, boolean drawingBatch) {
        if (!EntityCullingConfig.enabled) {
            return false;
        }
        Minecraft mc = Minecraft.func_71410_x();
        float partialTicks = mc.func_184121_ak();
        if (!drawingBatch || !tileEntity.hasFastRenderer()) {
            RenderHelper.func_74519_b();
            int i = mc.field_71441_e.func_175626_b(tileEntity.func_174877_v(), 0);
            int j = i % 65536;
            int k = i / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        BlockPos blockpos = tileEntity.func_174877_v();
        double x = (double)blockpos.func_177958_n() - TileEntityRendererDispatcher.field_147554_b;
        double y = (double)blockpos.func_177956_o() - TileEntityRendererDispatcher.field_147555_c;
        double z = (double)blockpos.func_177952_p() - TileEntityRendererDispatcher.field_147552_d;
        TileEntityRendererDispatcher.field_147556_a.func_192854_a(tileEntity, x, y, z, partialTicks, destroyStage, 1.0f);
        return true;
    }

    private static boolean checkEntityVisibility(Entity entity, Vec3d camVec) {
        if (!EntityCullingConfig.skipHiddenEntityRendering) {
            return true;
        }
        if (!entity.func_184222_aU()) {
            return true;
        }
        if ((double)entity.field_70130_N >= EntityCullingConfig.skipHiddenEntityRenderingSize || (double)entity.field_70131_O >= EntityCullingConfig.skipHiddenEntityRenderingSize) {
            return true;
        }
        if (!ENTITY_BLACKLIST.isEmpty() && ENTITY_BLACKLIST.contains(entity.getClass())) {
            return true;
        }
        double maxDiffSquared = EntityCullingConfig.skipHiddenEntityRenderingDiff * EntityCullingConfig.skipHiddenEntityRenderingDiff;
        Minecraft mc = Minecraft.func_71410_x();
        Vec3d end = entity.func_174824_e(mc.func_184121_ak());
        if (camVec.func_72436_e(end) <= maxDiffSquared) {
            return true;
        }
        RayTraceResult result1 = Hook.rayTraceBlocks((World)mc.field_71441_e, camVec, end, false, true, null);
        if (result1 == null || result1.field_72307_f.func_72436_e(end) <= maxDiffSquared) {
            return true;
        }
        RayTraceResult result2 = Hook.rayTraceBlocks((World)mc.field_71441_e, end, camVec, false, true, null);
        if (result2 == null) {
            return true;
        }
        return result1.field_72307_f.func_72436_e(result2.field_72307_f) <= maxDiffSquared;
    }

    private static boolean checkTileEntityVisibility(TileEntity tileEntity, Vec3d camVec) {
        if (!EntityCullingConfig.skipHiddenTileEntityRendering) {
            return true;
        }
        AxisAlignedBB aabb = tileEntity.getRenderBoundingBox();
        if (aabb.field_72336_d - aabb.field_72340_a > EntityCullingConfig.skipHiddenTileEntityRenderingSize || aabb.field_72337_e - aabb.field_72338_b > EntityCullingConfig.skipHiddenTileEntityRenderingSize || aabb.field_72334_f - aabb.field_72339_c > EntityCullingConfig.skipHiddenTileEntityRenderingSize) {
            return true;
        }
        if (!TILE_ENTITY_BLACKLIST.isEmpty() && TILE_ENTITY_BLACKLIST.contains(tileEntity.getClass())) {
            return true;
        }
        double maxDiffSquared = EntityCullingConfig.skipHiddenTileEntityRenderingDiff * EntityCullingConfig.skipHiddenTileEntityRenderingDiff;
        Minecraft mc = Minecraft.func_71410_x();
        BlockPos pos = tileEntity.func_174877_v();
        Vec3d end = new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        if (camVec.func_72436_e(end) <= maxDiffSquared) {
            return true;
        }
        RayTraceResult result1 = Hook.rayTraceBlocks((World)mc.field_71441_e, camVec, end, false, true, pos);
        if (result1 == null || result1.field_72307_f.func_72436_e(end) <= maxDiffSquared) {
            return true;
        }
        RayTraceResult result2 = Hook.rayTraceBlocks((World)mc.field_71441_e, end, camVec, false, true, pos);
        if (result2 == null) {
            return true;
        }
        return result1.field_72307_f.func_72436_e(result2.field_72307_f) <= maxDiffSquared;
    }

    @Nullable
    private static RayTraceResult rayTraceBlocks(World world, Vec3d vec31, Vec3d vec32, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, @Nullable BlockPos toIgnore) {
        if (!(Double.isNaN(vec31.field_72450_a) || Double.isNaN(vec31.field_72448_b) || Double.isNaN(vec31.field_72449_c))) {
            if (!(Double.isNaN(vec32.field_72450_a) || Double.isNaN(vec32.field_72448_b) || Double.isNaN(vec32.field_72449_c))) {
                RayTraceResult raytraceresult;
                int i = MathHelper.func_76128_c((double)vec32.field_72450_a);
                int j = MathHelper.func_76128_c((double)vec32.field_72448_b);
                int k = MathHelper.func_76128_c((double)vec32.field_72449_c);
                int l = MathHelper.func_76128_c((double)vec31.field_72450_a);
                int i1 = MathHelper.func_76128_c((double)vec31.field_72448_b);
                int j1 = MathHelper.func_76128_c((double)vec31.field_72449_c);
                BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos(l, i1, j1);
                IBlockState iblockstate = world.func_180495_p((BlockPos)blockpos);
                Block block = iblockstate.func_177230_c();
                if ((toIgnore == null || !blockpos.equals((Object)toIgnore)) && iblockstate.func_185914_p() && iblockstate.func_185890_d((IBlockAccess)world, (BlockPos)blockpos) != Block.field_185506_k && block.func_176209_a(iblockstate, stopOnLiquid) && (raytraceresult = iblockstate.func_185910_a(world, (BlockPos)blockpos, vec31, vec32)) != null) {
                    return raytraceresult;
                }
                int k1 = 200;
                double x = vec31.field_72450_a;
                double y = vec31.field_72448_b;
                double z = vec31.field_72449_c;
                while (k1-- >= 0) {
                    RayTraceResult raytraceresult1;
                    EnumFacing enumfacing;
                    if (Double.isNaN(x) || Double.isNaN(y) || Double.isNaN(z)) {
                        return null;
                    }
                    if (l == i && i1 == j && j1 == k) {
                        return null;
                    }
                    boolean flag2 = true;
                    boolean flag = true;
                    boolean flag1 = true;
                    double d0 = 999.0;
                    double d1 = 999.0;
                    double d2 = 999.0;
                    if (i > l) {
                        d0 = (double)l + 1.0;
                    } else if (i < l) {
                        d0 = (double)l + 0.0;
                    } else {
                        flag2 = false;
                    }
                    if (j > i1) {
                        d1 = (double)i1 + 1.0;
                    } else if (j < i1) {
                        d1 = (double)i1 + 0.0;
                    } else {
                        flag = false;
                    }
                    if (k > j1) {
                        d2 = (double)j1 + 1.0;
                    } else if (k < j1) {
                        d2 = (double)j1 + 0.0;
                    } else {
                        flag1 = false;
                    }
                    double d3 = 999.0;
                    double d4 = 999.0;
                    double d5 = 999.0;
                    double d6 = vec32.field_72450_a - x;
                    double d7 = vec32.field_72448_b - y;
                    double d8 = vec32.field_72449_c - z;
                    if (flag2) {
                        d3 = (d0 - x) / d6;
                    }
                    if (flag) {
                        d4 = (d1 - y) / d7;
                    }
                    if (flag1) {
                        d5 = (d2 - z) / d8;
                    }
                    if (d3 == -0.0) {
                        d3 = -1.0E-4;
                    }
                    if (d4 == -0.0) {
                        d4 = -1.0E-4;
                    }
                    if (d5 == -0.0) {
                        d5 = -1.0E-4;
                    }
                    if (d3 < d4 && d3 < d5) {
                        enumfacing = i > l ? EnumFacing.WEST : EnumFacing.EAST;
                        x = d0;
                        y += d7 * d3;
                        z += d8 * d3;
                    } else if (d4 < d5) {
                        enumfacing = j > i1 ? EnumFacing.DOWN : EnumFacing.UP;
                        x += d6 * d4;
                        y = d1;
                        z += d8 * d4;
                    } else {
                        enumfacing = k > j1 ? EnumFacing.NORTH : EnumFacing.SOUTH;
                        x += d6 * d5;
                        y += d7 * d5;
                        z = d2;
                    }
                    l = MathHelper.func_76128_c((double)x) - (enumfacing == EnumFacing.EAST ? 1 : 0);
                    i1 = MathHelper.func_76128_c((double)y) - (enumfacing == EnumFacing.UP ? 1 : 0);
                    j1 = MathHelper.func_76128_c((double)z) - (enumfacing == EnumFacing.SOUTH ? 1 : 0);
                    blockpos.func_181079_c(l, i1, j1);
                    iblockstate = world.func_180495_p((BlockPos)blockpos);
                    block = iblockstate.func_177230_c();
                    if (toIgnore != null && blockpos.equals((Object)toIgnore) || !iblockstate.func_185914_p() || iblockstate.func_185890_d((IBlockAccess)world, (BlockPos)blockpos) == Block.field_185506_k || !block.func_176209_a(iblockstate, stopOnLiquid) || (raytraceresult1 = iblockstate.func_185910_a(world, (BlockPos)blockpos, new Vec3d(x, y, z), vec32)) == null) continue;
                    return raytraceresult1;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public static class Optifine {
        private static final ReflectionMethod<Boolean> METHOD_IS_SHADERS = new ReflectionMethod("Config", "isShaders", "isShaders", new Class[0]);
        private static final ReflectionField<Entity> FIELD_RENDERED_ENTITY = new ReflectionField(RenderGlobal.class, "renderedEntity", "renderedEntity");
        private static final ReflectionMethod<?> METHOD_NEXT_ENTITY = new ReflectionMethod("net.optifine.shaders.Shaders", "nextEntity", "nextEntity", Entity.class);
        private static final ReflectionMethod<Boolean> METHOD_IS_FAST_RENDER = new ReflectionMethod("Config", "isFastRender", "isFastRender", new Class[0]);
        private static final ReflectionMethod<Boolean> METHOD_IS_ANTIALIASING = new ReflectionMethod("Config", "isAntialiasing", "isAntialiasing", new Class[0]);
        private static final ReflectionMethod<?> METHOD_NEXT_BLOCK_ENTITY = new ReflectionMethod("net.optifine.shaders.Shaders", "nextBlockEntity", "nextBlockEntity", TileEntity.class);
        private static final ReflectionMethod<?> METHOD_BEGIN_ENTITIES_GLOWING = new ReflectionMethod("net.optifine.shaders.Shaders", "beginEntitiesGlowing", "beginEntitiesGlowing", new Class[0]);
        private static final ReflectionMethod<?> METHOD_END_ENTITIES_GLOWING = new ReflectionMethod("net.optifine.shaders.Shaders", "endEntitiesGlowing", "endEntitiesGlowing", new Class[0]);
        private static final List<Entity> ENTITY_LIST_OUTLINE_1 = new ArrayList<Entity>();

        private Optifine() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void updateEntityLists() {
            Chunk chunk;
            BlockPos chunkPos;
            if (!EntityCullingConfig.enabled) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            RenderManager renderManager = mc.func_175598_ae();
            Entity renderViewEntity = mc.func_175606_aa();
            float partialTicks = mc.func_184121_ak();
            double x = renderViewEntity.field_70169_q + (renderViewEntity.field_70165_t - renderViewEntity.field_70169_q) * (double)partialTicks;
            double y = renderViewEntity.field_70167_r + (renderViewEntity.field_70163_u - renderViewEntity.field_70167_r) * (double)partialTicks;
            double z = renderViewEntity.field_70166_s + (renderViewEntity.field_70161_v - renderViewEntity.field_70166_s) * (double)partialTicks;
            Frustum camera = new Frustum();
            camera.func_78547_a(x, y, z);
            Vec3d camVec = new Vec3d(x, y + (double)renderViewEntity.func_70047_e(), z);
            boolean isThirdPersonView = mc.field_71474_y.field_74320_O != 0;
            boolean isSleeping = renderViewEntity instanceof EntityLivingBase && ((EntityLivingBase)renderViewEntity).func_70608_bn();
            boolean flag = !isThirdPersonView && !isSleeping;
            boolean flag1 = mc.field_71439_g.func_175149_v() && mc.field_71474_y.field_178883_an.func_151470_d();
            for (RenderChunk renderChunk : RenderUtil.Optifine.getRenderChunksEntities()) {
                chunkPos = renderChunk.func_178568_j();
                chunk = mc.field_71441_e.func_175726_f(chunkPos);
                ClassInheritanceMultiMap entityList = !Loader.isModLoaded((String)"cubicchunks") ? chunk.func_177429_s()[chunkPos.func_177956_o() >> 4] : CubicChunks.getEntityList((World)mc.field_71441_e, renderChunk.func_178568_j());
                if (entityList.isEmpty()) continue;
                for (Entity entity : entityList) {
                    Render render = renderManager.func_78713_a(entity);
                    if (render == null || !render.func_177071_a(entity, (ICamera)camera, x, y, z) && !entity.func_184215_y((Entity)mc.field_71439_g) || entity == renderViewEntity && flag) continue;
                    boolean flag2 = Hook.checkEntityVisibility(entity, camVec);
                    if (entity.shouldRenderInPass(0)) {
                        if (entity.func_184202_aL() || flag1 && entity instanceof EntityPlayer) {
                            ENTITY_LIST_OUTLINE_0.add(entity);
                        }
                        if (flag2) {
                            ENTITY_LIST_NORMAL_0.add(entity);
                            if (render.func_188295_H_()) {
                                ENTITY_LIST_MULTIPASS_0.add(entity);
                            }
                        }
                    }
                    if (!entity.shouldRenderInPass(1)) continue;
                    if (entity.func_184202_aL() || flag1 && entity instanceof EntityPlayer) {
                        ENTITY_LIST_OUTLINE_1.add(entity);
                    }
                    if (!flag2) continue;
                    ENTITY_LIST_NORMAL_1.add(entity);
                    if (!render.func_188295_H_()) continue;
                    ENTITY_LIST_MULTIPASS_1.add(entity);
                }
            }
            for (RenderChunk renderChunk : RenderUtil.Optifine.getRenderChunksTileEntities()) {
                List tileEntityList;
                chunkPos = renderChunk.func_178568_j();
                chunk = mc.field_71441_e.func_175726_f(chunkPos);
                if (chunk.func_76621_g() || (tileEntityList = renderChunk.field_178590_b.func_178485_b()).isEmpty()) continue;
                for (TileEntity tileEntity : tileEntityList) {
                    if (tileEntity.func_145835_a(x, y, z) > tileEntity.func_145833_n() || !camera.func_78546_a(tileEntity.getRenderBoundingBox()) || !Hook.checkTileEntityVisibility(tileEntity, camVec)) continue;
                    if (tileEntity.shouldRenderInPass(0)) {
                        TILE_ENTITY_LIST_NORMAL_0.add(tileEntity);
                    }
                    if (!tileEntity.shouldRenderInPass(1)) continue;
                    TILE_ENTITY_LIST_NORMAL_1.add(tileEntity);
                }
            }
            Set setTileEntities = (Set)FIELD_SET_TILE_ENTITIES.get(mc.field_71438_f);
            if (!setTileEntities.isEmpty()) {
                Set set = setTileEntities;
                synchronized (set) {
                    for (TileEntity tileEntity : setTileEntities) {
                        if (tileEntity.func_145835_a(x, y, z) > tileEntity.func_145833_n() || !camera.func_78546_a(tileEntity.getRenderBoundingBox()) || !mc.field_71441_e.func_175668_a(tileEntity.func_174877_v(), false) || !Hook.checkTileEntityVisibility(tileEntity, camVec)) continue;
                        if (tileEntity.shouldRenderInPass(0)) {
                            TILE_ENTITY_LIST_SYNCHRONIZED_0.add(tileEntity);
                        }
                        if (!tileEntity.shouldRenderInPass(1)) continue;
                        TILE_ENTITY_LIST_SYNCHRONIZED_1.add(tileEntity);
                    }
                }
            }
        }

        private static void clearEntityLists() {
            if (!ENTITY_LIST_NORMAL_0.isEmpty()) {
                ENTITY_LIST_NORMAL_0.clear();
            }
            if (!ENTITY_LIST_OUTLINE_0.isEmpty()) {
                ENTITY_LIST_OUTLINE_0.clear();
            }
            if (!ENTITY_LIST_MULTIPASS_0.isEmpty()) {
                ENTITY_LIST_MULTIPASS_0.clear();
            }
            if (!ENTITY_LIST_NORMAL_1.isEmpty()) {
                ENTITY_LIST_NORMAL_1.clear();
            }
            if (!ENTITY_LIST_OUTLINE_1.isEmpty()) {
                ENTITY_LIST_OUTLINE_1.clear();
            }
            if (!ENTITY_LIST_MULTIPASS_1.isEmpty()) {
                ENTITY_LIST_MULTIPASS_1.clear();
            }
            if (!TILE_ENTITY_LIST_NORMAL_0.isEmpty()) {
                TILE_ENTITY_LIST_NORMAL_0.clear();
            }
            if (!TILE_ENTITY_LIST_SYNCHRONIZED_0.isEmpty()) {
                TILE_ENTITY_LIST_SYNCHRONIZED_0.clear();
            }
            if (!TILE_ENTITY_LIST_NORMAL_1.isEmpty()) {
                TILE_ENTITY_LIST_NORMAL_1.clear();
            }
            if (!TILE_ENTITY_LIST_SYNCHRONIZED_1.isEmpty()) {
                TILE_ENTITY_LIST_SYNCHRONIZED_1.clear();
            }
        }

        public static boolean renderEntities() {
            int pass = MinecraftForgeClient.getRenderPass();
            if (pass == 0) {
                Optifine.updateEntityLists();
            }
            if (EntityCullingConfig.enabled) {
                Minecraft mc = Minecraft.func_71410_x();
                RenderManager renderManager = mc.func_175598_ae();
                float partialTicks = mc.func_184121_ak();
                boolean shadersEnabled = Boolean.TRUE.equals(METHOD_IS_SHADERS.invoke(null, new Object[0]));
                if (pass == 0) {
                    if (!ENTITY_LIST_NORMAL_0.isEmpty()) {
                        for (Entity entity : ENTITY_LIST_NORMAL_0) {
                            FIELD_RENDERED_ENTITY.set(mc.field_71438_f, entity);
                            if (shadersEnabled) {
                                METHOD_NEXT_ENTITY.invoke(null, entity);
                            }
                            renderManager.func_188388_a(entity, partialTicks, false);
                            FIELD_RENDERED_ENTITY.set(mc.field_71438_f, null);
                        }
                    }
                    if (!ENTITY_LIST_MULTIPASS_0.isEmpty()) {
                        for (Entity entity : ENTITY_LIST_MULTIPASS_0) {
                            if (shadersEnabled) {
                                METHOD_NEXT_ENTITY.invoke(null, entity);
                            }
                            renderManager.func_188388_a(entity, partialTicks, false);
                        }
                    }
                    if (Optifine.isRenderEntityOutlines() && (!ENTITY_LIST_OUTLINE_0.isEmpty() || entityOutlinesRendered)) {
                        Framebuffer entityOutlineFramebuffer = (Framebuffer)FIELD_ENTITY_OUTLINE_FRAMEBUFFER.get(mc.field_71438_f);
                        ShaderGroup entityOutlineShader = (ShaderGroup)FIELD_ENTITY_OUTLINE_SHADER.get(mc.field_71438_f);
                        mc.field_71441_e.field_72984_F.func_76318_c("entityOutlines");
                        entityOutlineFramebuffer.func_147614_f();
                        entityOutlinesRendered = !ENTITY_LIST_OUTLINE_0.isEmpty();
                        if (!ENTITY_LIST_OUTLINE_0.isEmpty()) {
                            GlStateManager.func_179143_c((int)519);
                            GlStateManager.func_179106_n();
                            entityOutlineFramebuffer.func_147610_a(false);
                            RenderHelper.func_74518_a();
                            renderManager.func_178632_c(true);
                            for (Entity entity : ENTITY_LIST_OUTLINE_0) {
                                renderManager.func_188388_a(entity, partialTicks, false);
                            }
                            renderManager.func_178632_c(false);
                            RenderHelper.func_74519_b();
                            GlStateManager.func_179132_a((boolean)false);
                            entityOutlineShader.func_148018_a(partialTicks);
                            GlStateManager.func_179145_e();
                            GlStateManager.func_179132_a((boolean)true);
                            GlStateManager.func_179127_m();
                            GlStateManager.func_179147_l();
                            GlStateManager.func_179142_g();
                            GlStateManager.func_179143_c((int)515);
                            GlStateManager.func_179126_j();
                            GlStateManager.func_179141_d();
                        }
                        mc.func_147110_a().func_147610_a(false);
                    }
                } else if (pass == 1) {
                    if (!ENTITY_LIST_NORMAL_1.isEmpty()) {
                        for (Entity entity : ENTITY_LIST_NORMAL_1) {
                            FIELD_RENDERED_ENTITY.set(mc.field_71438_f, entity);
                            if (shadersEnabled) {
                                METHOD_NEXT_ENTITY.invoke(null, entity);
                            }
                            renderManager.func_188388_a(entity, partialTicks, false);
                            FIELD_RENDERED_ENTITY.set(mc.field_71438_f, null);
                        }
                    }
                    if (!ENTITY_LIST_MULTIPASS_1.isEmpty()) {
                        for (Entity entity : ENTITY_LIST_MULTIPASS_1) {
                            if (shadersEnabled) {
                                METHOD_NEXT_ENTITY.invoke(null, entity);
                            }
                            renderManager.func_188388_a(entity, partialTicks, false);
                        }
                    }
                    if (!ENTITY_LIST_OUTLINE_1.isEmpty() && !Optifine.isRenderEntityOutlines()) {
                        mc.field_71441_e.field_72984_F.func_76318_c("entityOutlines");
                        if (shadersEnabled) {
                            METHOD_BEGIN_ENTITIES_GLOWING.invoke(null, new Object[0]);
                        }
                        GlStateManager.func_179106_n();
                        GlStateManager.func_179097_i();
                        mc.field_71460_t.func_175072_h();
                        RenderHelper.func_74518_a();
                        renderManager.func_178632_c(true);
                        for (Entity entity : ENTITY_LIST_OUTLINE_1) {
                            if (shadersEnabled) {
                                METHOD_NEXT_ENTITY.invoke(null, entity);
                            }
                            renderManager.func_188388_a(entity, partialTicks, false);
                        }
                        renderManager.func_178632_c(false);
                        RenderHelper.func_74519_b();
                        mc.field_71460_t.func_180436_i();
                        GlStateManager.func_179126_j();
                        GlStateManager.func_179127_m();
                        if (shadersEnabled) {
                            METHOD_END_ENTITIES_GLOWING.invoke(null, new Object[0]);
                        }
                    }
                }
            }
            return EntityCullingConfig.enabled;
        }

        private static boolean isRenderEntityOutlines() {
            if (Boolean.TRUE.equals(METHOD_IS_FAST_RENDER.invoke(null, new Object[0]))) {
                return false;
            }
            if (Boolean.TRUE.equals(METHOD_IS_SHADERS.invoke(null, new Object[0]))) {
                return false;
            }
            if (Boolean.TRUE.equals(METHOD_IS_ANTIALIASING.invoke(null, new Object[0]))) {
                return false;
            }
            RenderGlobal renderGlobal = Minecraft.func_71410_x().field_71438_f;
            if (FIELD_ENTITY_OUTLINE_FRAMEBUFFER.get(renderGlobal) == null) {
                return false;
            }
            return FIELD_ENTITY_OUTLINE_SHADER.get(renderGlobal) != null;
        }

        public static boolean renderTileEntities() {
            int pass = MinecraftForgeClient.getRenderPass();
            if (EntityCullingConfig.enabled) {
                Minecraft mc = Minecraft.func_71410_x();
                float partialTicks = mc.func_184121_ak();
                boolean shadersEnabled = Boolean.TRUE.equals(METHOD_IS_SHADERS.invoke(null, new Object[0]));
                if (pass == 0) {
                    if (!TILE_ENTITY_LIST_NORMAL_0.isEmpty()) {
                        for (TileEntity tileEntity : TILE_ENTITY_LIST_NORMAL_0) {
                            if (shadersEnabled) {
                                METHOD_NEXT_BLOCK_ENTITY.invoke(null, tileEntity);
                            }
                            TileEntityRendererDispatcher.field_147556_a.func_180546_a(tileEntity, partialTicks, -1);
                        }
                    }
                    if (!TILE_ENTITY_LIST_SYNCHRONIZED_0.isEmpty()) {
                        for (TileEntity tileEntity : TILE_ENTITY_LIST_SYNCHRONIZED_0) {
                            if (shadersEnabled) {
                                METHOD_NEXT_BLOCK_ENTITY.invoke(null, tileEntity);
                            }
                            TileEntityRendererDispatcher.field_147556_a.func_180546_a(tileEntity, partialTicks, -1);
                        }
                    }
                } else if (pass == 1) {
                    if (!TILE_ENTITY_LIST_NORMAL_1.isEmpty()) {
                        for (TileEntity tileEntity : TILE_ENTITY_LIST_NORMAL_1) {
                            if (shadersEnabled) {
                                METHOD_NEXT_BLOCK_ENTITY.invoke(null, tileEntity);
                            }
                            TileEntityRendererDispatcher.field_147556_a.func_180546_a(tileEntity, partialTicks, -1);
                        }
                    }
                    if (!TILE_ENTITY_LIST_SYNCHRONIZED_1.isEmpty()) {
                        for (TileEntity tileEntity : TILE_ENTITY_LIST_SYNCHRONIZED_1) {
                            if (shadersEnabled) {
                                METHOD_NEXT_BLOCK_ENTITY.invoke(null, tileEntity);
                            }
                            TileEntityRendererDispatcher.field_147556_a.func_180546_a(tileEntity, partialTicks, -1);
                        }
                    }
                }
            }
            if (pass == 1) {
                Optifine.clearEntityLists();
            }
            return EntityCullingConfig.enabled;
        }
    }
}

