/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import meldexun.entityculling.EntityCullingConfig;
import meldexun.entityculling.ICullable;
import meldexun.entityculling.ITileEntityBBCache;
import meldexun.entityculling.RayTracingCache;
import meldexun.entityculling.RayTracingEngine;
import meldexun.entityculling.plugin.EntityCullingTransformer;
import meldexun.entityculling.reflection.ReflectionField;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.culling.ClippingHelperImpl;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.world.World;

public class CullingThread
extends Thread {
    private static final ReflectionField<RegistryNamespaced<ResourceLocation, Class<? extends TileEntity>>> FIELD_REGISTRY = new ReflectionField(TileEntity.class, "field_190562_f", "REGISTRY");
    private static final Set<Class<? extends Entity>> ENTITY_BLACKLIST = new HashSet<Class<? extends Entity>>();
    private static final Set<Class<? extends TileEntity>> TILE_ENTITY_BLACKLIST = new HashSet<Class<? extends TileEntity>>();
    private static final ReflectionField<ClippingHelperImpl> FIELD_INSTANCE = new ReflectionField(ClippingHelperImpl.class, "field_78563_e", "instance");
    private final RayTracingEngine.MutableRayTraceResult mutableRayTraceResult = new RayTracingEngine.MutableRayTraceResult();
    private final RayTracingCache cache = new RayTracingCache(EntityCullingConfig.cacheSize);
    private double sleepOverhead = 0.0;
    public long[] time = new long[10];
    private Frustum frustum;
    private double camX;
    private double camY;
    private double camZ;
    private int camBlockX;
    private int camBlockY;
    private int camBlockZ;
    private double x;
    private double y;
    private double z;

    public CullingThread() {
        this.setName("Culling Thread");
        this.setDaemon(true);
    }

    public static void updateBlacklists() {
        ENTITY_BLACKLIST.clear();
        TILE_ENTITY_BLACKLIST.clear();
        for (String s : EntityCullingConfig.skipHiddenEntityRenderingBlacklist) {
            Class entityClass = EntityList.func_192839_a((String)s);
            if (entityClass == null) continue;
            ENTITY_BLACKLIST.add(entityClass);
        }
        RegistryNamespaced<ResourceLocation, Class<? extends TileEntity>> tileEntityRegistry = FIELD_REGISTRY.get(null);
        for (String s : EntityCullingConfig.skipHiddenTileEntityRenderingBlacklist) {
            Class tileEntityClass = (Class)tileEntityRegistry.func_82594_a((Object)new ResourceLocation(s));
            if (tileEntityClass == null) continue;
            TILE_ENTITY_BLACKLIST.add(tileEntityClass);
        }
    }

    @Override
    public void run() {
        Minecraft mc = Minecraft.func_71410_x();
        while (true) {
            long t;
            block14: {
                t = System.nanoTime();
                try {
                    RayTracingEngine.resetCache();
                    this.cache.clearCache();
                    if (mc.field_71441_e == null || mc.func_175606_aa() == null) break block14;
                    Entity renderViewEntity = mc.func_175606_aa();
                    float partialTicks = mc.func_184121_ak();
                    this.x = renderViewEntity.field_70142_S + (renderViewEntity.field_70165_t - renderViewEntity.field_70142_S) * (double)partialTicks;
                    this.y = renderViewEntity.field_70137_T + (renderViewEntity.field_70163_u - renderViewEntity.field_70137_T) * (double)partialTicks;
                    this.z = renderViewEntity.field_70136_U + (renderViewEntity.field_70161_v - renderViewEntity.field_70136_U) * (double)partialTicks;
                    this.frustum = new Frustum((ClippingHelper)FIELD_INSTANCE.get(null));
                    this.frustum.func_78547_a(this.x, this.y, this.z);
                    if (EntityCullingConfig.debug) {
                        this.camX = this.x;
                        this.camY = this.y + (double)renderViewEntity.func_70047_e();
                        this.camZ = this.z;
                    } else {
                        Vec3d cameraPosition = ActiveRenderInfo.getCameraPosition();
                        this.camX = this.x + cameraPosition.field_72450_a;
                        this.camY = this.y + cameraPosition.field_72448_b;
                        this.camZ = this.z + cameraPosition.field_72449_c;
                    }
                    this.camBlockX = MathHelper.func_76128_c((double)this.camX);
                    this.camBlockY = MathHelper.func_76128_c((double)this.camY);
                    this.camBlockZ = MathHelper.func_76128_c((double)this.camZ);
                    Iterator entityIterator = mc.field_71441_e.field_72996_f.iterator();
                    while (entityIterator.hasNext()) {
                        try {
                            Entity entity = (Entity)entityIterator.next();
                            this.updateEntityCullingState(entity);
                        }
                        catch (Exception e) {
                            // empty catch block
                            break;
                        }
                    }
                    Iterator tileEntityIterator = mc.field_71441_e.field_147482_g.iterator();
                    while (tileEntityIterator.hasNext()) {
                        try {
                            TileEntity tileEntity = (TileEntity)tileEntityIterator.next();
                            this.updateTileEntityCullingState(tileEntity);
                        }
                        catch (Exception e) {
                            break;
                        }
                    }
                }
                catch (Exception renderViewEntity) {
                    // empty catch block
                }
            }
            t = System.nanoTime() - t;
            if (EntityCullingConfig.debug) {
                System.arraycopy(this.time, 0, this.time, 1, this.time.length - 1);
                this.time[0] = t;
            }
            double d = (double)t / 1000000.0 + this.sleepOverhead;
            this.sleepOverhead = d % 1.0;
            long sleepTime = 10L - (long)d;
            if (sleepTime <= 0L) continue;
            try {
                Thread.sleep(sleepTime);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    private void updateEntityCullingState(Entity entity) {
        ((ICullable)entity).setCulledFast(!this.checkEntityVisibility(entity));
        if (!EntityCullingConfig.betaFeatures) {
            ((ICullable)entity).setCulledSlow(true);
        }
        if (EntityCullingTransformer.IS_OPTIFINE_DETECTED) {
            ((ICullable)entity).setCulledShadowPass(!this.checkEntityShadowVisibility(entity));
        }
    }

    private void updateTileEntityCullingState(TileEntity tileEntity) {
        ((ICullable)tileEntity).setCulledFast(!this.checkTileEntityVisibility(tileEntity));
        if (!EntityCullingConfig.betaFeatures) {
            ((ICullable)tileEntity).setCulledSlow(true);
        }
        if (EntityCullingTransformer.IS_OPTIFINE_DETECTED) {
            ((ICullable)tileEntity).setCulledShadowPass(!this.checkTileEntityShadowVisibility(tileEntity));
        }
    }

    private boolean checkEntityVisibility(Entity entity) {
        double maxZ;
        double maxY;
        double maxX;
        double minZ;
        double minY;
        double minX;
        if (!EntityCullingConfig.enabled) {
            return true;
        }
        if (!EntityCullingConfig.skipHiddenEntityRendering) {
            return true;
        }
        if (!entity.func_184222_aU()) {
            return true;
        }
        if ((double)entity.field_70130_N > EntityCullingConfig.skipHiddenEntityRenderingSize || (double)entity.field_70131_O > EntityCullingConfig.skipHiddenEntityRenderingSize) {
            return true;
        }
        if (!ENTITY_BLACKLIST.isEmpty() && ENTITY_BLACKLIST.contains(entity.getClass())) {
            return true;
        }
        AxisAlignedBB aabb = entity.func_184177_bl();
        if (aabb.func_181656_b()) {
            minX = entity.field_70165_t - 2.0;
            minY = entity.field_70163_u - 2.0;
            minZ = entity.field_70161_v - 2.0;
            maxX = entity.field_70165_t + 2.0;
            maxY = entity.field_70163_u + 2.0;
            maxZ = entity.field_70161_v + 2.0;
        } else {
            minX = aabb.field_72340_a - 0.5;
            minY = aabb.field_72338_b - 0.5;
            minZ = aabb.field_72339_c - 0.5;
            maxX = aabb.field_72336_d + 0.5;
            maxY = aabb.field_72337_e + 0.5;
            maxZ = aabb.field_72334_f + 0.5;
        }
        if (!entity.func_145770_h(this.x, this.y, this.z)) {
            return true;
        }
        if (!this.frustum.func_78548_b(minX, minY, minZ, maxX, maxY, maxZ)) {
            return true;
        }
        if (this.checkVisibility(entity.field_70170_p, this.camX, this.camY, this.camZ, (minX + maxX) * 0.5, (minY + maxY) * 0.5, (minZ + maxZ) * 0.5, 1.0)) {
            return true;
        }
        return this.checkBoundingBoxVisibility(entity.field_70170_p, minX, minY, minZ, maxX, maxY, maxZ);
    }

    private boolean checkTileEntityVisibility(TileEntity tileEntity) {
        if (!EntityCullingConfig.enabled) {
            return true;
        }
        if (!EntityCullingConfig.skipHiddenTileEntityRendering) {
            return true;
        }
        AxisAlignedBB aabb = ((ITileEntityBBCache)tileEntity).getCachedAABB();
        if (aabb.field_72336_d - aabb.field_72340_a > EntityCullingConfig.skipHiddenTileEntityRenderingSize || aabb.field_72337_e - aabb.field_72338_b > EntityCullingConfig.skipHiddenTileEntityRenderingSize || aabb.field_72334_f - aabb.field_72339_c > EntityCullingConfig.skipHiddenTileEntityRenderingSize) {
            return true;
        }
        if (!TILE_ENTITY_BLACKLIST.isEmpty() && TILE_ENTITY_BLACKLIST.contains(tileEntity.getClass())) {
            return true;
        }
        double minX = aabb.field_72340_a;
        double minY = aabb.field_72338_b;
        double minZ = aabb.field_72339_c;
        double maxX = aabb.field_72336_d;
        double maxY = aabb.field_72337_e;
        double maxZ = aabb.field_72334_f;
        if (tileEntity.func_145835_a(this.x, this.y, this.z) >= tileEntity.func_145833_n()) {
            return true;
        }
        if (!this.frustum.func_78548_b(minX, minY, minZ, maxX, maxY, maxZ)) {
            return true;
        }
        if (this.checkVisibility(tileEntity.func_145831_w(), this.camX, this.camY, this.camZ, (minX + maxX) * 0.5, (minY + maxY) * 0.5, (minZ + maxZ) * 0.5, 1.0)) {
            return true;
        }
        return this.checkBoundingBoxVisibility(tileEntity.func_145831_w(), minX, minY, minZ, maxX, maxY, maxZ);
    }

    private boolean checkEntityShadowVisibility(Entity entity) {
        if (!EntityCullingConfig.enabled) {
            return true;
        }
        if (!EntityCullingConfig.optifineShaderOptions.entityShadowsEnabled) {
            return false;
        }
        if (!EntityCullingConfig.skipHiddenEntityRendering) {
            return true;
        }
        if (!EntityCullingConfig.optifineShaderOptions.entityShadowsCulling) {
            return true;
        }
        if (!((ICullable)entity).isCulledFast()) {
            return true;
        }
        if (!EntityCullingConfig.optifineShaderOptions.entityShadowsCullingLessAggressiveMode) {
            return false;
        }
        if (!entity.func_184222_aU()) {
            return true;
        }
        if ((double)entity.field_70130_N >= EntityCullingConfig.skipHiddenEntityRenderingSize || (double)entity.field_70131_O >= EntityCullingConfig.skipHiddenEntityRenderingSize) {
            return true;
        }
        if (!ENTITY_BLACKLIST.isEmpty() && ENTITY_BLACKLIST.contains(entity.getClass())) {
            return true;
        }
        return this.checkVisibility(entity.field_70170_p, this.camX, this.camY, this.camZ, entity.field_70165_t, entity.field_70163_u + (double)entity.field_70131_O * 0.5, entity.field_70161_v, EntityCullingConfig.optifineShaderOptions.entityShadowsCullingLessAggressiveModeDiff);
    }

    private boolean checkTileEntityShadowVisibility(TileEntity tileEntity) {
        if (!EntityCullingConfig.enabled) {
            return true;
        }
        if (!EntityCullingConfig.optifineShaderOptions.tileEntityShadowsEnabled) {
            return false;
        }
        if (!EntityCullingConfig.skipHiddenTileEntityRendering) {
            return true;
        }
        if (!EntityCullingConfig.optifineShaderOptions.tileEntityShadowsCulling) {
            return true;
        }
        if (!((ICullable)tileEntity).isCulledFast()) {
            return true;
        }
        if (!EntityCullingConfig.optifineShaderOptions.tileEntityShadowsCullingLessAggressiveMode) {
            return false;
        }
        AxisAlignedBB aabb = ((ITileEntityBBCache)tileEntity).getCachedAABB();
        if (aabb.field_72336_d - aabb.field_72340_a > EntityCullingConfig.skipHiddenTileEntityRenderingSize || aabb.field_72337_e - aabb.field_72338_b > EntityCullingConfig.skipHiddenTileEntityRenderingSize || aabb.field_72334_f - aabb.field_72339_c > EntityCullingConfig.skipHiddenTileEntityRenderingSize) {
            return true;
        }
        if (!TILE_ENTITY_BLACKLIST.isEmpty() && TILE_ENTITY_BLACKLIST.contains(tileEntity.getClass())) {
            return true;
        }
        BlockPos pos = tileEntity.func_174877_v();
        return this.checkVisibility(tileEntity.func_145831_w(), this.camX, this.camY, this.camZ, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, EntityCullingConfig.optifineShaderOptions.tileEntityShadowsCullingLessAggressiveModeDiff);
    }

    private boolean checkBoundingBoxVisibility(World world, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        block19: {
            int y;
            int z;
            int x;
            int endZ;
            int endY;
            int endX;
            block18: {
                int y2;
                int z2;
                int y3;
                int x2;
                int startX = MathHelper.func_76128_c((double)minX);
                int startY = MathHelper.func_76128_c((double)minY);
                int startZ = MathHelper.func_76128_c((double)minZ);
                endX = MathHelper.func_76143_f((double)maxX);
                endY = MathHelper.func_76143_f((double)maxY);
                endZ = MathHelper.func_76143_f((double)maxZ);
                if (this.camX < (double)startX) {
                    x2 = startX;
                    for (y3 = startY; y3 <= endY; ++y3) {
                        for (z2 = startZ; z2 <= endZ; ++z2) {
                            if (!this.checkVisibilityCached(world, x2, y3, z2)) continue;
                            return true;
                        }
                    }
                } else if (this.camX > (double)endX) {
                    x2 = endX;
                    for (y3 = startY; y3 <= endY; ++y3) {
                        for (z2 = startZ; z2 <= endZ; ++z2) {
                            if (!this.checkVisibilityCached(world, x2, y3, z2)) continue;
                            return true;
                        }
                    }
                }
                if (this.camY < (double)startY) {
                    y2 = startY;
                    for (x = startX; x <= endX; ++x) {
                        for (z2 = startZ; z2 <= endZ; ++z2) {
                            if (!this.checkVisibilityCached(world, x, y2, z2)) continue;
                            return true;
                        }
                    }
                } else if (this.camY > (double)endY) {
                    y2 = endY;
                    for (x = startX; x <= endX; ++x) {
                        for (z2 = startZ; z2 <= endZ; ++z2) {
                            if (!this.checkVisibilityCached(world, x, y2, z2)) continue;
                            return true;
                        }
                    }
                }
                if (!(this.camZ < (double)startZ)) break block18;
                z = startZ;
                for (x = startX; x <= endX; ++x) {
                    for (y = startY; y <= endY; ++y) {
                        if (!this.checkVisibilityCached(world, x, y, z)) continue;
                        return true;
                    }
                }
                break block19;
            }
            if (!(this.camZ > (double)endZ)) break block19;
            z = endZ;
            for (x = startX; x <= endX; ++x) {
                for (y = startY; y <= endY; ++y) {
                    if (!this.checkVisibilityCached(world, x, y, z)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean checkVisibilityCached(World world, int endX, int endY, int endZ) {
        int cachedValue;
        int cacheX = endX - this.camBlockX + this.cache.radiusBlocks;
        int cacheY = endY - this.camBlockY + this.cache.radiusBlocks;
        int cacheZ = endZ - this.camBlockZ + this.cache.radiusBlocks;
        RayTracingCache.RayTracingCacheChunk chunk = this.cache.getChunk(cacheX >> 4, cacheY >> 4, cacheZ >> 4);
        if (chunk != null && (cachedValue = chunk.getCachedValue(cacheX & 0xF, cacheY & 0xF, cacheZ & 0xF)) > 0) {
            return cachedValue >> 1 == 1;
        }
        boolean flag = this.checkVisibility(world, this.camX, this.camY, this.camZ, endX, endY, endZ, 1.0);
        if (chunk != null) {
            chunk.setCachedValue(cacheX & 0xF, cacheY & 0xF, cacheZ & 0xF, flag ? 2 : 1);
        }
        return flag;
    }

    private boolean checkVisibility(World world, double startX, double startY, double startZ, double endX, double endY, double endZ, double maxDiff) {
        RayTracingEngine.MutableRayTraceResult rayTraceResult = RayTracingEngine.rayTraceBlocks(world, startX, startY, startZ, endX, endY, endZ, true, maxDiff, this.mutableRayTraceResult);
        return rayTraceResult == null;
    }
}

