/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling;

import net.minecraftforge.common.config.Config;

@Config(modid="entity_culling")
public class EntityCullingConfig {
    @Config.Ignore
    public static boolean betaFeatures = false;
    @Config.RequiresMcRestart
    @Config.Comment(value={"Requires restart. Ram usage (in MB) = (x * 16 * 2) ^ 3 / 4"})
    public static int cacheSize = 12;
    public static boolean debug = false;
    @Config.Comment(value={"Disable all changes from this mod."})
    public static boolean enabled = true;
    @Config.Comment(value={"Skip rendering of entities that are not visible (hidden behind blocks). Bosses will be rendered normally. This might cause issues where an entity is partly behind a block and thus does not get rendered but it's usually not really noticable."})
    public static boolean skipHiddenEntityRendering = true;
    @Config.Comment(value={"Entities with a width or height greater than this value will always get rendered."})
    @Config.RangeDouble(min=0.0, max=256.0)
    public static double skipHiddenEntityRenderingSize = 3.0;
    @Config.Comment(value={"Tile entities which will always be rendered. (Format: 'modid:entity_name')"})
    public static String[] skipHiddenEntityRenderingBlacklist = new String[0];
    @Config.Comment(value={"Skip rendering of entities that are not visible (hidden behind blocks). This might cause issues where a tile entity is partly behind a block and thus does not get rendered but it's usually not really noticable."})
    public static boolean skipHiddenTileEntityRendering = true;
    @Config.Comment(value={"Tile entities with a width or height greater than this value will always get rendered."})
    @Config.RangeDouble(min=0.0, max=256.0)
    public static double skipHiddenTileEntityRenderingSize = 3.0;
    @Config.Comment(value={"Tile entities which will always be rendered. (Format: 'modid:tile_entity_name')"})
    public static String[] skipHiddenTileEntityRenderingBlacklist = new String[0];
    public static OptifineShaderOptions optifineShaderOptions = new OptifineShaderOptions();

    private EntityCullingConfig() {
    }

    public static class OptifineShaderOptions {
        public boolean entityShadowsCulling = true;
        public boolean entityShadowsCullingLessAggressiveMode = true;
        @Config.RangeDouble(min=0.0, max=64.0)
        public double entityShadowsCullingLessAggressiveModeDiff = 4.0;
        public boolean entityShadowsEnabled = true;
        public boolean entityShadowsDistanceLimited = true;
        @Config.RangeDouble(min=0.0, max=64.0)
        public double entityShadowsMaxDistance = 4.0;
        public boolean terrainShadowsEnabled = true;
        public boolean terrainShadowsDistanceLimited = true;
        @Config.RangeDouble(min=0.0, max=64.0)
        public double terrainShadowsMaxHorizontalDistance = 8.0;
        @Config.RangeDouble(min=0.0, max=64.0)
        public double terrainShadowsMaxVerticalDistance = 4.0;
        public boolean tileEntityShadowsCulling = true;
        public boolean tileEntityShadowsCullingLessAggressiveMode = true;
        @Config.RangeDouble(min=0.0, max=64.0)
        public double tileEntityShadowsCullingLessAggressiveModeDiff = 4.0;
        public boolean tileEntityShadowsEnabled = true;
        public boolean tileEntityShadowsDistanceLimited = true;
        @Config.RangeDouble(min=0.0, max=64.0)
        public double tileEntityShadowsMaxDistance = 4.0;
    }
}

