/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import meldexun.entityculling.EntityCullingConfig;
import meldexun.entityculling.ICullable;
import meldexun.entityculling.integration.CubicChunks;
import meldexun.entityculling.plugin.EntityCullingRenderer;
import meldexun.entityculling.reflection.ReflectionField;
import meldexun.entityculling.reflection.ReflectionMethod;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderUtil;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.common.Loader;

public class EntityCullingRendererOptifine
extends EntityCullingRenderer {
    protected static final ReflectionField<Set<TileEntity>> FIELD_SET_TILE_ENTITIES = new ReflectionField(RenderGlobal.class, "field_181024_n", "setTileEntities");
    protected static final ReflectionField<Boolean> FIELD_IS_SHADOW_PASS = new ReflectionField("net.optifine.shaders.Shaders", "isShadowPass", "isShadowPass");
    protected static final ReflectionMethod<Boolean> METHOD_IS_SHADERS = new ReflectionMethod("Config", "isShaders", "isShaders", new Class[0]);
    protected static final ReflectionField<Entity> FIELD_RENDERED_ENTITY = new ReflectionField(RenderGlobal.class, "renderedEntity", "renderedEntity");
    protected static final ReflectionMethod<?> METHOD_NEXT_ENTITY = new ReflectionMethod("net.optifine.shaders.Shaders", "nextEntity", "nextEntity", Entity.class);
    protected static final ReflectionMethod<Boolean> METHOD_IS_FAST_RENDER = new ReflectionMethod("Config", "isFastRender", "isFastRender", new Class[0]);
    protected static final ReflectionMethod<Boolean> METHOD_IS_ANTIALIASING = new ReflectionMethod("Config", "isAntialiasing", "isAntialiasing", new Class[0]);
    protected static final ReflectionMethod<?> METHOD_NEXT_BLOCK_ENTITY = new ReflectionMethod("net.optifine.shaders.Shaders", "nextBlockEntity", "nextBlockEntity", TileEntity.class);
    protected static final ReflectionMethod<?> METHOD_BEGIN_ENTITIES_GLOWING = new ReflectionMethod("net.optifine.shaders.Shaders", "beginEntitiesGlowing", "beginEntitiesGlowing", new Class[0]);
    protected static final ReflectionMethod<?> METHOD_END_ENTITIES_GLOWING = new ReflectionMethod("net.optifine.shaders.Shaders", "endEntitiesGlowing", "endEntitiesGlowing", new Class[0]);
    protected List<Entity> entityListOutlinePass1;

    @Override
    protected void preRenderEntities() {
        super.preRenderEntities();
        this.entityListOutlinePass1 = new ArrayList<Entity>();
    }

    @Override
    protected void postRenderEntities() {
        super.postRenderEntities();
        this.entityListOutlinePass1 = null;
    }

    @Override
    public boolean renderEntities() {
        if (!EntityCullingConfig.enabled) {
            return false;
        }
        int pass = MinecraftForgeClient.getRenderPass();
        boolean isShadowPass = Boolean.TRUE.equals(FIELD_IS_SHADOW_PASS.get(null));
        boolean shadersEnabled = Boolean.TRUE.equals(METHOD_IS_SHADERS.invoke(null, new Object[0]));
        if (isShadowPass && !EntityCullingConfig.optifineShaderOptions.entityShadowsEnabled) {
            if (!this.renderingPrepared) {
                this.preRenderEntities();
            }
            return true;
        }
        if (!this.renderingPrepared) {
            this.preRenderEntities();
            if (!isShadowPass) {
                this.updateEntityCullingState();
            }
        }
        RenderManager renderManager = this.mc.func_175598_ae();
        if (pass == 0) {
            boolean isThirdPersonView = this.mc.field_71474_y.field_74320_O != 0;
            boolean isSleeping = this.renderViewEntity instanceof EntityLivingBase && ((EntityLivingBase)this.renderViewEntity).func_70608_bn();
            boolean firstPersonAndNotSleeping = !isThirdPersonView && !isSleeping;
            boolean spectatorAndOutlinesEnabled = this.mc.field_71439_g.func_175149_v() && this.mc.field_71474_y.field_178883_an.func_151470_d();
            int entitiesRendered = 0;
            ArrayList<Entity> multipassEntityList = new ArrayList<Entity>();
            ArrayList<Entity> outlineEntityList = new ArrayList<Entity>();
            for (RenderChunk renderChunk : RenderUtil.Optifine.getRenderChunksEntities()) {
                BlockPos chunkPos = renderChunk.func_178568_j();
                Chunk chunk = this.mc.field_71441_e.func_175726_f(chunkPos);
                ClassInheritanceMultiMap entityMap = !Loader.isModLoaded((String)"cubicchunks") ? chunk.func_177429_s()[chunkPos.func_177956_o() >> 4] : CubicChunks.getEntityList((World)this.mc.field_71441_e, renderChunk.func_178568_j());
                for (Entity entity : entityMap) {
                    Render render;
                    if (!entity.shouldRenderInPass(0) && !entity.shouldRenderInPass(1) || (render = renderManager.func_78713_a(entity)) == null || !render.func_177071_a(entity, (ICamera)this.frustum, this.x, this.y, this.z) && !entity.func_184215_y((Entity)this.mc.field_71439_g) || entity == this.renderViewEntity && firstPersonAndNotSleeping && !isShadowPass || isShadowPass && (((ICullable)entity).isCulledShadowPass() || EntityCullingConfig.optifineShaderOptions.entityShadowsDistanceLimited && entity.func_70092_e(this.x, this.y, this.z) > EntityCullingConfig.optifineShaderOptions.entityShadowsMaxDistance * 16.0 * EntityCullingConfig.optifineShaderOptions.entityShadowsMaxDistance * 16.0)) continue;
                    boolean renderOutlines = entity.func_184202_aL() || spectatorAndOutlinesEnabled && entity instanceof EntityPlayer;
                    boolean entityWasRendered = false;
                    if (entity.shouldRenderInPass(0)) {
                        if (((ICullable)entity).isVisible() || isShadowPass) {
                            FIELD_RENDERED_ENTITY.set(this.mc.field_71438_f, entity);
                            if (shadersEnabled) {
                                METHOD_NEXT_ENTITY.invoke(null, entity);
                            }
                            renderManager.func_188388_a(entity, this.partialTicks, false);
                            FIELD_RENDERED_ENTITY.set(this.mc.field_71438_f, null);
                            if (render.func_188295_H_()) {
                                multipassEntityList.add(entity);
                            }
                            entityWasRendered = true;
                        }
                        if (renderOutlines) {
                            outlineEntityList.add(entity);
                            entityWasRendered = true;
                        }
                    }
                    if (entity.shouldRenderInPass(1)) {
                        if (((ICullable)entity).isVisible() || isShadowPass) {
                            this.entityListNormalPass1.add(entity);
                            if (render.func_188295_H_()) {
                                this.entityListMultipassPass1.add(entity);
                            }
                            entityWasRendered = true;
                        }
                        if (renderOutlines) {
                            this.entityListOutlinePass1.add(entity);
                        }
                    }
                    if (isShadowPass) continue;
                    if (entityWasRendered) {
                        ++entitiesRendered;
                        ++this.entitiesRendered;
                        continue;
                    }
                    ++this.entitiesOcclusionCulled;
                }
            }
            for (Entity entity : multipassEntityList) {
                if (shadersEnabled) {
                    METHOD_NEXT_ENTITY.invoke(null, entity);
                }
                renderManager.func_188389_a(entity, this.partialTicks);
            }
            if (this.isRenderEntityOutlines() && (!outlineEntityList.isEmpty() || this.entityOutlinesRendered)) {
                this.mc.field_71441_e.field_72984_F.func_76318_c("entityOutlines");
                this.entityOutlineFramebuffer.func_147614_f();
                boolean bl = this.entityOutlinesRendered = !outlineEntityList.isEmpty();
                if (!outlineEntityList.isEmpty()) {
                    GlStateManager.func_179143_c((int)519);
                    GlStateManager.func_179106_n();
                    this.entityOutlineFramebuffer.func_147610_a(false);
                    RenderHelper.func_74518_a();
                    renderManager.func_178632_c(true);
                    for (Entity entity : outlineEntityList) {
                        if (shadersEnabled) {
                            METHOD_NEXT_ENTITY.invoke(null, entity);
                        }
                        renderManager.func_188388_a(entity, this.partialTicks, false);
                    }
                    renderManager.func_178632_c(false);
                    RenderHelper.func_74519_b();
                    GlStateManager.func_179132_a((boolean)false);
                    this.entityOutlineShader.func_148018_a(this.partialTicks);
                    GlStateManager.func_179145_e();
                    GlStateManager.func_179132_a((boolean)true);
                    GlStateManager.func_179127_m();
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179142_g();
                    GlStateManager.func_179143_c((int)515);
                    GlStateManager.func_179126_j();
                    GlStateManager.func_179141_d();
                }
                this.mc.func_147110_a().func_147610_a(false);
            }
            FIELD_COUNT_ENTITIES_RENDERED.set(this.mc.field_71438_f, (Integer)FIELD_COUNT_ENTITIES_RENDERED.get(this.mc.field_71438_f) + entitiesRendered);
        } else if (pass == 1) {
            for (Entity entity : this.entityListNormalPass1) {
                renderManager.func_188388_a(entity, this.partialTicks, false);
            }
            for (Entity entity : this.entityListMultipassPass1) {
                renderManager.func_188389_a(entity, this.partialTicks);
            }
            if (!(this.isRenderEntityOutlines() || this.entityListOutlinePass1.isEmpty() && !this.entityOutlinesRendered)) {
                this.mc.field_71441_e.field_72984_F.func_76318_c("entityOutlines");
                boolean bl = this.entityOutlinesRendered = !this.entityListOutlinePass1.isEmpty();
                if (!this.entityListOutlinePass1.isEmpty()) {
                    if (shadersEnabled) {
                        METHOD_BEGIN_ENTITIES_GLOWING.invoke(null, new Object[0]);
                    }
                    GlStateManager.func_179106_n();
                    GlStateManager.func_179097_i();
                    this.mc.field_71460_t.func_175072_h();
                    RenderHelper.func_74518_a();
                    renderManager.func_178632_c(true);
                    for (Entity entity : this.entityListOutlinePass1) {
                        if (shadersEnabled) {
                            METHOD_NEXT_ENTITY.invoke(null, entity);
                        }
                        renderManager.func_188388_a(entity, this.partialTicks, false);
                    }
                    renderManager.func_178632_c(false);
                    RenderHelper.func_74519_b();
                    this.mc.field_71460_t.func_180436_i();
                    GlStateManager.func_179126_j();
                    GlStateManager.func_179127_m();
                    if (shadersEnabled) {
                        METHOD_END_ENTITIES_GLOWING.invoke(null, new Object[0]);
                    }
                }
            }
        }
        return true;
    }

    @Override
    protected boolean isRenderEntityOutlines() {
        if (Boolean.TRUE.equals(METHOD_IS_FAST_RENDER.invoke(null, new Object[0]))) {
            return false;
        }
        if (Boolean.TRUE.equals(METHOD_IS_SHADERS.invoke(null, new Object[0]))) {
            return false;
        }
        if (Boolean.TRUE.equals(METHOD_IS_ANTIALIASING.invoke(null, new Object[0]))) {
            return false;
        }
        return super.isRenderEntityOutlines();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean renderTileEntities() {
        if (!EntityCullingConfig.enabled) {
            return false;
        }
        int pass = MinecraftForgeClient.getRenderPass();
        boolean isShadowPass = Boolean.TRUE.equals(FIELD_IS_SHADOW_PASS.get(null));
        boolean shadersEnabled = Boolean.TRUE.equals(METHOD_IS_SHADERS.invoke(null, new Object[0]));
        if (isShadowPass && !EntityCullingConfig.optifineShaderOptions.tileEntityShadowsEnabled) {
            if (pass == 1) {
                this.postRenderEntities();
            }
            return true;
        }
        if (pass == 0) {
            for (Object renderChunk : RenderUtil.Optifine.getRenderChunksTileEntities()) {
                BlockPos chunkPos = renderChunk.func_178568_j();
                Chunk chunk = this.mc.field_71441_e.func_175726_f(chunkPos);
                if (chunk.func_76621_g()) continue;
                for (TileEntity tileEntity : renderChunk.field_178590_b.func_178485_b()) {
                    if (!tileEntity.shouldRenderInPass(0) && !tileEntity.shouldRenderInPass(1) || TileEntityRendererDispatcher.field_147556_a.func_147547_b(tileEntity) == null || tileEntity.func_145835_a(this.x, this.y, this.z) > tileEntity.func_145833_n() || !this.frustum.func_78546_a(tileEntity.getRenderBoundingBox())) continue;
                    if (isShadowPass) {
                        if (((ICullable)tileEntity).isCulledShadowPass() || EntityCullingConfig.optifineShaderOptions.tileEntityShadowsDistanceLimited && tileEntity.func_145835_a(this.x, this.y, this.z) > EntityCullingConfig.optifineShaderOptions.tileEntityShadowsMaxDistance * 16.0 * EntityCullingConfig.optifineShaderOptions.tileEntityShadowsMaxDistance * 16.0) {
                            continue;
                        }
                    } else {
                        if (!((ICullable)tileEntity).isVisible()) {
                            ++this.tileEntitiesOcclusionCulled;
                            continue;
                        }
                        ++this.tileEntitiesRendered;
                    }
                    if (tileEntity.shouldRenderInPass(0)) {
                        if (shadersEnabled) {
                            METHOD_NEXT_BLOCK_ENTITY.invoke(null, tileEntity);
                        }
                        TileEntityRendererDispatcher.field_147556_a.func_180546_a(tileEntity, this.partialTicks, -1);
                    }
                    if (!tileEntity.shouldRenderInPass(1)) continue;
                    this.tileEntityListPass1.add(tileEntity);
                }
            }
            Set<TileEntity> setTileEntities = FIELD_SET_TILE_ENTITIES.get(this.mc.field_71438_f);
            if (!setTileEntities.isEmpty()) {
                Object renderChunk;
                renderChunk = setTileEntities;
                synchronized (renderChunk) {
                    for (TileEntity tileEntity : setTileEntities) {
                        if (!tileEntity.shouldRenderInPass(0) && !tileEntity.shouldRenderInPass(1) || TileEntityRendererDispatcher.field_147556_a.func_147547_b(tileEntity) == null || tileEntity.func_145835_a(this.x, this.y, this.z) > tileEntity.func_145833_n() || !this.frustum.func_78546_a(tileEntity.getRenderBoundingBox())) continue;
                        if (isShadowPass) {
                            if (((ICullable)tileEntity).isCulledShadowPass() || EntityCullingConfig.optifineShaderOptions.tileEntityShadowsDistanceLimited && tileEntity.func_145835_a(this.x, this.y, this.z) > EntityCullingConfig.optifineShaderOptions.tileEntityShadowsMaxDistance * 16.0 * EntityCullingConfig.optifineShaderOptions.tileEntityShadowsMaxDistance * 16.0) {
                                continue;
                            }
                        } else {
                            if (!((ICullable)tileEntity).isVisible()) {
                                ++this.tileEntitiesOcclusionCulled;
                                continue;
                            }
                            ++this.tileEntitiesRendered;
                        }
                        if (tileEntity.shouldRenderInPass(0)) {
                            if (shadersEnabled) {
                                METHOD_NEXT_BLOCK_ENTITY.invoke(null, tileEntity);
                            }
                            TileEntityRendererDispatcher.field_147556_a.func_180546_a(tileEntity, this.partialTicks, -1);
                        }
                        if (!tileEntity.shouldRenderInPass(1)) continue;
                        this.tileEntityListPass1.add(tileEntity);
                    }
                }
            }
        } else if (pass == 1) {
            for (TileEntity tileEntity : this.tileEntityListPass1) {
                if (shadersEnabled) {
                    METHOD_NEXT_BLOCK_ENTITY.invoke(null, tileEntity);
                }
                TileEntityRendererDispatcher.field_147556_a.func_180546_a(tileEntity, this.partialTicks, -1);
            }
        }
        if (pass == 1) {
            this.postRenderEntities();
        }
        return true;
    }
}

