/*
 * Decompiled with CFR 0.152.
 */
package erebus.blocks;

import erebus.ModItems;
import erebus.ModTabs;
import erebus.blocks.EnumWood;
import erebus.items.ItemMaterials;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class BlockBamboo
extends Block
implements IPlantable {
    protected static final AxisAlignedBB BAMBOO_AABB = new AxisAlignedBB(0.2, 0.0, 0.2, 0.8, 1.0, 0.8);
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)15);

    public BlockBamboo() {
        super(Material.field_151575_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
        this.func_149675_a(true);
        this.func_149647_a(ModTabs.PLANTS);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185848_a);
        Blocks.field_150480_ab.func_180686_a((Block)this, 5, 5);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BAMBOO_AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return BAMBOO_AABB;
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.func_176201_c(state) >= 8 && rand.nextInt(17) <= 3 ? null : ModItems.MATERIALS;
    }

    public int func_180651_a(IBlockState state) {
        return ItemMaterials.EnumErebusMaterialsType.BAMBOO.ordinal();
    }

    public ArrayList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (this.func_176201_c(state) == 0 && RANDOM.nextInt(this.func_176201_c(state) >= 8 ? 35 : 20) == 0) {
            ret.add(new ItemStack(Item.func_150898_a((Block)EnumWood.BAMBOO.getSapling())));
        }
        ret.add(new ItemStack(ModItems.MATERIALS, 1, ItemMaterials.EnumErebusMaterialsType.BAMBOO.ordinal()));
        return ret;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if ((world.func_180495_p(pos.func_177977_b()).func_177230_c() == EnumWood.BAMBOO.getLog() || this.checkForDrop(world, pos, state)) && world.func_175623_d(pos.func_177984_a())) {
            int growthHeight = 1;
            while (world.func_180495_p(pos.func_177979_c(growthHeight)).func_177230_c() == this) {
                ++growthHeight;
            }
            if (growthHeight < 8) {
                int stage = (Integer)state.func_177229_b((IProperty)AGE);
                if (stage == 15) {
                    world.func_175656_a(pos.func_177984_a(), this.func_176223_P());
                    world.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)), 4);
                } else {
                    world.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(stage + 1)), 4);
                }
            }
        }
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos.func_177977_b());
        Block block = state.func_177230_c();
        if (block.canSustainPlant(state, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this)) {
            return true;
        }
        if (block == this) {
            return true;
        }
        if (block != Blocks.field_150349_c && block != Blocks.field_150346_d) {
            return false;
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.checkForDrop(world, pos, state);
    }

    protected final boolean checkForDrop(World world, BlockPos pos, IBlockState state) {
        if (this.canBlockStay(world, pos)) {
            return true;
        }
        this.func_176226_b(world, pos, state, 0);
        world.func_175698_g(pos);
        return false;
    }

    public boolean canBlockStay(World world, BlockPos pos) {
        return this.func_176196_c(world, pos);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Plains;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return this.func_176223_P();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)EnumWood.BAMBOO.getLog()));
    }
}

