/*
 * Decompiled with CFR 0.152.
 */
package erebus.blocks;

import erebus.ModBlocks;
import erebus.ModTabs;
import erebus.tileentity.TileEntityFluidJar;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFluidJar
extends BlockContainer
implements ModBlocks.IHasCustomItem {
    public BlockFluidJar() {
        super(Material.field_151592_s);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149647_a(ModTabs.BLOCKS);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityFluidJar();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity tileentity;
        if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d && (tileentity = world.func_175625_s(pos)) instanceof TileEntityFluidJar) {
            NBTTagCompound nbt = new NBTTagCompound();
            tileentity.func_189515_b(nbt);
            ItemStack stack = new ItemStack(Item.func_150898_a((Block)this), 1, 0);
            if (((TileEntityFluidJar)tileentity).tank.getFluidAmount() > 0) {
                stack.func_77982_d(nbt);
            }
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
            world.func_175713_t(pos);
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileentity;
        super.func_180633_a(world, pos, state, placer, stack);
        if (!world.field_72995_K && stack.func_77942_o() && (tileentity = world.func_175625_s(pos)) instanceof TileEntityFluidJar && !stack.func_77978_p().func_74764_b("Empty")) {
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p());
            ((TileEntityFluidJar)tileentity).tank.fillInternal(fluid, true);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        IFluidHandler fluidHandler = this.getFluidHandler((IBlockAccess)world, pos);
        if (fluidHandler != null) {
            FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (World)world, (BlockPos)pos, (EnumFacing)side);
            return FluidUtil.getFluidHandler((ItemStack)player.func_184586_b(hand)) != null;
        }
        return false;
    }

    @Nullable
    private IFluidHandler getFluidHandler(IBlockAccess world, BlockPos pos) {
        TileEntityFluidJar tileentity = (TileEntityFluidJar)world.func_175625_s(pos);
        return (IFluidHandler)tileentity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
    }

    @Override
    public ItemBlock getItemBlock() {
        ItemBlock TANK_ITEM = new ItemBlock((Block)this){

            @SideOnly(value=Side.CLIENT)
            public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flag) {
                if (stack.func_77942_o() && !stack.func_77978_p().func_74764_b("Empty")) {
                    FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p());
                    if (fluid != null) {
                        list.add(TextFormatting.GREEN + "Contains: " + fluid.getFluid().getLocalizedName(fluid));
                        list.add(TextFormatting.BLUE + "" + fluid.amount + "Mb/32000Mb");
                    }
                } else {
                    list.add(TextFormatting.RED + "It's Empty!");
                }
            }
        };
        return TANK_ITEM;
    }
}

