/*
 * Decompiled with CFR 0.152.
 */
package erebus.blocks;

import erebus.ModBlocks;
import erebus.ModItems;
import erebus.ModTabs;
import erebus.blocks.BlockUmberstone;
import erebus.blocks.ErebusPortal;
import erebus.tileentity.TileEntityGaeanKeystone;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockGaeanKeystone
extends Block
implements ITileEntityProvider {
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
    static int LEAF_SEARCH = 8;
    static int MAX_PORTAL_SIZE = 81;
    static final byte F = 1;
    static final byte L = 2;
    static final byte END = -1;
    static final byte[] portalFrame = new byte[]{0, 1, 1, 1, 0, -1, 1, 2, 2, 2, 1, -1, 1, 2, 2, 2, 1, -1, 1, 2, 2, 2, 1, -1, 0, 1, 1, 1, 0, -1};

    public BlockGaeanKeystone() {
        super(Material.field_151576_e);
        this.func_149711_c(3.0f);
        this.func_149647_a(ModTabs.BLOCKS);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public static boolean isGemActive(int metadata) {
        return metadata > 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ACTIVE});
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        switch (meta) {
            case 0: {
                state = state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false));
                break;
            }
            case 1: {
                state = state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(true));
                break;
            }
            default: {
                state = state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false));
            }
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        if (((Boolean)state.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
            meta |= 1;
        }
        return meta;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        ItemStack stack = player.func_184614_ca();
        if (((Boolean)state.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
            if (!stack.func_190926_b()) {
                return true;
            }
            this.breakPortal(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
            player.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(ModItems.PORTAL_ACTIVATOR));
            return true;
        }
        if (stack.func_190926_b() || stack.func_77973_b() != ModItems.PORTAL_ACTIVATOR) {
            return false;
        }
        if (this.makePortal(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) {
            world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
            player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
        } else {
            world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
        }
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityGaeanKeystone();
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        if (((Boolean)state.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
            this.breakPortal(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, new ItemStack(ModItems.PORTAL_ACTIVATOR)));
        }
    }

    void breakPortal(World w, int x, int y, int z) {
        PCoord here = new PCoord(w, x, y, z);
        PCoord min = here.add(-LEAF_SEARCH, -LEAF_SEARCH, -LEAF_SEARCH);
        PCoord max = here.add(LEAF_SEARCH, LEAF_SEARCH, LEAF_SEARCH);
        PCoord.iterateCube(min, max, new PCoord.ICoordFunc(){

            @Override
            public boolean visit(PCoord at) {
                if (!at.is(ModBlocks.PORTAL)) {
                    return false;
                }
                HashSet<PCoord> found = new HashSet<PCoord>();
                ArrayList<PCoord> frontier = new ArrayList<PCoord>();
                frontier.add(at);
                while (!frontier.isEmpty()) {
                    PCoord f = (PCoord)frontier.remove(frontier.size() - 1);
                    found.add(f);
                    for (PCoord pc : f.neighbors()) {
                        if (found.contains(pc) || !pc.is(ModBlocks.PORTAL)) continue;
                        frontier.add(pc);
                    }
                }
                for (PCoord pc : found) {
                    pc.setBlockNoNotify(Blocks.field_150350_a.func_176223_P());
                }
                return true;
            }
        });
    }

    boolean makePortal(World w, int x, int y, int z) {
        PCoord keystone = new PCoord(w, x, y, z);
        final HashSet badLeaves = new HashSet();
        final HashSet contig = new HashSet();
        PCoord min = keystone.add(-LEAF_SEARCH, -LEAF_SEARCH, -LEAF_SEARCH);
        PCoord max = keystone.add(LEAF_SEARCH, LEAF_SEARCH, LEAF_SEARCH);
        PCoord.iterateCube(min, max, new PCoord.ICoordFunc(){

            @Override
            public boolean visit(PCoord at) {
                if (!at.isLeaf()) {
                    return false;
                }
                if (badLeaves.contains(at)) {
                    return false;
                }
                if (BlockGaeanKeystone.this.visitLeaves(at, contig, badLeaves) && contig.size() < MAX_PORTAL_SIZE) {
                    return true;
                }
                badLeaves.addAll(contig);
                contig.clear();
                return false;
            }
        });
        if (contig.isEmpty()) {
            return false;
        }
        for (PCoord at : contig) {
            at.setBlockNoNotify(ModBlocks.PORTAL.func_176223_P());
        }
        return true;
    }

    boolean visitLeaves(PCoord start, HashSet<PCoord> contig, HashSet<PCoord> invalidLeaves) {
        ArrayList<PCoord> frontier = new ArrayList<PCoord>();
        frontier.add(start);
        while (!frontier.isEmpty()) {
            PCoord at = (PCoord)frontier.remove(frontier.size() - 1);
            for (PCoord n : at.neighbors()) {
                if (!n.isLeaf()) continue;
                if (invalidLeaves.contains(n)) {
                    return false;
                }
                if (!contig.add(n)) continue;
                if (!n.validLeafPortal()) {
                    invalidLeaves.addAll(frontier);
                    return false;
                }
                frontier.add(n);
            }
        }
        return true;
    }

    public void buildDestinationPortal(World w, int x, int y, int z) {
        PCoord keystone = new PCoord(w, x, y, z);
        while (keystone.isAir() && keystone.y > 0) {
            keystone = keystone.add(0, -1, 0);
        }
        keystone = keystone.add(0, 1, 0);
        int C = 5;
        int r = 2;
        PCoord floorMin = keystone.add(-r, -1, -r);
        PCoord floorMax = keystone.add(r, -1, r);
        PCoord.iterateCube(floorMin, floorMax, new PCoord.ICoordFunc(){

            @Override
            public boolean visit(PCoord at) {
                at.ensureFloored();
                int yMin = at.y + 1;
                int yMax = at.y + 5;
                for (int y = yMin; y < yMax; ++y) {
                    at.w.func_175698_g(new BlockPos(at.x, y, at.z));
                }
                return false;
            }
        });
        PCoord start = floorMin.add(0, 1, 0);
        int dx = 0;
        int dy = 0;
        int dz = 0;
        for (byte b : portalFrame) {
            if (b == -1) {
                ++dy;
                dx = 0;
                continue;
            }
            if (b == 1 || b == 2) {
                IBlockState block;
                int md = 0;
                if (b == 2) {
                    block = w.func_175659_aa() != EnumDifficulty.HARD ? Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)) : Blocks.field_150350_a.func_176223_P();
                } else {
                    md = w.field_73012_v.nextBoolean() ? 5 : 6;
                    block = ModBlocks.UMBERSTONE.func_176223_P().func_177226_a(BlockUmberstone.TYPE, (Comparable)((Object)BlockUmberstone.EnumType.values()[md]));
                }
                w.func_180501_a(new BlockPos(start.x + dx, start.y + dy, start.z + dz), block, 3);
            }
            ++dx;
        }
        keystone.setBlock(ModBlocks.GAEAN_KEYSTONE.func_176223_P());
        keystone.w.func_175625_s(new BlockPos(keystone.x, keystone.y, keystone.z));
    }

    static class PCoord {
        final World w;
        final int x;
        final int y;
        final int z;

        PCoord(World w, int x, int y, int z) {
            this.w = w;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        PCoord add(int dx, int dy, int dz) {
            return new PCoord(this.w, this.x + dx, this.y + dy, this.z + dz);
        }

        boolean is(Block b) {
            return this.w.func_180495_p(new BlockPos(this.x, this.y, this.z)).func_177230_c() == b;
        }

        static void iterateCube(PCoord min, PCoord max, ICoordFunc func) {
            for (int x = min.x; x <= max.x; ++x) {
                for (int z = min.z; z <= max.z; ++z) {
                    for (int y = min.y; y <= max.y; ++y) {
                        if (!func.visit(new PCoord(min.w, x, y, z))) continue;
                        return;
                    }
                }
            }
        }

        public void setAir() {
            this.w.func_175698_g(new BlockPos(this.x, this.y, this.z));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PCoord)) {
                return false;
            }
            PCoord pCoord = (PCoord)o;
            if (this.x != pCoord.x) {
                return false;
            }
            if (this.y != pCoord.y) {
                return false;
            }
            if (this.z != pCoord.z) {
                return false;
            }
            return !(this.w == null ? pCoord.w != null : !this.w.equals(pCoord.w));
        }

        public int hashCode() {
            int result = this.x;
            result = 31 * result + this.y;
            result = 31 * result + this.z;
            return result;
        }

        boolean isLeaf() {
            return this.w.func_180495_p(new BlockPos(this.x, this.y, this.z)).func_177230_c() instanceof BlockLeaves;
        }

        boolean validLeafPortal() {
            return ErebusPortal.obeysPortalRule(this.w, this.x, this.y, this.z, false);
        }

        PCoord[] neighbors() {
            PCoord[] ret = new PCoord[6];
            int i = 0;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                ret[i++] = this.add(dir.func_82601_c(), dir.func_96559_d(), dir.func_82599_e());
            }
            return ret;
        }

        public void ensureFloored() {
            Block b = this.w.func_180495_p(new BlockPos(this.x, this.y, this.z)).func_177230_c();
            if (b.func_176200_f((IBlockAccess)this.w, new BlockPos(this.x, this.y, this.z))) {
                this.setBlock(ModBlocks.UMBERSTONE.func_176223_P());
            }
        }

        public void setBlock(IBlockState iBlockState) {
            this.w.func_175656_a(new BlockPos(this.x, this.y, this.z), iBlockState);
        }

        public void setBlockNoNotify(IBlockState iBlockState) {
            this.w.func_180501_a(new BlockPos(this.x, this.y, this.z), iBlockState, 2);
        }

        public boolean isAir() {
            return this.w.func_175623_d(new BlockPos(this.x, this.y, this.z));
        }

        static interface ICoordFunc {
            public boolean visit(PCoord var1);
        }
    }
}

