/*
 * Decompiled with CFR 0.152.
 */
package meldexun.ExtraSpells.spells;

import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WandHelper;
import java.util.Random;
import meldexun.ExtraSpells.ExtraSpells;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public abstract class AbstractSpellChargable
extends Spell {
    protected int tickLimit;
    protected int tickRate;
    protected float loopVolumeStart = 0.0f;
    protected float loopVolumeEnd = 1.0f;
    protected float loopPitchStart = 0.5f;
    protected float loopPitchEnd = 1.0f;
    protected int particleCount = 2;
    protected float r = 1.0f;
    protected float g = 1.0f;
    protected float b = 1.0f;
    protected final Random rand = new Random();

    public AbstractSpellChargable(String modID, String name, EnumAction action, int tickLimit, int tickRate) {
        super(modID, name, action, true);
        this.tickLimit = tickLimit;
        this.tickRate = tickRate;
    }

    protected SoundEvent[] createSounds() {
        return this.createContinuousSpellSounds();
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (ticksInUse == 0) {
            this.startTick(world, (EntityLivingBase)caster, hand, ticksInUse, modifiers);
            if (world.field_72995_K) {
                ExtraSpells.proxy.startLoopSound(this, (EntityLivingBase)caster);
            }
        } else if (ticksInUse >= this.tickLimit) {
            caster.func_184597_cx();
        }
        if (ticksInUse % this.tickRate == 0) {
            this.tick(world, (EntityLivingBase)caster, hand, ticksInUse, modifiers);
            if (world.field_72995_K) {
                this.spawnParticles(world, (EntityLivingBase)caster, modifiers);
            }
            return true;
        }
        return false;
    }

    public void finishCasting(World world, EntityLivingBase caster, double x, double y, double z, EnumFacing direction, int duration, SpellModifiers modifiers) {
        if (duration >= this.tickLimit) {
            this.finishTick(world, caster, caster.func_184600_cs(), duration, modifiers);
            world.func_184148_a(null, caster.field_70165_t, caster.field_70163_u + (double)caster.func_70047_e(), caster.field_70161_v, this.sounds[2], WizardrySounds.SPELLS, this.volume, this.getRandomPitch());
        }
    }

    public void startTick(World world, EntityLivingBase caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
    }

    public void tick(World world, EntityLivingBase caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
    }

    public void finishTick(World world, EntityLivingBase caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
    }

    protected void spawnParticles(World world, EntityLivingBase caster, SpellModifiers modifiers) {
        for (int i = 0; i < this.particleCount; ++i) {
            Vec3d posVec = this.getWandVec(caster);
            Vec3d posVecOffset = new Vec3d(this.rand.nextDouble() - 0.5, this.rand.nextDouble() - 0.5, this.rand.nextDouble() - 0.5);
            Vec3d velVec = new Vec3d(posVecOffset.field_72450_a * 0.025, posVecOffset.field_72448_b * 0.025, posVecOffset.field_72449_c * 0.025);
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(posVec.func_178788_d(posVecOffset)).vel(velVec).clr(this.r, this.g, this.b).spawn(world);
        }
    }

    protected Vec3d getWandVec(EntityLivingBase caster) {
        Vec3d lookVec = caster.func_70040_Z();
        double yaw = (double)caster.field_70177_z + 90.0;
        double sin = Math.sin(Math.toRadians(yaw));
        double cos = Math.cos(Math.toRadians(yaw));
        return new Vec3d(caster.field_70165_t + lookVec.field_72450_a - 0.25 * sin, caster.field_70163_u + (double)(0.5f * caster.field_70131_O) + lookVec.field_72448_b, caster.field_70161_v + lookVec.field_72449_c + 0.25 * cos);
    }

    public int getTickLimit() {
        return this.tickLimit;
    }

    public int getTickRate() {
        return this.tickRate;
    }

    public float getLoopVolumeStart() {
        return this.loopVolumeStart;
    }

    public float getLoopVolumeEnd() {
        return this.loopVolumeEnd;
    }

    public float getLoopPitchStart() {
        return this.loopPitchStart;
    }

    public float getLoopPitchEnd() {
        return this.loopPitchEnd;
    }

    public float getRandomPitch() {
        return this.pitch - this.pitchVariation + 2.0f * (float)Math.random() * this.pitchVariation;
    }

    @Mod.EventBusSubscriber
    private static class Test {
        private Test() {
        }

        @SubscribeEvent
        public static void test(LivingEntityUseItemEvent.Stop event) {
            Spell spell;
            ItemStack stack;
            if (!event.getEntity().field_70170_p.field_72995_K && (stack = event.getItem()).func_77973_b() instanceof ItemWand && (spell = WandHelper.getCurrentSpell((ItemStack)stack)) instanceof AbstractSpellChargable && event.getDuration() < ((AbstractSpellChargable)spell).getTickLimit()) {
                WandHelper.setCurrentCooldown((ItemStack)stack, (int)((int)((double)spell.getCooldown() * 0.5)));
            }
        }
    }
}

