/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguides.gui.components;

import com.feed_the_beast.ftblib.lib.gui.GuiBase;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.MismatchingParentPanelException;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.mods.ftbguides.FTBGuides;
import com.feed_the_beast.mods.ftbguides.FTBGuidesLocalConfig;
import com.feed_the_beast.mods.ftbguides.gui.GuiGuide;
import com.feed_the_beast.mods.ftbguides.gui.components.CombinedGuideComponent;
import com.feed_the_beast.mods.ftbguides.gui.components.GuideComponent;
import com.feed_the_beast.mods.ftbguides.gui.components.IGuideComponentWidget;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public abstract class ComponentPanel
extends Panel
implements IGuideComponentWidget {
    public int maxWidth;
    public int totalWidth;
    public int totalHeight;

    public ComponentPanel(Panel panel) {
        super(panel);
        this.setUnicode(FTBGuidesLocalConfig.general.use_unicode_font);
    }

    public abstract List<GuideComponent> getComponents();

    public void refreshWidgets() {
        int x = 0;
        int y = 1;
        int h = 0;
        int w = 0;
        this.totalWidth = 0;
        this.totalHeight = 0;
        this.widgets.clear();
        Theme theme = this.getGui().getTheme();
        theme.pushFontUnicode(FTBGuidesLocalConfig.general.use_unicode_font);
        this.addWidgets();
        try {
            List<GuideComponent> components = this.getComponents();
            if (components.size() == 1) {
                Widget widget = (Widget)components.get(0).createWidget(this);
                if (widget instanceof Panel) {
                    ((Panel)widget).refreshWidgets();
                }
                this.totalWidth = widget.width;
                this.totalHeight = widget.height;
                this.add(widget);
            } else {
                for (GuideComponent component : components) {
                    if (component.isEmpty()) continue;
                    Widget widget = (Widget)component.createWidget(this);
                    if (widget instanceof Panel) {
                        ((Panel)widget).refreshWidgets();
                    }
                    if (x + widget.width > this.maxWidth || !component.isInline()) {
                        this.totalWidth = widget.width > this.maxWidth ? Math.max(this.totalWidth, widget.width) : Math.max(this.totalWidth, x);
                        x = 0;
                        y += h;
                        h = 0;
                    }
                    widget.posX = x;
                    widget.posY = y;
                    w = Math.max(w, x += widget.width);
                    h = Math.max(h, widget.height);
                    this.add(widget);
                }
                this.totalWidth = Math.max(this.totalWidth, x);
                this.totalHeight = y += h;
            }
        }
        catch (MismatchingParentPanelException ex) {
            FTBGuides.LOGGER.error(ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.alignWidgets();
        theme.popFontUnicode();
    }

    public void addWidgets() {
        this.maxWidth = Integer.MAX_VALUE;
    }

    public void alignWidgets() {
        this.setWidth(this.totalWidth);
        this.setHeight(this.totalHeight);
    }

    public void drawOffsetBackground(Theme theme, int x, int y, int w, int h) {
        if (!Theme.renderDebugBoxes) {
            return;
        }
        this.setOffset(false);
        boolean mouseOver = this.isMouseOver();
        this.setOffset(true);
        if (mouseOver) {
            GlStateManager.func_179090_x();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            Color4I color = ((GuiGuide)this.getGui()).page.lineColor.withAlpha(50);
            if (!(this.parent instanceof GuiBase)) {
                GuiHelper.addRectToBuffer((BufferBuilder)buffer, (int)x, (int)y, (int)w, (int)h, (Color4I)color);
            }
            for (Widget widget : this.widgets) {
                if (widget instanceof ComponentPanel || !widget.isMouseOver() || widget.parent instanceof CombinedGuideComponent.CombinedComponentPanel) continue;
                GuiHelper.addRectToBuffer((BufferBuilder)buffer, (int)widget.getX(), (int)widget.getY(), (int)widget.width, (int)widget.height, (Color4I)color);
            }
            tessellator.func_78381_a();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179098_w();
        }
    }
}

