/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguides.gui.components;

import com.feed_the_beast.ftblib.lib.client.IPixelBuffer;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.ImageIcon;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.mods.ftbguides.gui.components.ComponentPage;
import com.feed_the_beast.mods.ftbguides.gui.components.ComponentPanel;
import com.feed_the_beast.mods.ftbguides.gui.components.GuideComponent;
import com.feed_the_beast.mods.ftbguides.gui.components.IGuideComponentWidget;
import com.google.gson.JsonElement;
import java.util.List;
import javax.annotation.Nullable;

public class ImageGuideComponent
extends GuideComponent {
    public final ComponentPage page;
    public final Icon image;
    private int width;
    private int height;
    public String click = "";
    public String hover = "";

    public ImageGuideComponent(ComponentPage p, Icon i, int w, int h) {
        this.page = p;
        this.image = i;
        this.width = w;
        this.height = h;
    }

    public ImageGuideComponent(ComponentPage page, Icon i) {
        this(page, i, -1, -1);
    }

    @Override
    public String toString() {
        return this.image.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.image.isEmpty();
    }

    private void loadSizeFromImage() {
        if (this.width == -1 || this.height == -1) {
            IPixelBuffer img;
            int def;
            JsonElement defJson = this.page.page.getProperty("default_icon_size");
            int n = def = defJson.isJsonPrimitive() ? Math.max(1, defJson.getAsInt()) : 16;
            if (this.image.hasPixelBuffer() && (img = this.image.createPixelBuffer()) != null) {
                if (this.width == -1) {
                    this.width = img.getWidth();
                }
                if (this.height == -1) {
                    this.height = img.getHeight();
                }
            }
            if (this.width == -1) {
                this.width = def;
            }
            if (this.height == -1) {
                this.height = def;
            }
        }
    }

    public int getWidth() {
        this.loadSizeFromImage();
        return this.width;
    }

    public int getHeight() {
        this.loadSizeFromImage();
        return this.height;
    }

    @Override
    public IGuideComponentWidget createWidget(ComponentPanel parent) {
        return new ImgWidget(parent, this);
    }

    public static class ImgWidget
    extends Widget
    implements IGuideComponentWidget {
        private final ImageGuideComponent component;

        public ImgWidget(ComponentPanel parent, ImageGuideComponent c) {
            super((Panel)parent);
            this.component = c;
            if (this.component.image instanceof ImageIcon) {
                this.setWidth((int)((double)this.component.getWidth() / (double)this.getScreen().func_78325_e()));
                this.setHeight((int)((double)this.component.getHeight() / (double)this.getScreen().func_78325_e()));
            } else {
                this.setWidth(this.component.getWidth());
                this.setHeight(this.component.getHeight());
            }
            if (this.width > parent.maxWidth) {
                int w = Math.min(parent.maxWidth, this.width);
                double h = (double)this.height * ((double)w / (double)this.width);
                this.setWidth(w);
                this.setHeight(Math.max((int)h, 0));
            }
        }

        public void addMouseOverText(List<String> list) {
            if (!this.component.hover.isEmpty()) {
                list.add(this.component.hover);
            }
        }

        public boolean mousePressed(MouseButton button) {
            if (this.isMouseOver() && !this.component.click.isEmpty() && this.handleClick(this.component.click)) {
                GuiHelper.playClickSound();
                return true;
            }
            return false;
        }

        public void draw(Theme theme, int x, int y, int w, int h) {
            this.component.image.draw(x, y, w, h);
        }

        @Nullable
        public Object getIngredientUnderMouse() {
            return this.component.image.getIngredient();
        }
    }
}

