/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.money;

import com.feed_the_beast.ftblib.lib.util.NBTUtils;
import com.feed_the_beast.mods.money.FTBMoneyCommon;
import com.feed_the_beast.mods.money.command.CommandImportItemsFromChest;
import com.feed_the_beast.mods.money.command.CommandMoney;
import com.feed_the_beast.mods.money.command.CommandPay;
import com.feed_the_beast.mods.money.command.CommandSetMoney;
import com.feed_the_beast.mods.money.net.FTBMoneyNetHandler;
import com.feed_the_beast.mods.money.net.MessageUpdateMoney;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="ftbmoney", name="FTB Money", version="1.2.0.47", acceptableRemoteVersions="*", dependencies="required-after:ftblib@[5.4.7.2,);required-after:ftbquests", acceptedMinecraftVersions="[1.12.2]")
public class FTBMoney {
    public static final String MOD_ID = "ftbmoney";
    public static final String MOD_NAME = "FTB Money";
    public static final String VERSION = "1.2.0.47";
    public static final Logger LOGGER = LogManager.getLogger((String)"FTB Money");
    @SidedProxy(serverSide="com.feed_the_beast.mods.money.FTBMoneyCommon", clientSide="com.feed_the_beast.mods.money.FTBMoneyClient")
    public static FTBMoneyCommon PROXY;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        FTBMoneyNetHandler.init();
        PROXY.preInit();
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandMoney());
        event.registerServerCommand((ICommand)new CommandPay());
        event.registerServerCommand((ICommand)new CommandSetMoney());
        event.registerServerCommand((ICommand)new CommandImportItemsFromChest());
    }

    public static long getMoney(EntityPlayer player) {
        long money = NBTUtils.getPersistedData((EntityPlayer)player, (boolean)false).func_74763_f("ftb_money");
        if (money == 0L && (money = player.getEntityData().func_74763_f("ftb_money")) > 0L) {
            NBTUtils.getPersistedData((EntityPlayer)player, (boolean)true).func_74772_a("ftb_money", money);
            player.getEntityData().func_82580_o("ftb_money");
        }
        return money;
    }

    public static void setMoney(EntityPlayer player, long money) {
        if (money <= 0L) {
            NBTUtils.getPersistedData((EntityPlayer)player, (boolean)false).func_82580_o("ftb_money");
        } else {
            NBTUtils.getPersistedData((EntityPlayer)player, (boolean)true).func_74772_a("ftb_money", money);
        }
        if (!player.field_70170_p.field_72995_K) {
            new MessageUpdateMoney(money).sendTo((EntityPlayerMP)player);
        }
    }

    public static String moneyString(long money) {
        return String.format("\u0398 %,d", money);
    }

    public static ITextComponent moneyComponent(long money) {
        TextComponentString component = new TextComponentString(FTBMoney.moneyString(money));
        component.func_150256_b().func_150238_a(TextFormatting.GOLD);
        return component;
    }
}

