/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.configs;

import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.units.UnitId;
import java.util.HashMap;
import java.util.Map;

public class MultiConfigProperty {

    public static class StrArrayProperty<K>
    extends BaseProperty<K, String[]> {
        public static <K> StrArrayProperty<K> from(ForgeConfig config, String category, String name, String comment) {
            return StrArrayProperty.from(config, category, name, new String[0], comment);
        }

        public static <K> StrArrayProperty<K> from(ForgeConfig config, String category, String name, String[] defaultValue, String comment) {
            StrArrayProperty<K> property = new StrArrayProperty<K>(config, category, name, defaultValue, comment);
            property.defaultValue = property.getFrom(config, category, defaultValue);
            return property;
        }

        protected StrArrayProperty(ForgeConfig config, String category, String name, String[] defaultValue, String comment) {
            super(config, category, name, defaultValue, comment);
            this.defaultValue = this.getFrom(config, category, defaultValue);
        }

        @Override
        public String[] getFrom(ForgeConfig config, String category, String[] defaultValue) {
            return ForgeConfig.getStrArray(config, category, this.getName(), defaultValue, this.getComment());
        }
    }

    public static class UnitIdProperty<K>
    extends BaseProperty<K, UnitId> {
        public static <K> UnitIdProperty<K> from(ForgeConfig config, String category, String name, UnitId defaultValue, String comment) {
            UnitIdProperty<K> property = new UnitIdProperty<K>(config, category, name, defaultValue, comment);
            property.defaultValue = property.getFrom(config, category, defaultValue);
            return property;
        }

        protected UnitIdProperty(ForgeConfig config, String category, String name, UnitId defaultValue, String comment) {
            super(config, category, name, defaultValue, comment);
            this.defaultValue = this.getFrom(config, category, defaultValue);
        }

        @Override
        public UnitId getFrom(ForgeConfig config, String category, UnitId defaultValue) {
            return ForgeConfig.getUnitId(config, category, this.getName(), defaultValue, this.getComment());
        }
    }

    public static class StringProperty<K>
    extends BaseProperty<K, String> {
        public static <K> StringProperty<K> from(ForgeConfig config, String category, String name, String defaultValue, String comment) {
            StringProperty<K> property = new StringProperty<K>(config, category, name, defaultValue, comment);
            property.defaultValue = property.getFrom(config, category, defaultValue);
            return property;
        }

        protected StringProperty(ForgeConfig config, String category, String name, String defaultValue, String comment) {
            super(config, category, name, defaultValue, comment);
            this.defaultValue = this.getFrom(config, category, defaultValue);
        }

        @Override
        public String getFrom(ForgeConfig config, String category, String defaultValue) {
            return ForgeConfig.getStr(config, category, this.getName(), defaultValue, this.getComment());
        }
    }

    public static class IntProperty<K>
    extends BaseProperty<K, Integer> {
        private final IntBounds bounds;

        public static <K> IntProperty<K> from(ForgeConfig config, String category, String name, int defaultValue, IntBounds bounds, String comment) {
            IntProperty<K> property = new IntProperty<K>(config, category, name, defaultValue, bounds, comment);
            property.defaultValue = property.getFrom(config, category, defaultValue);
            return property;
        }

        protected IntProperty(ForgeConfig config, String category, String name, int defaultValue, IntBounds bounds, String comment) {
            super(config, category, name, defaultValue, comment);
            this.bounds = bounds;
            this.defaultValue = this.getFrom(config, category, defaultValue);
        }

        @Override
        public Integer getFrom(ForgeConfig config, String category, Integer defaultValue) {
            return ForgeConfig.getInt(config, category, this.getName(), defaultValue, this.bounds, this.getComment());
        }
    }

    public static class FloatProperty<K>
    extends BaseProperty<K, Float> {
        private final FloatBounds bounds;

        public static <K> FloatProperty<K> from(ForgeConfig config, String category, String name, float defaultValue, FloatBounds bounds, String comment) {
            FloatProperty<K> property = new FloatProperty<K>(config, category, name, defaultValue, bounds, comment);
            property.defaultValue = property.getFrom(config, category, Float.valueOf(defaultValue));
            return property;
        }

        protected FloatProperty(ForgeConfig config, String category, String name, float defaultValue, FloatBounds bounds, String comment) {
            super(config, category, name, Float.valueOf(defaultValue), comment);
            this.bounds = bounds;
        }

        @Override
        public Float getFrom(ForgeConfig config, String category, Float defaultValue) {
            return Float.valueOf(ForgeConfig.getFloat(config, category, this.getName(), defaultValue.floatValue(), this.bounds, this.getComment()));
        }
    }

    public static class BoolProperty<K>
    extends BaseProperty<K, Boolean> {
        public static <K> BoolProperty<K> from(ForgeConfig config, String category, String name, boolean defaultValue, String comment) {
            BoolProperty<K> property = new BoolProperty<K>(config, category, name, defaultValue, comment);
            property.defaultValue = property.getFrom(config, category, defaultValue);
            return property;
        }

        protected BoolProperty(ForgeConfig config, String category, String name, boolean defaultValue, String comment) {
            super(config, category, name, defaultValue, comment);
        }

        @Override
        public Boolean getFrom(ForgeConfig config, String category, Boolean defaultValue) {
            return ForgeConfig.getBool(config, category, this.getName(), defaultValue, this.getComment());
        }
    }

    public static abstract class BaseProperty<K, V> {
        protected final Map<K, V> values = new HashMap();
        private final String category;
        private final String name;
        private final String comment;
        protected V defaultValue;

        protected BaseProperty(ForgeConfig config, String category, String name, V defaultValue, String comment) {
            this.category = category;
            this.name = name;
            this.comment = comment;
            this.defaultValue = defaultValue;
        }

        public abstract V getFrom(ForgeConfig var1, String var2, V var3);

        public V get(K key) {
            return this.values.getOrDefault(key, this.getDefaultValue());
        }

        public void putValueFrom(ForgeConfig config, K key, boolean enabled) {
            V value = this.getFrom(config, this.getCategory(), this.getDefaultValue());
            if (enabled && !value.equals(this.getDefaultValue())) {
                this.values.put(key, value);
            }
        }

        public String getCategory() {
            return this.category;
        }

        public String getName() {
            return this.name;
        }

        public String getComment() {
            return this.comment;
        }

        public V getDefaultValue() {
            return this.defaultValue;
        }
    }
}

