/*
 * Decompiled with CFR 0.152.
 */
package pumpkinlauncher.common.entity;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pumpkinlauncher.client.particle.Particles;
import pumpkinlauncher.common.explosion.CustomExplosion;

@ParametersAreNonnullByDefault
public class EntityPumpkinProjectile
extends Entity
implements IProjectile {
    private static final DataParameter<Integer> BOUNCES_LEFT = EntityDataManager.func_187226_a(EntityPumpkinProjectile.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IS_FLAMING = EntityDataManager.func_187226_a(EntityPumpkinProjectile.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_SMOKING = EntityDataManager.func_187226_a(EntityPumpkinProjectile.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_ENDER_PEARL = EntityDataManager.func_187226_a(EntityPumpkinProjectile.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HAS_BONE_MEAL = EntityDataManager.func_187226_a(EntityPumpkinProjectile.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<NBTTagCompound> FIREWORK_NBT = EntityDataManager.func_187226_a(EntityPumpkinProjectile.class, (DataSerializer)DataSerializers.field_192734_n);
    private static final DataParameter<ItemStack> POTION_ITEM = EntityDataManager.func_187226_a(EntityPumpkinProjectile.class, (DataSerializer)DataSerializers.field_187196_f);
    public int rotation;
    @Nullable
    private EntityLivingBase shootingEntity;
    private int power = 2;
    private int ignoreTime;
    private int extraDamage;
    private int fireworkLifetime;
    private int fireworkLifetimeMax = -1;
    private boolean canDestroyBlocks = true;
    private boolean shouldHurtPlayer;
    private Entity ignoreEntity;
    private ItemStack arrowStack = ItemStack.field_190927_a;

    public EntityPumpkinProjectile(World worldIn) {
        super(worldIn);
        this.rotation = this.field_70146_Z.nextInt(200);
        this.func_70105_a(0.8f, 0.8f);
    }

    public EntityPumpkinProjectile(World worldIn, double x, double y, double z, ItemStack ammoStack) {
        this(worldIn);
        this.func_70107_b(x, y, z);
        if (ammoStack.func_77978_p() != null) {
            this.func_70037_a(ammoStack.func_77978_p());
        }
    }

    public EntityPumpkinProjectile(World worldIn, EntityLivingBase shootingEntity, ItemStack ammoStack, boolean shouldHurtPlayer) {
        this(worldIn, shootingEntity.field_70165_t, shootingEntity.field_70163_u + (double)shootingEntity.func_70047_e() - 0.1, shootingEntity.field_70161_v, ammoStack);
        this.shootingEntity = shootingEntity;
        this.shouldHurtPlayer = shouldHurtPlayer;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(BOUNCES_LEFT, (Object)0);
        this.field_70180_af.func_187214_a(IS_FLAMING, (Object)false);
        this.field_70180_af.func_187214_a(IS_SMOKING, (Object)true);
        this.field_70180_af.func_187214_a(HAS_BONE_MEAL, (Object)false);
        this.field_70180_af.func_187214_a(FIREWORK_NBT, (Object)new NBTTagCompound());
        this.field_70180_af.func_187214_a(POTION_ITEM, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(IS_ENDER_PEARL, (Object)false);
    }

    private void setBouncesLeft(int bounces) {
        this.field_70180_af.func_187227_b(BOUNCES_LEFT, (Object)bounces);
        this.field_70180_af.func_187217_b(BOUNCES_LEFT);
    }

    private void setIsFlaming(boolean isFlaming) {
        this.field_70180_af.func_187227_b(IS_FLAMING, (Object)isFlaming);
        this.field_70180_af.func_187217_b(IS_FLAMING);
    }

    private void setIsSmoking(boolean isSmoking) {
        this.field_70180_af.func_187227_b(IS_SMOKING, (Object)isSmoking);
        this.field_70180_af.func_187217_b(IS_SMOKING);
    }

    private void setHasBoneMeal(boolean hasBoneMeal) {
        this.field_70180_af.func_187227_b(HAS_BONE_MEAL, (Object)hasBoneMeal);
        this.field_70180_af.func_187217_b(HAS_BONE_MEAL);
    }

    private void setFireworkNBT(NBTTagCompound compound) {
        this.field_70180_af.func_187227_b(FIREWORK_NBT, (Object)compound);
        this.fireworkLifetimeMax = 6 * (compound.func_74771_c("Flight") + 1) + this.field_70146_Z.nextInt(5);
        this.field_70180_af.func_187217_b(FIREWORK_NBT);
    }

    private void setPotion(ItemStack itemstack) {
        this.field_70180_af.func_187227_b(POTION_ITEM, (Object)itemstack);
        this.field_70180_af.func_187217_b(POTION_ITEM);
    }

    private void setIsEnderPearl(boolean isEnderPearl) {
        this.field_70180_af.func_187227_b(IS_ENDER_PEARL, (Object)isEnderPearl);
        this.field_70180_af.func_187217_b(IS_ENDER_PEARL);
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        this.field_70159_w = x * (double)velocity / (double)f + this.field_70146_Z.nextGaussian() * 0.0075 * (double)inaccuracy;
        this.field_70181_x = y * (double)velocity / (double)f + this.field_70146_Z.nextGaussian() * 0.0075 * (double)inaccuracy;
        this.field_70179_y = z * (double)velocity / (double)f + this.field_70146_Z.nextGaussian() * 0.0075 * (double)inaccuracy;
    }

    public void shoot(Entity shooter, float pitch, float yaw, float velocity, float inaccuracy) {
        float x = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        float y = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
        float z = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        this.func_70186_c(x, y, z, velocity, inaccuracy);
        this.field_70159_w += shooter.field_70159_w;
        this.field_70179_y += shooter.field_70179_y;
        if (!shooter.field_70122_E) {
            this.field_70181_x += shooter.field_70181_x;
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        ++this.rotation;
        this.spawnParticles();
        if (((Boolean)this.field_70180_af.func_187225_a(IS_ENDER_PEARL)).booleanValue() && this.shootingEntity != null && !this.shootingEntity.func_70089_S()) {
            this.setIsEnderPearl(false);
        }
        if (!((NBTTagCompound)this.field_70180_af.func_187225_a(FIREWORK_NBT)).func_82582_d() && !this.field_70170_p.field_72995_K) {
            if (this.fireworkLifetime == 0) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187631_bo, SoundCategory.NEUTRAL, 2.0f, 1.0f);
            }
            if (this.fireworkLifetime > this.fireworkLifetimeMax) {
                this.detonate(null);
            } else {
                ++this.fireworkLifetime;
            }
        }
        Vec3d vecPrev = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vecNew = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult rayTraceResult = this.field_70170_p.func_147447_a(vecPrev, vecNew, false, true, false);
        vecPrev = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vecNew = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (rayTraceResult != null) {
            vecNew = new Vec3d(rayTraceResult.field_72307_f.field_72450_a, rayTraceResult.field_72307_f.field_72448_b, rayTraceResult.field_72307_f.field_72449_c);
        }
        Entity hitEntity = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0));
        list.remove(this.shootingEntity);
        double hitEntityDistance = 0.0;
        boolean flag = false;
        for (Entity entity : list) {
            double distance;
            if (!entity.func_70067_L()) continue;
            if (entity == this.ignoreEntity) {
                flag = true;
                continue;
            }
            if (this.shootingEntity != null && this.field_70173_aa < 2 && this.ignoreEntity == null) {
                this.ignoreEntity = entity;
                flag = true;
                continue;
            }
            flag = false;
            AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_186662_g(0.3);
            RayTraceResult rayTraceResult1 = axisalignedbb.func_72327_a(vecPrev, vecNew);
            if (rayTraceResult1 == null || !((distance = vecPrev.func_72436_e(rayTraceResult1.field_72307_f)) < hitEntityDistance) && hitEntityDistance != 0.0) continue;
            hitEntity = entity;
            hitEntityDistance = distance;
        }
        if (this.ignoreEntity != null) {
            if (flag) {
                this.ignoreTime = 2;
            } else if (this.ignoreTime-- <= 0) {
                this.ignoreEntity = null;
            }
        }
        if (hitEntity != null) {
            rayTraceResult = new RayTraceResult(hitEntity);
        }
        if (rayTraceResult != null) {
            if (rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK && this.field_70170_p.func_180495_p(rayTraceResult.func_178782_a()).func_177230_c() == Blocks.field_150427_aO) {
                this.func_181015_d(rayTraceResult.func_178782_a());
            } else if (!ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)rayTraceResult)) {
                this.onImpact(rayTraceResult);
            }
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        double speedMultiplier = this.func_70090_H() ? 0.9 : 1.0;
        this.field_70159_w *= speedMultiplier;
        this.field_70179_y *= speedMultiplier;
        this.field_70181_x = this.field_70181_x * speedMultiplier - (this.func_189652_ae() || !((NBTTagCompound)this.field_70180_af.func_187225_a(FIREWORK_NBT)).func_82582_d() ? 0.0 : 0.08);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_145775_I();
    }

    private void spawnParticles() {
        if (this.field_70170_p.field_72995_K) {
            if (this.func_70090_H()) {
                for (int i = 0; i < 4; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * 0.25 + this.field_70146_Z.nextDouble() * 0.5 - 0.25, this.field_70163_u - this.field_70181_x * 0.25 + this.field_70146_Z.nextDouble() * 0.5 - 0.25, this.field_70161_v - this.field_70179_y * 0.25 + this.field_70146_Z.nextDouble() * 0.5 - 0.25, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
            } else {
                int color;
                if (((Boolean)this.field_70180_af.func_187225_a(IS_FLAMING)).booleanValue()) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t - this.field_70159_w * 0.25 + this.field_70146_Z.nextDouble() * 0.5 - 0.25, this.field_70163_u - this.field_70181_x * 0.25 + this.field_70146_Z.nextDouble() * 0.5 - 0.25, this.field_70161_v - this.field_70179_y * 0.25 + this.field_70146_Z.nextDouble() * 0.5 - 0.25, this.field_70159_w * 0.6, this.field_70181_x * 0.6, this.field_70179_y * 0.6, new int[0]);
                }
                if (((Boolean)this.field_70180_af.func_187225_a(IS_SMOKING)).booleanValue()) {
                    for (int i = 0; i < 3; ++i) {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t - this.field_70159_w * 0.25 + this.field_70146_Z.nextDouble() * 0.5 - 0.25, this.field_70163_u - this.field_70181_x * 0.25 + this.field_70146_Z.nextDouble() * 0.5 - 0.25, this.field_70161_v - this.field_70179_y * 0.25 + this.field_70146_Z.nextDouble() * 0.5 - 0.25, this.field_70159_w * 0.3, this.field_70181_x * 0.3, this.field_70179_y * 0.3, new int[0]);
                    }
                    if (this.field_70173_aa % 2 == 0) {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t - this.field_70159_w * 0.25 + this.field_70146_Z.nextDouble() * 0.5 - 0.25, this.field_70163_u - this.field_70181_x * 0.25 + this.field_70146_Z.nextDouble() * 0.5 - 0.25, this.field_70161_v - this.field_70179_y * 0.25 + this.field_70146_Z.nextDouble() * 0.5 - 0.25, this.field_70159_w * 0.3, this.field_70181_x * 0.3, this.field_70179_y * 0.3, new int[0]);
                    }
                }
                if (!((NBTTagCompound)this.field_70180_af.func_187225_a(FIREWORK_NBT)).func_82582_d()) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.FIREWORKS_SPARK, this.field_70165_t, this.field_70163_u - 0.3, this.field_70161_v, this.field_70146_Z.nextGaussian() * 0.05, -this.field_70181_x * 0.5, this.field_70146_Z.nextGaussian() * 0.05, new int[0]);
                }
                if (((Boolean)this.field_70180_af.func_187225_a(HAS_BONE_MEAL)).booleanValue() && this.field_70173_aa % 3 == 0) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, this.field_70165_t + this.field_70146_Z.nextDouble() * 0.5, this.field_70163_u + this.field_70146_Z.nextDouble() * 0.5, this.field_70161_v + this.field_70146_Z.nextDouble() * 0.5, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, new int[0]);
                }
                if (((Boolean)this.field_70180_af.func_187225_a(IS_ENDER_PEARL)).booleanValue()) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + this.field_70146_Z.nextDouble() * 0.5, this.field_70163_u + this.field_70146_Z.nextDouble() * 0.5, this.field_70161_v + this.field_70146_Z.nextDouble() * 0.5, this.field_70146_Z.nextGaussian() * 0.08, this.field_70146_Z.nextGaussian() * 0.08, this.field_70146_Z.nextGaussian() * 0.08, new int[0]);
                }
                if (!((ItemStack)this.field_70180_af.func_187225_a(POTION_ITEM)).func_190926_b() && (color = PotionUtils.func_190932_c((ItemStack)((ItemStack)this.field_70180_af.func_187225_a(POTION_ITEM)))) > 0) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (double)(color >> 16 & 0xFF) / 255.0, (double)(color >> 8 & 0xFF) / 255.0, (double)(color & 0xFF) / 255.0, new int[0]);
                }
            }
        }
    }

    protected void onImpact(RayTraceResult raytraceresult) {
        if (!this.field_70170_p.field_72995_K) {
            if (raytraceresult.field_72313_a == RayTraceResult.Type.ENTITY && raytraceresult.field_72308_g instanceof EntityLiving) {
                if (this.shootingEntity instanceof EntityPlayer && raytraceresult.field_72308_g != this.shootingEntity) {
                    raytraceresult.field_72308_g.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)this.shootingEntity)), (float)(1 + 2 * this.extraDamage));
                } else {
                    raytraceresult.field_72308_g.func_70097_a(DamageSource.field_76377_j, (float)(1 + 2 * this.extraDamage));
                }
                if (((Boolean)this.field_70180_af.func_187225_a(IS_FLAMING)).booleanValue()) {
                    raytraceresult.field_72308_g.func_70015_d(4);
                }
            }
            if (raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK && ((Boolean)this.field_70180_af.func_187225_a(IS_FLAMING)).booleanValue() && this.field_70170_p.func_175623_d(raytraceresult.func_178782_a().func_177972_a(raytraceresult.field_178784_b)) && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this.shootingEntity)) {
                this.field_70170_p.func_180501_a(raytraceresult.func_178782_a().func_177972_a(raytraceresult.field_178784_b), Blocks.field_150480_ab.func_176223_P(), 11);
            }
            if ((Integer)this.field_70180_af.func_187225_a(BOUNCES_LEFT) <= 0 || this.func_70090_H()) {
                this.detonate(raytraceresult);
                return;
            }
        }
        if ((Integer)this.field_70180_af.func_187225_a(BOUNCES_LEFT) > 0 && !this.func_70090_H()) {
            this.bounce(raytraceresult);
        }
    }

    private void bounce(RayTraceResult result) {
        this.setBouncesLeft((Integer)this.field_70180_af.func_187225_a(BOUNCES_LEFT) - 1);
        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187882_fq, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
            if (result.field_178784_b.func_176740_k() == EnumFacing.Axis.X) {
                this.field_70159_w = -this.field_70159_w * 0.75;
            } else if (result.field_178784_b.func_176740_k() == EnumFacing.Axis.Y) {
                this.field_70181_x = -this.field_70181_x * 0.75;
            } else if (result.field_178784_b.func_176740_k() == EnumFacing.Axis.Z) {
                this.field_70179_y = -this.field_70179_y * 0.75;
            }
            this.field_70170_p.func_72960_a((Entity)this, (byte)100);
            if (((Boolean)this.field_70180_af.func_187225_a(HAS_BONE_MEAL)).booleanValue() && !this.field_70170_p.field_72995_K && ItemDye.func_179234_a((ItemStack)new ItemStack(Items.field_151100_aR, EnumDyeColor.WHITE.func_176767_b()), (World)this.field_70170_p, (BlockPos)result.func_178782_a())) {
                this.field_70170_p.func_175718_b(2005, result.func_178782_a(), 0);
            }
        } else if (result.field_72313_a == RayTraceResult.Type.ENTITY) {
            this.detonate(result);
        }
    }

    private void detonate(@Nullable RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            ItemStack potionStack;
            boolean canMobGrief;
            if (((Boolean)this.field_70180_af.func_187225_a(IS_ENDER_PEARL)).booleanValue()) {
                this.doEnderPearlThings(result);
            }
            if (this.arrowStack != null && !this.arrowStack.func_190926_b()) {
                this.spawnArrows(result);
            }
            boolean bl = canMobGrief = this.shootingEntity == null || ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this.shootingEntity);
            if (this.power > 0) {
                new CustomExplosion(this.field_70170_p, this, this.shootingEntity, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)(this.power + 2) / 2.25f, this.extraDamage, canMobGrief && (Boolean)this.field_70180_af.func_187225_a(IS_FLAMING) != false, canMobGrief && this.canDestroyBlocks, this.shouldHurtPlayer).detonate();
            } else {
                this.field_70170_p.func_72960_a((Entity)this, (byte)101);
            }
            if (((Boolean)this.field_70180_af.func_187225_a(HAS_BONE_MEAL)).booleanValue()) {
                this.doBoneMealThings();
            }
            if (!((potionStack = (ItemStack)this.field_70180_af.func_187225_a(POTION_ITEM)).func_190926_b() || potionStack.func_77973_b() != Items.field_185155_bH && potionStack.func_77973_b() != Items.field_185156_bI)) {
                this.doPotionThings(result);
            }
            if (!((NBTTagCompound)this.field_70180_af.func_187225_a(FIREWORK_NBT)).func_82582_d()) {
                this.dealFireworkDamage();
                this.field_70170_p.func_72960_a((Entity)this, (byte)17);
            }
            this.func_70106_y();
        }
        if (this.power <= 0) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187881_gQ, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        }
    }

    private void doEnderPearlThings(@Nullable RayTraceResult result) {
        if (result != null && result.field_72308_g != null) {
            if (result.field_72308_g == this.shootingEntity) {
                return;
            }
            result.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.shootingEntity), 0.0f);
        }
        for (int i = 0; i < 32; ++i) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t, this.field_70163_u + this.field_70146_Z.nextDouble() * 2.0, this.field_70161_v, this.field_70146_Z.nextGaussian(), 0.0, this.field_70146_Z.nextGaussian(), new int[0]);
        }
        if (!this.field_70170_p.field_72995_K && this.shootingEntity != null) {
            this.teleportEntity(this.shootingEntity, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    private void teleportEntity(EntityLivingBase entity, double posX, double posY, double posZ) {
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)entity;
            if (entityplayermp.field_71135_a.func_147362_b().func_150724_d() && entityplayermp.field_70170_p == this.field_70170_p && !entityplayermp.func_70608_bn()) {
                if (entity.func_184218_aH()) {
                    entity.func_184210_p();
                }
                entity.func_70634_a(posX, posY, posZ);
                entity.field_70143_R = 0.0f;
                entity.func_70097_a(DamageSource.field_76379_h, 3.0f);
            }
        } else {
            entity.func_70634_a(posX, posY, posZ);
            entity.field_70143_R = 0.0f;
        }
    }

    private void spawnArrows(@Nullable RayTraceResult result) {
        for (int i = 0; i < this.arrowStack.func_190916_E(); ++i) {
            EntityArrow arrow;
            if (this.shootingEntity != null) {
                arrow = ((ItemArrow)this.arrowStack.func_77973_b()).func_185052_a(this.field_70170_p, this.arrowStack, this.shootingEntity);
            } else {
                if (!(this.field_70170_p instanceof WorldServer)) {
                    return;
                }
                arrow = ((ItemArrow)this.arrowStack.func_77973_b()).func_185052_a(this.field_70170_p, this.arrowStack, (EntityLivingBase)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.field_70170_p)));
            }
            arrow.field_70165_t = this.field_70165_t;
            arrow.field_70163_u = this.field_70163_u;
            arrow.field_70161_v = this.field_70161_v;
            arrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
            arrow.func_70239_b(arrow.func_70242_d() * 2.5);
            if (this.shootingEntity != null) {
                arrow.field_70250_c = this.shootingEntity;
            }
            double x = this.field_70159_w;
            double y = this.field_70181_x;
            double z = this.field_70179_y;
            if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK) {
                if (result.field_178784_b.func_176740_k() == EnumFacing.Axis.X) {
                    x = -this.field_70159_w;
                } else if (result.field_178784_b.func_176740_k() == EnumFacing.Axis.Y) {
                    y = -this.field_70181_x;
                } else if (result.field_178784_b.func_176740_k() == EnumFacing.Axis.Z) {
                    z = -this.field_70179_y;
                }
            } else if (result != null && result.field_72313_a == RayTraceResult.Type.ENTITY) {
                x = this.field_70146_Z.nextDouble() * 2.0 - 1.0;
                y = this.field_70146_Z.nextDouble();
                z = this.field_70146_Z.nextDouble() * 2.0 - 1.0;
            }
            arrow.func_70186_c(x, y, z, MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y)), 10.0f);
            this.field_70170_p.func_72838_d((Entity)arrow);
        }
    }

    private void doBoneMealThings() {
        for (BlockPos pos : BlockPos.func_191532_a((int)((int)(this.field_70165_t + 0.5) - 5), (int)((int)(this.field_70163_u + 0.5) - 5), (int)((int)(this.field_70161_v + 0.5) - 5), (int)((int)(this.field_70165_t + 0.5) + 5), (int)((int)(this.field_70163_u + 0.5) + 5), (int)((int)(this.field_70161_v + 0.5) + 5))) {
            if (this.field_70146_Z.nextInt(8) != 0 || !ItemDye.func_179234_a((ItemStack)new ItemStack(Items.field_151100_aR, EnumDyeColor.WHITE.func_176767_b()), (World)this.field_70170_p, (BlockPos)pos)) continue;
            this.field_70170_p.func_175718_b(2005, pos, 0);
        }
    }

    private void doPotionThings(@Nullable RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            boolean isWater;
            ItemStack stack = (ItemStack)this.field_70180_af.func_187225_a(POTION_ITEM);
            PotionType type = PotionUtils.func_185191_c((ItemStack)stack);
            List list = PotionUtils.func_185189_a((ItemStack)stack);
            boolean bl = isWater = type == PotionTypes.field_185230_b && list.isEmpty();
            if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK && isWater) {
                BlockPos pos = result.func_178782_a().func_177972_a(result.field_178784_b);
                this.extinguishFires(pos, result.field_178784_b);
                for (EnumFacing face : EnumFacing.Plane.HORIZONTAL) {
                    this.extinguishFires(pos.func_177972_a(face), face);
                }
            }
            if (isWater) {
                this.applyWater();
            } else if (!list.isEmpty()) {
                if (stack.func_77973_b() == Items.field_185156_bI) {
                    this.makeAreaOfEffectCloud(stack, type);
                } else {
                    this.applySplash(result, list);
                }
            }
            int eventType = type.func_185172_c() ? 2007 : 2002;
            this.field_70170_p.func_175718_b(eventType, new BlockPos((Entity)this), PotionUtils.func_190932_c((ItemStack)stack));
        }
    }

    private void extinguishFires(BlockPos pos, EnumFacing face) {
        if (this.field_70170_p.func_180495_p(pos).func_177230_c() == Blocks.field_150480_ab) {
            this.field_70170_p.func_175719_a(null, pos.func_177972_a(face), face.func_176734_d());
        }
    }

    private void applyWater() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_72314_b(5.0, 3.0, 5.0);
        List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, axisalignedbb, EntityPotion.field_190546_d);
        if (!list.isEmpty()) {
            for (EntityLivingBase entitylivingbase : list) {
                double distance = this.func_70068_e((Entity)entitylivingbase);
                if (!(distance < 16.0) || !(entitylivingbase instanceof EntityEnderman) && !(entitylivingbase instanceof EntityBlaze)) continue;
                entitylivingbase.func_70097_a(DamageSource.field_76369_e, 1.0f);
            }
        }
    }

    private void applySplash(@Nullable RayTraceResult result, List<PotionEffect> effects) {
        AxisAlignedBB boundingBox = this.func_174813_aQ().func_72314_b(5.0, 3.0, 5.0);
        List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, boundingBox);
        if (!list.isEmpty()) {
            for (EntityLivingBase entity : list) {
                double distance;
                if (!entity.func_184603_cC() || !((distance = this.func_70068_e((Entity)entity)) < 16.0)) continue;
                double effectMultiplier = 1.0 - Math.sqrt(distance) / 6.0;
                if (result != null && entity == result.field_72308_g) {
                    effectMultiplier = 1.0;
                }
                for (PotionEffect potioneffect : effects) {
                    Potion potion = potioneffect.func_188419_a();
                    if (potion.func_76403_b()) {
                        potion.func_180793_a((Entity)this, (Entity)this.shootingEntity, entity, potioneffect.func_76458_c(), effectMultiplier);
                        continue;
                    }
                    int duration = (int)(effectMultiplier * (double)potioneffect.func_76459_b() + 0.5);
                    if (duration <= 20) continue;
                    entity.func_70690_d(new PotionEffect(potion, duration, potioneffect.func_76458_c(), potioneffect.func_82720_e(), potioneffect.func_188418_e()));
                }
            }
        }
    }

    private void makeAreaOfEffectCloud(ItemStack stack, PotionType type) {
        EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        entityareaeffectcloud.func_184481_a(this.shootingEntity);
        entityareaeffectcloud.func_184483_a(3.2f);
        entityareaeffectcloud.func_184495_b(-0.4f);
        entityareaeffectcloud.func_184485_d(10);
        entityareaeffectcloud.func_184487_c(-entityareaeffectcloud.func_184490_j() / (float)entityareaeffectcloud.func_184489_o());
        entityareaeffectcloud.func_184484_a(type);
        for (PotionEffect potioneffect : PotionUtils.func_185190_b((ItemStack)stack)) {
            entityareaeffectcloud.func_184496_a(new PotionEffect(potioneffect));
        }
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound != null && nbttagcompound.func_150297_b("CustomPotionColor", 99)) {
            entityareaeffectcloud.func_184482_a(nbttagcompound.func_74762_e("CustomPotionColor"));
        }
        this.field_70170_p.func_72838_d((Entity)entityareaeffectcloud);
    }

    private void dealFireworkDamage() {
        int damageMultiplier = 0;
        NBTTagList tagList = ((NBTTagCompound)this.field_70180_af.func_187225_a(FIREWORK_NBT)).func_150295_c("Explosions", 10);
        if (!tagList.func_82582_d()) {
            damageMultiplier = 5 + tagList.func_74745_c() * 2;
        }
        if (damageMultiplier > 0) {
            Vec3d posVec = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            for (EntityLivingBase entitylivingbase : this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_186662_g(5.0))) {
                if (!(this.func_70068_e((Entity)entitylivingbase) <= 25.0)) continue;
                boolean flag = false;
                for (int i = 0; i < 2; ++i) {
                    RayTraceResult raytraceresult = this.field_70170_p.func_147447_a(posVec, new Vec3d(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u + (double)entitylivingbase.field_70131_O * 0.5 * (double)i, entitylivingbase.field_70161_v), false, true, false);
                    if (raytraceresult != null && raytraceresult.field_72313_a != RayTraceResult.Type.MISS) continue;
                    flag = true;
                    break;
                }
                if (!flag) continue;
                entitylivingbase.func_70097_a(DamageSource.field_191552_t, (float)damageMultiplier * (float)Math.sqrt((5.0f - this.func_70032_d((Entity)entitylivingbase)) / 5.0f));
            }
        }
    }

    @Nullable
    public Entity changeDimension(int dimensionIn, ITeleporter teleporter) {
        if (this.shootingEntity != null && this.shootingEntity.field_71093_bK != dimensionIn) {
            this.setIsEnderPearl(false);
        }
        return super.changeDimension(dimensionIn, teleporter);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 17: {
                this.field_70170_p.func_92088_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70159_w, this.field_70181_x, this.field_70179_y, (NBTTagCompound)this.field_70180_af.func_187225_a(FIREWORK_NBT));
                break;
            }
            case 100: {
                for (int j = 0; j < 16; ++j) {
                    float rotationXZ = (float)((double)this.field_70146_Z.nextFloat() * Math.PI * 2.0);
                    float rotationY = (float)((double)this.field_70146_Z.nextFloat() * Math.PI);
                    float distance = this.field_70146_Z.nextFloat() * 0.4f + 0.3f;
                    float x = MathHelper.func_76126_a((float)rotationXZ) * MathHelper.func_76126_a((float)rotationY) * distance;
                    float y = MathHelper.func_76134_b((float)rotationXZ) * MathHelper.func_76126_a((float)rotationY) * distance;
                    float z = MathHelper.func_76134_b((float)rotationY) * distance;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SLIME, this.field_70165_t + (double)x, this.field_70163_u + (double)y, this.field_70161_v + (double)z, 0.0, 0.0, 0.0, new int[0]);
                }
                break;
            }
            case 101: {
                for (int j = 0; j < 48; ++j) {
                    float rotationXZ = (float)((double)this.field_70146_Z.nextFloat() * Math.PI * 2.0);
                    float rotationY = (float)((double)this.field_70146_Z.nextFloat() * Math.PI);
                    float distance = this.field_70146_Z.nextFloat() * 0.4f + 0.3f;
                    float x = MathHelper.func_76126_a((float)rotationXZ) * MathHelper.func_76126_a((float)rotationY) * distance;
                    float y = MathHelper.func_76134_b((float)rotationXZ) * MathHelper.func_76126_a((float)rotationY) * distance;
                    float z = MathHelper.func_76134_b((float)rotationY) * distance;
                    Particles.PUMPKIN_BREAK.spawn(this.field_70170_p, this.field_70165_t + (double)x, this.field_70163_u + (double)y, this.field_70161_v + (double)z, 0.0, 0.0, 0.0, new int[0]);
                }
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double value = this.func_174813_aQ().func_72320_b() * 12.0;
        if (Double.isNaN(value)) {
            value = 1.0;
        }
        return distance < (value = value * 64.0 * EntityPumpkinProjectile.func_184183_bd()) * value;
    }

    public void func_70014_b(NBTTagCompound compound) {
        ItemStack potionStack;
        compound.func_74774_a("power", (byte)this.power);
        compound.func_74774_a("extraDamage", (byte)this.extraDamage);
        compound.func_74757_a("canDestroyBlocks", this.canDestroyBlocks);
        compound.func_74774_a("bounceAmount", ((Integer)this.field_70180_af.func_187225_a(BOUNCES_LEFT)).byteValue());
        compound.func_74757_a("isFiery", ((Boolean)this.field_70180_af.func_187225_a(IS_FLAMING)).booleanValue());
        compound.func_74757_a("isEnderPearl", ((Boolean)this.field_70180_af.func_187225_a(IS_ENDER_PEARL)).booleanValue());
        compound.func_74757_a("hasBonemeal", ((Boolean)this.field_70180_af.func_187225_a(HAS_BONE_MEAL)).booleanValue());
        compound.func_74782_a("fireworks", (NBTBase)this.field_70180_af.func_187225_a(FIREWORK_NBT));
        compound.func_74768_a("fireworkLifetime", this.fireworkLifetime);
        compound.func_74768_a("fireworkLifetimeMax", this.fireworkLifetimeMax);
        if (!this.arrowStack.func_190926_b()) {
            compound.func_74782_a("arrowTag", (NBTBase)this.arrowStack.func_77955_b(new NBTTagCompound()));
        }
        if (!(potionStack = (ItemStack)this.field_70180_af.func_187225_a(POTION_ITEM)).func_190926_b()) {
            compound.func_74782_a("potionTag", (NBTBase)potionStack.func_77955_b(new NBTTagCompound()));
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.extraDamage = compound.func_74771_c("extraDamage");
        this.fireworkLifetime = compound.func_74762_e("fireworkLifetime");
        this.setBouncesLeft(compound.func_74771_c("bounceAmount"));
        this.setIsFlaming(compound.func_74767_n("isFiery"));
        this.setHasBoneMeal(compound.func_74767_n("hasBonemeal"));
        this.setFireworkNBT(compound.func_74775_l("fireworks"));
        this.setIsEnderPearl(compound.func_74767_n("isEnderPearl"));
        if (compound.func_74764_b("power")) {
            this.power = compound.func_74771_c("power");
        }
        if (compound.func_74764_b("canDestroyBlocks")) {
            this.canDestroyBlocks = compound.func_74767_n("canDestroyBlocks");
        }
        if (compound.func_74764_b("potionTag")) {
            this.setPotion(new ItemStack(compound.func_74775_l("potionTag")));
        }
        if (compound.func_74764_b("arrowTag")) {
            this.arrowStack = new ItemStack(compound.func_74775_l("arrowTag"));
        }
        this.setIsSmoking(this.power > 0);
    }
}

