/*
 * Decompiled with CFR 0.152.
 */
package pumpkinlauncher.common.explosion;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketExplosion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;

@MethodsReturnNonnullByDefault
public class CustomExplosion
extends Explosion {
    protected final boolean shouldCauseFire;
    protected final boolean shouldDamageTerrain;
    protected final boolean shouldDamageShooter;
    protected final Random field_77290_i = new Random();
    protected final World field_77287_j;
    protected final double field_77284_b;
    protected final double field_77285_c;
    protected final double field_77282_d;
    protected final Entity field_77283_e;
    protected final EntityLivingBase shootingEntity;
    protected final float field_77280_f;
    protected final int extraDamage;
    protected static boolean shouldFireExplosionEvent = true;

    public CustomExplosion(World world, Entity explodingEntity, @Nullable EntityLivingBase shootingEntity, double x, double y, double z, float power, int extraDamage, boolean isFlaming, boolean isSmoking, boolean shouldHurtShootingEntity) {
        super(world, explodingEntity, x, y, z, power, isFlaming, isSmoking);
        this.field_77287_j = world;
        this.field_77283_e = explodingEntity;
        this.shootingEntity = shootingEntity;
        this.field_77280_f = power;
        this.extraDamage = extraDamage;
        this.field_77284_b = x;
        this.field_77285_c = y;
        this.field_77282_d = z;
        this.shouldCauseFire = isFlaming;
        this.shouldDamageTerrain = isSmoking;
        this.shouldDamageShooter = shouldHurtShootingEntity;
    }

    public void detonate() {
        if (shouldFireExplosionEvent && ForgeEventFactory.onExplosionStart((World)this.field_77287_j, (Explosion)this)) {
            return;
        }
        this.func_77278_a();
        if (this.field_77287_j instanceof WorldServer) {
            this.func_77279_a(false);
            if (!this.shouldDamageTerrain) {
                this.func_180342_d();
            }
            for (EntityPlayer entityplayer : this.field_77287_j.field_73010_i) {
                if (!(entityplayer.func_70092_e(this.field_77284_b, this.field_77285_c, this.field_77282_d) < 4096.0)) continue;
                ((EntityPlayerMP)entityplayer).field_71135_a.func_147359_a((Packet)new SPacketExplosion(this.field_77284_b, this.field_77285_c, this.field_77282_d, this.field_77280_f, this.func_180343_e(), (Vec3d)this.func_77277_b().get(entityplayer)));
            }
        } else {
            this.func_77279_a(true);
        }
    }

    public void func_77278_a() {
        this.calculateAffectedBlockPositions();
        this.damageEntities();
    }

    protected void calculateAffectedBlockPositions() {
        HashSet affectedBlockPositions = Sets.newHashSet();
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double distance = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= distance;
                    d1 /= distance;
                    d2 /= distance;
                    float f = this.field_77280_f * (0.7f + this.field_77287_j.field_73012_v.nextFloat() * 0.6f);
                    double x = this.field_77284_b;
                    double y = this.field_77285_c;
                    double z = this.field_77282_d;
                    while (f > 0.0f) {
                        BlockPos pos = new BlockPos(x, y, z);
                        IBlockState state = this.field_77287_j.func_180495_p(pos);
                        if (state.func_185904_a() != Material.field_151579_a) {
                            float f2 = this.field_77283_e != null ? this.field_77283_e.func_180428_a((Explosion)this, this.field_77287_j, pos, state) : state.func_177230_c().getExplosionResistance(this.field_77287_j, pos, null, (Explosion)this);
                            f -= (f2 + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && (this.field_77283_e == null || this.field_77283_e.func_174816_a((Explosion)this, this.field_77287_j, pos, state, f))) {
                            affectedBlockPositions.add(pos);
                        }
                        x += d0 * 0.3;
                        y += d1 * 0.3;
                        z += d2 * 0.3;
                        f = (float)((double)f - 0.225);
                    }
                }
            }
        }
        this.func_180343_e().addAll(affectedBlockPositions);
    }

    protected void damageEntities() {
        float size = this.field_77280_f * 2.0f;
        List affectedEntities = this.field_77287_j.func_72839_b(this.field_77283_e, new AxisAlignedBB((double)MathHelper.func_76128_c((double)(this.field_77284_b - (double)size - 1.0)), (double)MathHelper.func_76128_c((double)(this.field_77285_c - (double)size - 1.0)), (double)MathHelper.func_76128_c((double)(this.field_77282_d - (double)size - 1.0)), (double)MathHelper.func_76128_c((double)(this.field_77284_b + (double)size + 1.0)), (double)MathHelper.func_76128_c((double)(this.field_77285_c + (double)size + 1.0)), (double)MathHelper.func_76128_c((double)(this.field_77282_d + (double)size + 1.0))));
        if (shouldFireExplosionEvent) {
            ForgeEventFactory.onExplosionDetonate((World)this.field_77287_j, (Explosion)this, (List)affectedEntities, (double)size);
        }
        Vec3d vec3d = new Vec3d(this.field_77284_b, this.field_77285_c, this.field_77282_d);
        for (Entity entity : affectedEntities) {
            EntityPlayer entityplayer;
            double distanceZ;
            double distanceY;
            double distanceX;
            double distance;
            double d12;
            if (entity.func_180427_aV() || !((d12 = entity.func_70011_f(this.field_77284_b, this.field_77285_c, this.field_77282_d) / (double)size) <= 1.0) || (distance = (double)MathHelper.func_76133_a((double)((distanceX = entity.field_70165_t - this.field_77284_b) * distanceX + (distanceY = entity.field_70163_u + (double)entity.func_70047_e() - this.field_77285_c) * distanceY + (distanceZ = entity.field_70161_v - this.field_77282_d) * distanceZ))) == 0.0) continue;
            distanceX /= distance;
            distanceY /= distance;
            distanceZ /= distance;
            double blockDensity = this.field_77287_j.func_72842_a(vec3d, entity.func_174813_aQ());
            double damageMultiplier = (1.0 - d12) * blockDensity;
            damageMultiplier = damageMultiplier * damageMultiplier + damageMultiplier;
            if (entity == this.shootingEntity && !this.shouldDamageShooter) {
                damageMultiplier /= 32.0;
            }
            entity.func_70097_a(DamageSource.func_94539_a((Explosion)this), (float)((int)(damageMultiplier / 2.0 * 7.0 * (double)size + 1.0)) + (float)this.extraDamage * 1.25f);
            double knockbackMultiplier = damageMultiplier;
            if (entity instanceof EntityLivingBase) {
                knockbackMultiplier = EnchantmentProtection.func_92092_a((EntityLivingBase)((EntityLivingBase)entity), (double)damageMultiplier);
            }
            entity.field_70159_w += distanceX * knockbackMultiplier;
            entity.field_70181_x += distanceY * knockbackMultiplier;
            entity.field_70179_y += distanceZ * knockbackMultiplier;
            if (!(entity instanceof EntityPlayer) || (entityplayer = (EntityPlayer)entity).func_175149_v() || entityplayer.func_184812_l_() && entityplayer.field_71075_bZ.field_75100_b) continue;
            this.func_77277_b().put(entityplayer, new Vec3d(distanceX * damageMultiplier, distanceY * damageMultiplier, distanceZ * damageMultiplier));
        }
    }

    public void func_77279_a(boolean spawnParticles) {
        this.field_77287_j.func_184148_a(null, this.field_77284_b, this.field_77285_c, this.field_77282_d, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.field_77287_j.field_73012_v.nextFloat() - this.field_77287_j.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        if (spawnParticles) {
            this.spawnParticles();
        }
        if (this.shouldDamageTerrain) {
            for (BlockPos blockpos : this.func_180343_e()) {
                IBlockState state = this.field_77287_j.func_180495_p(blockpos);
                Block block = state.func_177230_c();
                if (spawnParticles) {
                    this.spawnParticles(blockpos);
                }
                if (state.func_185904_a() == Material.field_151579_a) continue;
                if (block.func_149659_a((Explosion)this)) {
                    block.func_180653_a(this.field_77287_j, blockpos, this.field_77287_j.func_180495_p(blockpos), 1.0f / this.field_77280_f, 0);
                }
                block.onBlockExploded(this.field_77287_j, blockpos, (Explosion)this);
            }
        }
        if (this.shouldCauseFire) {
            for (BlockPos pos : this.func_180343_e()) {
                if (this.field_77287_j.func_180495_p(pos).func_185904_a() != Material.field_151579_a || !this.field_77287_j.func_180495_p(pos.func_177977_b()).func_185913_b() || this.field_77290_i.nextInt(3) != 0) continue;
                this.field_77287_j.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
            }
        }
    }

    protected void spawnParticles(BlockPos pos) {
        double xCoord = (float)pos.func_177958_n() + this.field_77287_j.field_73012_v.nextFloat();
        double yCoord = (float)pos.func_177956_o() + this.field_77287_j.field_73012_v.nextFloat();
        double zCoord = (float)pos.func_177952_p() + this.field_77287_j.field_73012_v.nextFloat();
        double xSpeed = xCoord - this.field_77284_b;
        double ySpeed = yCoord - this.field_77285_c;
        double zSpeed = zCoord - this.field_77282_d;
        double d6 = MathHelper.func_76133_a((double)(xSpeed * xSpeed + ySpeed * ySpeed + zSpeed * zSpeed));
        xSpeed /= d6;
        ySpeed /= d6;
        zSpeed /= d6;
        double d7 = 0.5 / (d6 / (double)this.field_77280_f + 0.1);
        this.field_77287_j.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, (xCoord + this.field_77284_b) / 2.0, (yCoord + this.field_77285_c) / 2.0, (zCoord + this.field_77282_d) / 2.0, xSpeed *= (d7 *= (double)(this.field_77287_j.field_73012_v.nextFloat() * this.field_77287_j.field_73012_v.nextFloat()) + 0.3), ySpeed *= d7, zSpeed *= d7, new int[0]);
        this.field_77287_j.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, xCoord, yCoord, zCoord, xSpeed, ySpeed, zSpeed, new int[0]);
    }

    protected void spawnParticles() {
        if (this.field_77280_f >= 2.0f && this.shouldDamageTerrain) {
            this.field_77287_j.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_77284_b, this.field_77285_c, this.field_77282_d, 1.0, 0.0, 0.0, new int[0]);
        } else {
            this.field_77287_j.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_77284_b, this.field_77285_c, this.field_77282_d, 1.0, 0.0, 0.0, new int[0]);
        }
    }

    @Nullable
    public EntityLivingBase func_94613_c() {
        return this.shootingEntity != null ? this.shootingEntity : super.func_94613_c();
    }
}

