/*
 * Decompiled with CFR 0.152.
 */
package pumpkinlauncher.common.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFireworkCharge;
import net.minecraft.item.ItemSpectralArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTippedArrow;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ItemPumpkinAmmo
extends Item {
    public ItemPumpkinAmmo() {
        this.setRegistryName("pumpkinammo");
        this.func_77655_b("pumpkinammo");
        this.func_77637_a(CreativeTabs.field_78037_j);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound != null) {
            if (nbttagcompound.func_74764_b("arrowTag") && !nbttagcompound.func_74775_l("arrowTag").func_82582_d()) {
                ItemStack arrowStack = new ItemStack(nbttagcompound.func_74775_l("arrowTag"));
                tooltip.add(I18n.func_74838_a((String)"item.pumpkinammo.arrows") + " " + arrowStack.func_190916_E());
                if (arrowStack.func_77973_b() instanceof ItemTippedArrow) {
                    List list = PotionUtils.func_185189_a((ItemStack)arrowStack);
                    if (list.isEmpty()) {
                        tooltip.add(TextFormatting.GRAY + "  " + I18n.func_74838_a((String)"effect.none").trim());
                    } else {
                        for (PotionEffect potioneffect : list) {
                            String effectString = I18n.func_74838_a((String)potioneffect.func_76453_d()).trim();
                            if (potioneffect.func_76458_c() > 0) {
                                effectString = effectString + " " + I18n.func_74838_a((String)("potion.potency." + potioneffect.func_76458_c())).trim();
                            }
                            if (potioneffect.func_76459_b() > 20) {
                                effectString = effectString + " (" + Potion.func_188410_a((PotionEffect)potioneffect, (float)0.125f) + ")";
                            }
                            if (potioneffect.func_188419_a().func_76398_f()) {
                                tooltip.add(TextFormatting.RED + "  " + effectString);
                                continue;
                            }
                            tooltip.add(TextFormatting.BLUE + "  " + effectString);
                        }
                    }
                } else if (arrowStack.func_77973_b() instanceof ItemSpectralArrow) {
                    tooltip.add(TextFormatting.AQUA + "  " + I18n.func_74838_a((String)"item.pumpkinammo.spectral"));
                } else if (arrowStack.func_77973_b() != Items.field_151032_g) {
                    tooltip.add("  " + arrowStack.func_151000_E().func_150260_c());
                }
            }
            if (nbttagcompound.func_74764_b("power") && nbttagcompound.func_74771_c("power") > 0) {
                tooltip.add(I18n.func_74838_a((String)"item.pumpkinammo.power") + " " + nbttagcompound.func_74771_c("power"));
            }
            if (nbttagcompound.func_74764_b("bounceAmount") && nbttagcompound.func_74771_c("bounceAmount") > 0) {
                tooltip.add(I18n.func_74838_a((String)"item.pumpkinammo.bounce") + " " + nbttagcompound.func_74771_c("bounceAmount"));
            }
            if (nbttagcompound.func_74764_b("extraDamage") && nbttagcompound.func_74771_c("extraDamage") > 0) {
                tooltip.add(I18n.func_74838_a((String)"item.pumpkinammo.extradamage") + " " + nbttagcompound.func_74771_c("extraDamage"));
            }
            if (nbttagcompound.func_74764_b("isFiery") && nbttagcompound.func_74767_n("isFiery")) {
                tooltip.add(I18n.func_74838_a((String)"item.pumpkinammo.isfiery"));
            }
            if (nbttagcompound.func_74764_b("canDestroyBlocks") && !nbttagcompound.func_74767_n("canDestroyBlocks")) {
                tooltip.add(I18n.func_74838_a((String)"item.pumpkinammo.nogriefing"));
            }
            if (nbttagcompound.func_74764_b("hasBonemeal") && nbttagcompound.func_74767_n("hasBonemeal")) {
                tooltip.add(I18n.func_74838_a((String)"item.pumpkinammo.bonemeal"));
            }
            if (nbttagcompound.func_74764_b("isEnderPearl") && nbttagcompound.func_74767_n("isEnderPearl")) {
                tooltip.add(I18n.func_74838_a((String)"item.pumpkinammo.enderpearl"));
            }
            if (nbttagcompound.func_74764_b("fireworks")) {
                NBTTagList nbttaglist;
                NBTTagCompound fireworksCompound = (NBTTagCompound)nbttagcompound.func_74781_a("fireworks");
                if (fireworksCompound.func_150297_b("Flight", 99)) {
                    tooltip.add(I18n.func_74838_a((String)"item.fireworks.flight") + " " + fireworksCompound.func_74771_c("Flight"));
                }
                if (!(nbttaglist = fireworksCompound.func_150295_c("Explosions", 10)).func_82582_d()) {
                    for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                        NBTTagCompound subCompound = nbttaglist.func_150305_b(i);
                        ArrayList list = Lists.newArrayList();
                        ItemFireworkCharge.func_150902_a((NBTTagCompound)subCompound, (List)list);
                        if (list.isEmpty()) continue;
                        for (int j = 1; j < list.size(); ++j) {
                            list.set(j, "  " + (String)list.get(j));
                        }
                        tooltip.addAll(list);
                    }
                }
            }
            if (nbttagcompound.func_74764_b("potionTag")) {
                ItemStack potionStack;
                PotionUtils.func_185182_a((ItemStack)potionStack, tooltip, (float)((potionStack = new ItemStack(stack.func_77978_p().func_74775_l("potionTag"))).func_77973_b() == Items.field_185156_bI ? 0.25f : 1.0f));
                if (potionStack.func_77973_b() == Items.field_185156_bI) {
                    tooltip.add(I18n.func_74838_a((String)"item.pumpkinammo.lingering"));
                }
            }
        }
    }
}

