/*
 * Decompiled with CFR 0.152.
 */
package pumpkinlauncher.common.item;

import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pumpkinlauncher.PumpkinLauncher;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class RecipePumpkinAmmo
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private ItemStack resultItem = ItemStack.field_190927_a;

    public RecipePumpkinAmmo() {
        this.setRegistryName("recipepumpkinammo");
    }

    public boolean func_77569_a(InventoryCrafting inventory, World world) {
        this.resultItem = ItemStack.field_190927_a;
        int pumpkinAmount = 0;
        int gunpowderAmount = 0;
        int fireChargeAmount = 0;
        int woolAmount = 0;
        int slimeBallAmount = 0;
        int bonemealAmount = 0;
        int enderPearlAmount = 0;
        int ironNuggetAmount = 0;
        NBTTagCompound fireworkNBT = null;
        ItemStack potionStack = null;
        ItemStack arrowStack = null;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockPumpkin) {
                ++pumpkinAmount;
                continue;
            }
            if (OreDictionary.itemMatches((ItemStack)new ItemStack(Items.field_151016_H, 1, Short.MAX_VALUE), (ItemStack)stack, (boolean)false)) {
                ++gunpowderAmount;
                continue;
            }
            if (OreDictionary.itemMatches((ItemStack)new ItemStack(Items.field_151059_bz, 1, Short.MAX_VALUE), (ItemStack)stack, (boolean)false)) {
                ++fireChargeAmount;
                continue;
            }
            if (OreDictionary.itemMatches((ItemStack)new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE), (ItemStack)stack, (boolean)false)) {
                ++woolAmount;
                continue;
            }
            if (OreDictionary.itemMatches((ItemStack)new ItemStack(Blocks.field_189880_di, 1, Short.MAX_VALUE), (ItemStack)stack, (boolean)false)) {
                ++bonemealAmount;
                continue;
            }
            if (OreDictionary.itemMatches((ItemStack)new ItemStack(Items.field_151079_bi, 1, Short.MAX_VALUE), (ItemStack)stack, (boolean)false)) {
                ++enderPearlAmount;
                continue;
            }
            if (new OreIngredient("nuggetIron").apply(stack)) {
                ++ironNuggetAmount;
                continue;
            }
            if (new OreIngredient("slimeball").apply(stack)) {
                ++slimeBallAmount;
                continue;
            }
            if (OreDictionary.itemMatches((ItemStack)new ItemStack(Items.field_151152_bP, 1, Short.MAX_VALUE), (ItemStack)stack, (boolean)false)) {
                if (fireworkNBT != null) {
                    return false;
                }
                if (stack.func_77978_p() == null) {
                    fireworkNBT = new NBTTagCompound();
                    fireworkNBT.func_74774_a("Flight", (byte)2);
                    continue;
                }
                try {
                    fireworkNBT = (NBTTagCompound)stack.func_77978_p().func_74781_a("Fireworks");
                    continue;
                }
                catch (ClassCastException e) {
                    return false;
                }
            }
            if (stack.func_77973_b() == Items.field_185155_bH || stack.func_77973_b() == Items.field_185156_bI) {
                if (stack.func_77978_p() == null || potionStack != null) {
                    return false;
                }
                potionStack = stack;
                continue;
            }
            if (stack.func_77973_b() instanceof ItemArrow) {
                if (arrowStack == null) {
                    arrowStack = stack.func_77946_l();
                    arrowStack.func_190920_e(1);
                    continue;
                }
                ItemStack otherStack = stack.func_77946_l();
                otherStack.func_190920_e(arrowStack.func_190916_E());
                if (ItemStack.func_77989_b((ItemStack)arrowStack, (ItemStack)otherStack)) {
                    arrowStack.func_190917_f(1);
                    continue;
                }
                return false;
            }
            return false;
        }
        if (pumpkinAmount == 1 && (gunpowderAmount != 0 || fireChargeAmount != 0 || slimeBallAmount != 0 || bonemealAmount != 0 || enderPearlAmount != 0 || ironNuggetAmount != 0 || fireworkNBT != null || potionStack != null || arrowStack != null) && gunpowderAmount <= 12 && (woolAmount == 0 || gunpowderAmount >= 1 && woolAmount == 1) && fireChargeAmount <= 1 && slimeBallAmount <= 127 && bonemealAmount <= 1 && enderPearlAmount <= 1 && ironNuggetAmount <= 4) {
            this.resultItem = new ItemStack(PumpkinLauncher.PUMPKIN_AMMO, 3);
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74774_a("power", (byte)gunpowderAmount);
            compound.func_74774_a("bounceAmount", (byte)slimeBallAmount);
            compound.func_74774_a("extraDamage", (byte)ironNuggetAmount);
            compound.func_74757_a("isFiery", fireChargeAmount > 0);
            compound.func_74757_a("canDestroyBlocks", woolAmount < 1);
            compound.func_74757_a("hasBonemeal", bonemealAmount > 0);
            compound.func_74757_a("isEnderPearl", enderPearlAmount > 0);
            if (fireworkNBT != null) {
                compound.func_74782_a("fireworks", fireworkNBT);
            }
            if (potionStack != null) {
                compound.func_74782_a("potionTag", (NBTBase)potionStack.func_77955_b(new NBTTagCompound()));
            }
            if (arrowStack != null) {
                compound.func_74782_a("arrowTag", (NBTBase)arrowStack.func_77955_b(new NBTTagCompound()));
            }
            this.resultItem.func_77982_d(compound);
            return true;
        }
        return false;
    }

    public ItemStack func_77572_b(InventoryCrafting inventory) {
        return this.resultItem.func_77946_l();
    }

    public ItemStack func_77571_b() {
        return this.resultItem;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inventory) {
        NonNullList list = NonNullList.func_191197_a((int)inventory.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack itemstack = inventory.func_70301_a(i);
            list.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
        }
        return list;
    }

    public boolean func_192399_d() {
        return true;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }
}

