/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.utility;

import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class StructureHelper {
    public static BlockPos getGroundPos(World world, BlockPos pos, BlockPos structureSize, double clearancePercentage) {
        if (world.func_175707_a(pos, pos.func_177971_a((Vec3i)structureSize))) {
            while (pos.func_177956_o() > 0) {
                float sizeX = structureSize.func_177958_n() + 2;
                float sizeY = structureSize.func_177956_o() + 1;
                float sizeZ = structureSize.func_177952_p() + 2;
                int groundBlocks = 0;
                int x = 0;
                while ((float)x <= sizeX) {
                    int z = 0;
                    while ((float)z <= sizeZ) {
                        BlockPos newPos = pos.func_177982_a(x, 0, z);
                        if (!world.func_180495_p(newPos).func_185904_a().func_76222_j() && world.func_180495_p(newPos.func_177984_a()).func_185904_a().func_76222_j()) {
                            ++groundBlocks;
                        }
                        ++z;
                    }
                    ++x;
                }
                int replaceableBlocks = 0;
                if ((double)groundBlocks >= (double)(sizeX * sizeZ) * clearancePercentage) {
                    int y = 1;
                    while ((float)y < sizeY) {
                        int x2 = 0;
                        while ((float)x2 <= sizeX) {
                            int z = 0;
                            while ((float)z <= sizeZ) {
                                BlockPos newPos = pos.func_177982_a(x2, y, z);
                                if (world.func_180495_p(newPos).func_185904_a().func_76222_j()) {
                                    ++replaceableBlocks;
                                }
                                ++z;
                            }
                            ++x2;
                        }
                        ++y;
                    }
                }
                if ((double)replaceableBlocks > (double)(sizeX * sizeY * sizeZ) * clearancePercentage) {
                    return pos;
                }
                pos = pos.func_177977_b();
            }
        }
        return null;
    }

    public static BlockPos getAirPos(World world, BlockPos pos, BlockPos structureSize, double clearancePercentage) {
        if (world.func_175707_a(pos, pos.func_177971_a((Vec3i)structureSize))) {
            while (pos.func_177956_o() > 32) {
                float sizeX = structureSize.func_177958_n() + 2;
                float sizeZ = structureSize.func_177952_p() + 2;
                float sizeY = structureSize.func_177956_o() + 2;
                int replaceableBlocks = 0;
                int x = 0;
                while ((float)x <= sizeX) {
                    int z = 0;
                    while ((float)z <= sizeZ) {
                        int y = 0;
                        while ((float)y <= sizeY) {
                            BlockPos newPos = pos.func_177982_a(x, y, z);
                            if (world.func_180495_p(newPos).func_185904_a().func_76222_j()) {
                                ++replaceableBlocks;
                            }
                            ++y;
                        }
                        ++z;
                    }
                    ++x;
                }
                if ((double)replaceableBlocks >= (double)(sizeX * sizeY * sizeZ) * clearancePercentage) {
                    return pos;
                }
                pos = pos.func_177977_b();
            }
        }
        return null;
    }

    public static BlockPos getBuriedPos(World world, BlockPos pos, BlockPos structureSize, double clearancePercentage) {
        if (world.func_175707_a(pos, pos.func_177971_a((Vec3i)structureSize))) {
            while (pos.func_177956_o() > 32) {
                float sizeX = structureSize.func_177958_n();
                float sizeZ = structureSize.func_177952_p();
                float sizeY = structureSize.func_177956_o();
                int nonReplaceableBlocks = 0;
                int x = 0;
                while ((float)x <= sizeX) {
                    int z = 0;
                    while ((float)z <= sizeZ) {
                        int y = 0;
                        while ((float)y <= sizeY) {
                            BlockPos newPos = pos.func_177982_a(x, y, z);
                            if (!world.func_180495_p(newPos).func_185904_a().func_76222_j()) {
                                ++nonReplaceableBlocks;
                            }
                            ++y;
                        }
                        ++z;
                    }
                    ++x;
                }
                if ((double)nonReplaceableBlocks >= (double)(sizeX * sizeY * sizeZ) * clearancePercentage) {
                    return pos;
                }
                pos = pos.func_177977_b();
            }
        }
        return null;
    }

    public static BlockPos getCeilingPos(World world, BlockPos pos, BlockPos structureSize, double clearancePercentage) {
        if (world.func_175707_a(pos, pos.func_177971_a((Vec3i)structureSize))) {
            while (pos.func_177956_o() < 128) {
                float sizeX = structureSize.func_177958_n() + 2;
                float sizeY = structureSize.func_177956_o() + 1;
                float sizeZ = structureSize.func_177952_p() + 2;
                int ceilingBlocks = 0;
                int replaceableBlocks = 0;
                int x = 0;
                while ((float)x <= sizeX) {
                    int z = 0;
                    while ((float)z <= sizeZ) {
                        int y = 0;
                        while ((float)y <= sizeY) {
                            BlockPos newPos = pos.func_177982_a(x, -y, z);
                            if (y == 0) {
                                if (world.func_180495_p(newPos).isSideSolid((IBlockAccess)world, newPos, EnumFacing.DOWN)) {
                                    ++ceilingBlocks;
                                }
                            } else if (world.func_180495_p(newPos).func_177230_c().func_176200_f((IBlockAccess)world, newPos)) {
                                ++replaceableBlocks;
                            }
                            ++y;
                        }
                        ++z;
                    }
                    ++x;
                }
                if ((double)(ceilingBlocks + replaceableBlocks) >= (double)(sizeX * sizeY * sizeZ) * clearancePercentage) {
                    return pos.func_177963_a(0.0, (double)(-sizeY), 0.0);
                }
                pos = pos.func_177984_a();
            }
        }
        return null;
    }
}

