/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.block;

import java.util.Random;
import logictechcorp.libraryex.block.BlockMod;
import logictechcorp.libraryex.block.property.BlockProperties;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockModSlab
extends BlockMod {
    public static final PropertyEnum<SlabType> TYPE = PropertyEnum.func_177709_a((String)"type", SlabType.class);
    protected static final AxisAlignedBB AABB_TOP_HALF = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_BOTTOM_HALF = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);

    public BlockModSlab(ResourceLocation registryName, BlockProperties properties) {
        super(registryName, properties);
        this.func_149713_g(255);
        this.field_149783_u = true;
    }

    public void func_149666_a(CreativeTabs creativeTab, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this, 1));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (this.isDouble(state)) {
            return super.func_176225_a(state, world, pos, side);
        }
        if (side != EnumFacing.UP && side != EnumFacing.DOWN && !super.func_176225_a(state, world, pos, side)) {
            return false;
        }
        return super.func_176225_a(state, world, pos, side);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (this.isDouble(state)) {
            return field_185505_j;
        }
        return state.func_177229_b(TYPE) == SlabType.TOP ? AABB_TOP_HALF : AABB_BOTTOM_HALF;
    }

    public boolean func_185481_k(IBlockState state) {
        return ((BlockModSlab)state.func_177230_c()).isDouble(state) || state.func_177229_b(TYPE) == SlabType.TOP;
    }

    public boolean func_149662_c(IBlockState state) {
        return this.isDouble(state);
    }

    public boolean func_149686_d(IBlockState state) {
        return state.func_177229_b(TYPE) == SlabType.DOUBLE;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (ForgeModContainer.disableStairSlabCulling) {
            return super.doesSideBlockRendering(state, world, pos, face);
        }
        if (state.func_185914_p()) {
            return true;
        }
        SlabType type = (SlabType)((Object)state.func_177229_b(TYPE));
        return type == SlabType.TOP && face == EnumFacing.UP || type == SlabType.BOTTOM && face == EnumFacing.DOWN;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        if (((BlockModSlab)state.func_177230_c()).isDouble(state)) {
            return BlockFaceShape.SOLID;
        }
        if (face == EnumFacing.UP && state.func_177229_b(TYPE) == SlabType.TOP) {
            return BlockFaceShape.SOLID;
        }
        return face == EnumFacing.DOWN && state.func_177229_b(TYPE) == SlabType.BOTTOM ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = this.func_176203_a(meta);
        return facing != EnumFacing.DOWN && (facing == EnumFacing.UP || (double)hitY <= 0.5) ? state.func_177226_a(TYPE, (Comparable)((Object)SlabType.BOTTOM)) : state.func_177226_a(TYPE, (Comparable)((Object)SlabType.TOP));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, this.func_180651_a(state));
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return state.func_177229_b(TYPE) == SlabType.DOUBLE ? 2 : 1;
    }

    public int func_180651_a(IBlockState state) {
        return SlabType.BOTTOM.ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)SlabType.fromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((SlabType)((Object)state.func_177229_b(TYPE))).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public boolean isSingle(IBlockState state) {
        return state.func_177230_c() == this && state != this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)SlabType.DOUBLE));
    }

    public boolean isDouble(IBlockState state) {
        return state.func_177230_c() == this && state == this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)SlabType.DOUBLE));
    }

    public static enum SlabType implements IStringSerializable
    {
        TOP("top"),
        BOTTOM("bottom"),
        DOUBLE("double");

        private final String name;

        private SlabType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static SlabType fromMeta(int meta) {
            if (meta < 0 || meta >= SlabType.values().length) {
                meta = 0;
            }
            return SlabType.values()[meta];
        }
    }
}

