/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.utility;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class EntityHelper {
    private static final Map<Class<? extends EntityLivingBase>, String> ENTITY_RESOURCE_LOCATION_CACHE = new HashMap<Class<? extends EntityLivingBase>, String>();

    public static String getEntityLocation(EntityLivingBase entity) {
        Class<?> cls = entity.getClass();
        return ENTITY_RESOURCE_LOCATION_CACHE.computeIfAbsent(cls, k -> {
            ResourceLocation location = EntityList.func_191306_a((Class)k);
            return location != null ? location.toString() : null;
        });
    }

    public static Entity getFromUUID(MinecraftServer server, UUID uuid) {
        if (server != null && uuid != null) {
            return server.func_175576_a(uuid);
        }
        return null;
    }

    public static boolean shouldAttackEntity(EntityLivingBase target, EntityLivingBase owner) {
        if (!(target instanceof EntityCreeper) && !(target instanceof EntityFlying)) {
            EntityWolf wolf;
            if (target instanceof EntityWolf && (wolf = (EntityWolf)target).func_70909_n() && wolf.func_70902_q() == owner) {
                return false;
            }
            if (target instanceof EntityPlayer && owner instanceof EntityPlayer && !((EntityPlayer)owner).func_96122_a((EntityPlayer)target)) {
                return false;
            }
            return !(target instanceof AbstractHorse) || !((AbstractHorse)target).func_110248_bS();
        }
        return false;
    }

    public static boolean isInBlock(Entity entity, IBlockState ... states) {
        AxisAlignedBB boundingBox = entity.func_174813_aQ().func_72314_b((double)-0.1f, (double)-0.4f, (double)-0.1f);
        int minX = MathHelper.func_76128_c((double)boundingBox.field_72340_a);
        int maxX = MathHelper.func_76143_f((double)boundingBox.field_72336_d);
        int minY = MathHelper.func_76128_c((double)boundingBox.field_72338_b);
        int maxY = MathHelper.func_76143_f((double)boundingBox.field_72337_e);
        int minZ = MathHelper.func_76128_c((double)boundingBox.field_72339_c);
        int maxZ = MathHelper.func_76143_f((double)boundingBox.field_72334_f);
        BlockPos.PooledMutableBlockPos pooledMutableBlockPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (int posX = minX; posX < maxX; ++posX) {
            for (int posY = minY; posY < maxY; ++posY) {
                for (int posZ = minZ; posZ < maxZ; ++posZ) {
                    IBlockState checkState = entity.func_130014_f_().func_180495_p((BlockPos)pooledMutableBlockPos.func_181079_c(posX, posY, posZ));
                    for (IBlockState state : states) {
                        if (state != checkState) continue;
                        pooledMutableBlockPos.func_185344_t();
                        return true;
                    }
                }
            }
        }
        pooledMutableBlockPos.func_185344_t();
        return false;
    }
}

