/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.utility;

import net.minecraft.entity.player.EntityPlayer;

public class ExperienceHelper {
    public static void adjustPlayerExperience(EntityPlayer player, int amount) {
        int experience;
        player.field_71067_cb = experience = ExperienceHelper.getPlayerExperience(player) + amount;
        player.field_71068_ca = ExperienceHelper.getLevelForExperience(experience);
        int experienceForLevel = ExperienceHelper.getExperienceForLevel(player.field_71068_ca);
        player.field_71106_cc = (float)(experience - experienceForLevel) / (float)player.func_71050_bK();
    }

    public static int getPlayerExperience(EntityPlayer player) {
        return (int)((float)ExperienceHelper.getExperienceForLevel(player.field_71068_ca) + player.field_71106_cc * (float)player.func_71050_bK());
    }

    public static int getLevelForExperience(int experience) {
        int level = 0;
        int levelExperienceCap;
        while (experience >= (levelExperienceCap = ExperienceHelper.getLevelExperienceCap(level))) {
            ++level;
            experience -= levelExperienceCap;
        }
        return level;
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level <= 15) {
            return ExperienceHelper.calculateExperience(level, 7, 2);
        }
        if (level <= 30) {
            return 315 + ExperienceHelper.calculateExperience(level - 15, 37, 5);
        }
        return 1395 + ExperienceHelper.calculateExperience(level - 30, 112, 9);
    }

    public static int getLevelExperienceCap(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    private static int calculateExperience(int level, int minimum, int multiplier) {
        return level * (2 * minimum + (level - 1) * multiplier) / 2;
    }
}

