/*
 * Decompiled with CFR 0.152.
 */
package mysticalmechanics;

import java.text.DecimalFormat;
import javax.annotation.Nullable;
import mysticalmechanics.IProxy;
import mysticalmechanics.api.DefaultMechCapability;
import mysticalmechanics.api.IGearBehavior;
import mysticalmechanics.api.IMechCapability;
import mysticalmechanics.api.IMechUnit;
import mysticalmechanics.api.MysticalMechanicsAPI;
import mysticalmechanics.api.lubricant.DefaultLubricantCapability;
import mysticalmechanics.api.lubricant.ILubricantCapability;
import mysticalmechanics.apiimpl.ConfigValue;
import mysticalmechanics.apiimpl.MysticalMechanicsAPIImpl;
import mysticalmechanics.compat.BetterWithMods;
import mysticalmechanics.compat.TheOneProbe;
import mysticalmechanics.handler.RegistryHandler;
import mysticalmechanics.handler.RightClickHandler;
import mysticalmechanics.util.FanBehavior;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreIngredient;

@Mod(modid="mysticalmechanics", acceptedMinecraftVersions="[1.12, 1.13)")
@Mod.EventBusSubscriber
public class MysticalMechanics {
    public static final String MODID = "mysticalmechanics";
    public static final String NAME = "Mystical Mechanics";
    @SidedProxy(clientSide="mysticalmechanics.ClientProxy", serverSide="mysticalmechanics.ServerProxy")
    public static IProxy proxy;
    @Mod.Instance(value="mysticalmechanics")
    public static MysticalMechanics instance;
    public static CreativeTabs creativeTab;
    public static Configuration config;
    public static String FORCE_UNIT;
    public static boolean RENDER_GEAR_HOLOGRAM;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        creativeTab = new CreativeTabs("mysticalmechanics.name"){

            public ItemStack func_78016_d() {
                return new ItemStack(RegistryHandler.IRON_GEAR);
            }
        };
        if (config == null) {
            config = new Configuration(event.getSuggestedConfigurationFile());
            this.loadConfig();
        }
        if (Loader.isModLoaded((String)"theoneprobe")) {
            TheOneProbe.init();
        }
        proxy.preInit();
        MysticalMechanicsAPIImpl impl = new MysticalMechanicsAPIImpl();
        impl.registerConfigValue(new ConfigValue<String>(String.class, "units.forceUnit"){

            @Override
            public String getValue() {
                return FORCE_UNIT;
            }

            @Override
            public void setValue(String value) {
                FORCE_UNIT = value;
            }
        });
        impl.registerConfigValue(new ConfigValue<Boolean>(Boolean.class, "render.renderGearHologram"){

            @Override
            public Boolean getValue() {
                return RENDER_GEAR_HOLOGRAM;
            }

            @Override
            public void setValue(Boolean value) {
                RENDER_GEAR_HOLOGRAM = value;
            }
        });
        MysticalMechanicsAPI.IMPL = impl;
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new RegistryHandler());
        MinecraftForge.EVENT_BUS.register((Object)new RightClickHandler());
        if (Loader.isModLoaded((String)"betterwithmods")) {
            MinecraftForge.EVENT_BUS.register((Object)new BetterWithMods());
        }
        CapabilityManager.INSTANCE.register(IMechCapability.class, (Capability.IStorage)new Capability.IStorage<IMechCapability>(){

            @Nullable
            public NBTBase writeNBT(Capability<IMechCapability> capability, IMechCapability instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability<IMechCapability> capability, IMechCapability instance, EnumFacing side, NBTBase nbt) {
            }
        }, DefaultMechCapability::new);
        CapabilityManager.INSTANCE.register(ILubricantCapability.class, (Capability.IStorage)new Capability.IStorage<ILubricantCapability>(){

            @Nullable
            public NBTBase writeNBT(Capability<ILubricantCapability> capability, ILubricantCapability instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability<ILubricantCapability> capability, ILubricantCapability instance, EnumFacing side, NBTBase nbt) {
            }
        }, DefaultLubricantCapability::new);
    }

    private void loadConfig() {
        FORCE_UNIT = config.getString("forceUnit", "units", "", "Set this to a non-empty string to force a specific unit.");
        RENDER_GEAR_HOLOGRAM = config.getBoolean("renderGearHologram", "render", true, "Whether gearboxes should render a hologram for inserted/extracted gears.");
        if (config.hasChanged()) {
            config.save();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        final DecimalFormat format = new DecimalFormat("0.##");
        MysticalMechanicsAPI.IMPL.registerUnit(new IMechUnit<Double>(){

            @Override
            public String getName() {
                return "default";
            }

            @Override
            public int getPriority() {
                return -999999;
            }

            @Override
            public double getZero() {
                return 0.0;
            }

            @Override
            public double getNeutral() {
                return 1.0;
            }

            @Override
            public double convertToPower(Double unit) {
                return unit;
            }

            @Override
            public Double convertToUnit(double power) {
                return power;
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public String format(double power) {
                return I18n.func_135052_a((String)"mysticalmechanics.unit.default", (Object[])new Object[]{format.format(power)});
            }
        });
        MysticalMechanicsAPI.IMPL.registerGear(new ResourceLocation(MODID, "gear_iron"), (Ingredient)new OreIngredient("gearIron"), new IGearBehavior(){

            @Override
            public double transformPower(TileEntity tile, @Nullable EnumFacing facing, ItemStack gear, double power) {
                return power;
            }
        });
        MysticalMechanicsAPI.IMPL.registerGear(new ResourceLocation(MODID, "gear_gold"), (Ingredient)new OreIngredient("gearGold"), new IGearBehavior(){

            @Override
            public double transformPower(TileEntity tile, @Nullable EnumFacing facing, ItemStack gear, double power) {
                return power;
            }
        });
        MysticalMechanicsAPI.IMPL.registerGear(new ResourceLocation(MODID, "gear_gold_on"), Ingredient.func_193367_a((Item)RegistryHandler.GOLD_GEAR_ON), new IGearBehavior(){

            @Override
            public double transformPower(TileEntity tile, @Nullable EnumFacing facing, ItemStack gear, double power) {
                boolean powered = tile.func_145831_w().func_175640_z(tile.func_174877_v());
                return !powered ? power : 0.0;
            }
        });
        MysticalMechanicsAPI.IMPL.registerGear(new ResourceLocation(MODID, "gear_gold_off"), Ingredient.func_193367_a((Item)RegistryHandler.GOLD_GEAR_OFF), new IGearBehavior(){

            @Override
            public double transformPower(TileEntity tile, @Nullable EnumFacing facing, ItemStack gear, double power) {
                boolean powered = tile.func_145831_w().func_175640_z(tile.func_174877_v());
                return powered ? power : 0.0;
            }
        });
        MysticalMechanicsAPI.IMPL.registerGear(new ResourceLocation(MODID, "gear_fan"), Ingredient.func_193367_a((Item)RegistryHandler.FAN), new FanBehavior());
    }
}

