/*
 * Decompiled with CFR 0.152.
 */
package mysticalmechanics.api;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mysticalmechanics.api.IGearBehavior;
import mysticalmechanics.api.IGearData;
import mysticalmechanics.api.MysticalMechanicsAPI;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class GearHelper {
    ItemStack gear = ItemStack.field_190927_a;
    IGearData data;

    public void setGear(ItemStack stack) {
        this.gear = stack;
        this.data = null;
        this.createData();
    }

    public ItemStack getGear() {
        return this.gear;
    }

    public IGearData getData() {
        return this.data;
    }

    @Nonnull
    public IGearBehavior getBehavior() {
        return MysticalMechanicsAPI.IMPL.getGearBehavior(this.gear);
    }

    public boolean isEmpty() {
        return this.gear.func_190926_b();
    }

    private void createData() {
        IGearBehavior behavior = this.getBehavior();
        this.data = behavior.createData();
    }

    public boolean isDirty() {
        return this.data != null && this.data.isDirty();
    }

    public void attach(@Nullable EntityPlayer player, ItemStack stack) {
        this.gear = stack;
        this.createData();
    }

    public ItemStack detach(@Nullable EntityPlayer player) {
        ItemStack removed = this.gear;
        this.gear = ItemStack.field_190927_a;
        this.data = null;
        return removed;
    }

    public boolean canAttach(ItemStack stack) {
        return true;
    }

    public boolean canDetach() {
        return true;
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.gear = new ItemStack(tag.func_74775_l("gear"));
        this.data = null;
        this.createData();
        if (this.data != null) {
            this.data.readFromNBT(tag.func_74775_l("data"));
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74782_a("gear", (NBTBase)this.gear.serializeNBT());
        if (this.data != null) {
            tag.func_74782_a("data", (NBTBase)this.data.writeToNBT(new NBTTagCompound()));
        }
        return tag;
    }
}

