/*
 * Decompiled with CFR 0.152.
 */
package mysticalmechanics.api;

import javax.annotation.Nullable;
import mysticalmechanics.api.IGearData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public interface IGearBehavior {
    public static final IGearBehavior NO_BEHAVIOR = new IGearBehavior(){

        @Override
        public double transformPower(TileEntity tile, @Nullable EnumFacing facing, ItemStack gear, IGearData data, double power) {
            return power;
        }
    };

    default public void onAttach(TileEntity tile, @Nullable EnumFacing facing, ItemStack gear, IGearData data, EntityPlayer player) {
    }

    default public ItemStack onDetach(TileEntity tile, @Nullable EnumFacing facing, ItemStack gear, IGearData data, EntityPlayer player) {
        return gear;
    }

    default public double transformPower(TileEntity tile, @Nullable EnumFacing facing, ItemStack gear, double power) {
        return this.transformPower(tile, facing, gear, null, power);
    }

    default public double transformPower(TileEntity tile, @Nullable EnumFacing facing, ItemStack gear, IGearData data, double power) {
        return this.transformPower(tile, facing, gear, power);
    }

    default public double transformVisualPower(TileEntity tile, @Nullable EnumFacing facing, ItemStack gear, double power) {
        return this.transformPower(tile, facing, gear, power);
    }

    default public double transformVisualPower(TileEntity tile, @Nullable EnumFacing facing, ItemStack gear, IGearData data, double power) {
        return this.transformVisualPower(tile, facing, gear, power);
    }

    @Deprecated
    default public void visualUpdate(TileEntity tile, @Nullable EnumFacing facing, ItemStack gear) {
    }

    default public void visualUpdate(TileEntity tile, @Nullable EnumFacing facing, ItemStack gear, IGearData data, double powerIn, double powerOut) {
        this.visualUpdate(tile, facing, gear);
    }

    default public boolean canTick(ItemStack gear) {
        return false;
    }

    @Deprecated
    default public void tick(TileEntity tile, @Nullable EnumFacing facing, ItemStack gear, double power) {
    }

    default public void tick(TileEntity tile, @Nullable EnumFacing facing, ItemStack gear, IGearData data, double powerIn, double powerOut) {
        this.tick(tile, facing, gear, powerIn);
    }

    default public boolean hasData() {
        return false;
    }

    default public IGearData createData() {
        return null;
    }
}

