/*
 * Decompiled with CFR 0.152.
 */
package mysticalmechanics.api;

import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mysticalmechanics.api.IConfigValue;
import mysticalmechanics.api.IGearBehavior;
import mysticalmechanics.api.IMechCapability;
import mysticalmechanics.api.IMechUnit;
import mysticalmechanics.api.lubricant.ILubricant;
import mysticalmechanics.api.lubricant.SimpleLubricant;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public interface IMysticalMechanicsAPI {
    public void registerGear(ResourceLocation var1, Ingredient var2, IGearBehavior var3);

    public void unregisterGear(ResourceLocation var1);

    public void modifyGear(ResourceLocation var1, Function<IGearBehavior, IGearBehavior> var2);

    public Iterable<ResourceLocation> getGearKeys();

    @Nonnull
    public IGearBehavior getGearBehavior(ItemStack var1);

    @Nonnull
    public IGearBehavior getGearBehavior(ResourceLocation var1);

    public boolean isValidGear(ItemStack var1);

    public void registerLubricant(ResourceLocation var1, Function<NBTTagCompound, ILubricant> var2);

    public void registerSimpleLubricant(SimpleLubricant var1);

    public void unregisterLubricant(ResourceLocation var1);

    public ILubricant deserializeLubricant(NBTTagCompound var1);

    public void registerUnit(IMechUnit var1);

    public IMechUnit getDefaultUnit();

    public IMechUnit getUnit(String var1);

    public Iterable<IMechUnit> getUnits();

    public Map<String, IConfigValue> getConfigValues();

    public IConfigValue getConfigValue(String var1);

    public CreativeTabs getCreativeTab();

    public void pushPower(TileEntity var1, EnumFacing var2, IMechCapability var3, boolean var4);

    public void pullPower(TileEntity var1, EnumFacing var2, IMechCapability var3, boolean var4);

    public boolean isGearHit(TileEntity var1, EnumFacing var2);

    public boolean shouldRenderHologram(ItemStack var1, boolean var2, boolean var3, boolean var4);

    public void renderGear(ItemStack var1, ItemStack var2, boolean var3, float var4, double var5, double var7, float var9);

    public void renderAxle(ModelResourceLocation var1, EnumFacing.Axis var2, float var3);

    public void syncAngle(TileEntity var1, EnumFacing var2);
}

